// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the sign-in credentials for the container image registry of an Amazon Lightsail account.
 */
public class ContainerServiceRegistryLogin private constructor(builder: Builder) {
    /**
     * The timestamp of when the container image registry sign-in credentials expire.
     *
     * The log in credentials expire 12 hours after they are created, at which point you will need to create a new set of log in credentials using the `CreateContainerServiceRegistryLogin` action.
     */
    public val expiresAt: aws.smithy.kotlin.runtime.time.Instant? = builder.expiresAt
    /**
     * The container service registry password to use to push container images to the container image registry of a Lightsail account
     */
    public val password: kotlin.String? = builder.password
    /**
     * The address to use to push container images to the container image registry of a Lightsail account.
     */
    public val registry: kotlin.String? = builder.registry
    /**
     * The container service registry username to use to push container images to the container image registry of a Lightsail account.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ContainerServiceRegistryLogin = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerServiceRegistryLogin(")
        append("expiresAt=$expiresAt,")
        append("password=$password,")
        append("registry=$registry,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = expiresAt?.hashCode() ?: 0
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (registry?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerServiceRegistryLogin

        if (expiresAt != other.expiresAt) return false
        if (password != other.password) return false
        if (registry != other.registry) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ContainerServiceRegistryLogin = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the container image registry sign-in credentials expire.
         *
         * The log in credentials expire 12 hours after they are created, at which point you will need to create a new set of log in credentials using the `CreateContainerServiceRegistryLogin` action.
         */
        public var expiresAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The container service registry password to use to push container images to the container image registry of a Lightsail account
         */
        public var password: kotlin.String? = null
        /**
         * The address to use to push container images to the container image registry of a Lightsail account.
         */
        public var registry: kotlin.String? = null
        /**
         * The container service registry username to use to push container images to the container image registry of a Lightsail account.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ContainerServiceRegistryLogin) : this() {
            this.expiresAt = x.expiresAt
            this.password = x.password
            this.registry = x.registry
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ContainerServiceRegistryLogin = ContainerServiceRegistryLogin(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
