// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a container deployment configuration of an Amazon Lightsail container service.
 *
 * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to your container service.
 */
public class ContainerServiceDeploymentRequest private constructor(builder: Builder) {
    /**
     * An object that describes the configuration for the containers of the deployment.
     */
    public val containers: Map<String, Container>? = builder.containers
    /**
     * An object that describes the endpoint of the deployment.
     */
    public val publicEndpoint: aws.sdk.kotlin.services.lightsail.model.EndpointRequest? = builder.publicEndpoint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerServiceDeploymentRequest(")
        append("containers=$containers,")
        append("publicEndpoint=$publicEndpoint")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containers?.hashCode() ?: 0
        result = 31 * result + (publicEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerServiceDeploymentRequest

        if (containers != other.containers) return false
        if (publicEndpoint != other.publicEndpoint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object that describes the configuration for the containers of the deployment.
         */
        public var containers: Map<String, Container>? = null
        /**
         * An object that describes the endpoint of the deployment.
         */
        public var publicEndpoint: aws.sdk.kotlin.services.lightsail.model.EndpointRequest? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest) : this() {
            this.containers = x.containers
            this.publicEndpoint = x.publicEndpoint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest = ContainerServiceDeploymentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.EndpointRequest] inside the given [block]
         */
        public fun publicEndpoint(block: aws.sdk.kotlin.services.lightsail.model.EndpointRequest.Builder.() -> kotlin.Unit) {
            this.publicEndpoint = aws.sdk.kotlin.services.lightsail.model.EndpointRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
