// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a container deployment configuration of an Amazon Lightsail container service.
 *
 * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to your container service.
 */
public class ContainerServiceDeployment private constructor(builder: Builder) {
    /**
     * An object that describes the configuration for the containers of the deployment.
     */
    public val containers: Map<String, Container>? = builder.containers
    /**
     * The timestamp when the deployment was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An object that describes the endpoint of the deployment.
     */
    public val publicEndpoint: aws.sdk.kotlin.services.lightsail.model.ContainerServiceEndpoint? = builder.publicEndpoint
    /**
     * The state of the deployment.
     *
     * A deployment can be in one of the following states:
     * + `ACTIVATING` - The deployment is being created.
     * + `ACTIVE` - The deployment was successfully created, and it's currently running on the container service. The container service can have only one deployment in an active state at a time.
     * + `INACTIVE` - The deployment was previously successfully created, but it is not currently running on the container service.
     * + `FAILED` - The deployment failed. Use the `GetContainerLog` action to view the log events for the containers in the deployment to try to determine the reason for the failure.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentState? = builder.state
    /**
     * The version number of the deployment.
     */
    public val version: kotlin.Int? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerServiceDeployment(")
        append("containers=$containers,")
        append("createdAt=$createdAt,")
        append("publicEndpoint=$publicEndpoint,")
        append("state=$state,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containers?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (publicEndpoint?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (version ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerServiceDeployment

        if (containers != other.containers) return false
        if (createdAt != other.createdAt) return false
        if (publicEndpoint != other.publicEndpoint) return false
        if (state != other.state) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object that describes the configuration for the containers of the deployment.
         */
        public var containers: Map<String, Container>? = null
        /**
         * The timestamp when the deployment was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the endpoint of the deployment.
         */
        public var publicEndpoint: aws.sdk.kotlin.services.lightsail.model.ContainerServiceEndpoint? = null
        /**
         * The state of the deployment.
         *
         * A deployment can be in one of the following states:
         * + `ACTIVATING` - The deployment is being created.
         * + `ACTIVE` - The deployment was successfully created, and it's currently running on the container service. The container service can have only one deployment in an active state at a time.
         * + `INACTIVE` - The deployment was previously successfully created, but it is not currently running on the container service.
         * + `FAILED` - The deployment failed. Use the `GetContainerLog` action to view the log events for the containers in the deployment to try to determine the reason for the failure.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentState? = null
        /**
         * The version number of the deployment.
         */
        public var version: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment) : this() {
            this.containers = x.containers
            this.createdAt = x.createdAt
            this.publicEndpoint = x.publicEndpoint
            this.state = x.state
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeployment = ContainerServiceDeployment(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ContainerServiceEndpoint] inside the given [block]
         */
        public fun publicEndpoint(block: aws.sdk.kotlin.services.lightsail.model.ContainerServiceEndpoint.Builder.() -> kotlin.Unit) {
            this.publicEndpoint = aws.sdk.kotlin.services.lightsail.model.ContainerServiceEndpoint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
