// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the default cache behavior of an Amazon Lightsail content delivery network (CDN) distribution.
 */
public class CacheBehavior private constructor(builder: Builder) {
    /**
     * The cache behavior of the distribution.
     *
     * The following cache behaviors can be specified:
     * + **`cache`** - This option is best for static sites. When specified, your distribution caches and serves your entire website as static content. This behavior is ideal for websites with static content that doesn't change depending on who views it, or for websites that don't use cookies, headers, or query strings to personalize content.
     * + **`dont-cache`** - This option is best for sites that serve a mix of static and dynamic content. When specified, your distribution caches and serve only the content that is specified in the distribution's `CacheBehaviorPerPath` parameter. This behavior is ideal for websites or web applications that use cookies, headers, and query strings to personalize content for individual users.
     */
    public val behavior: aws.sdk.kotlin.services.lightsail.model.BehaviorEnum? = builder.behavior

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CacheBehavior = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheBehavior(")
        append("behavior=$behavior")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = behavior?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheBehavior

        if (behavior != other.behavior) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CacheBehavior = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The cache behavior of the distribution.
         *
         * The following cache behaviors can be specified:
         * + **`cache`** - This option is best for static sites. When specified, your distribution caches and serves your entire website as static content. This behavior is ideal for websites with static content that doesn't change depending on who views it, or for websites that don't use cookies, headers, or query strings to personalize content.
         * + **`dont-cache`** - This option is best for sites that serve a mix of static and dynamic content. When specified, your distribution caches and serve only the content that is specified in the distribution's `CacheBehaviorPerPath` parameter. This behavior is ideal for websites or web applications that use cookies, headers, and query strings to personalize content for individual users.
         */
        public var behavior: aws.sdk.kotlin.services.lightsail.model.BehaviorEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CacheBehavior) : this() {
            this.behavior = x.behavior
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CacheBehavior = CacheBehavior(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
