// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the anonymous access permissions for an Amazon Lightsail bucket and its objects.
 *
 * For more information about bucket access permissions, see [Understanding bucket permissions in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-understanding-bucket-permissions) in the
 *
 * *Amazon Lightsail Developer Guide*.
 */
public class AccessRules private constructor(builder: Builder) {
    /**
     * A Boolean value that indicates whether the access control list (ACL) permissions that are applied to individual objects override the `getObject` option that is currently specified.
     *
     * When this is true, you can use the [PutObjectAcl](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html) Amazon S3 API action to set individual objects to public (read-only) using the `public-read` ACL, or to private using the `private` ACL.
     */
    public val allowPublicOverrides: kotlin.Boolean? = builder.allowPublicOverrides
    /**
     * Specifies the anonymous access to all objects in a bucket.
     *
     * The following options can be specified:
     * + `public` - Sets all objects in the bucket to public (read-only), making them readable by anyone in the world.If the `getObject` value is set to `public`, then all objects in the bucket default to public regardless of the `allowPublicOverrides` value.
     * + `private` - Sets all objects in the bucket to private, making them readable only by you or anyone you give access to.If the `getObject` value is set to `private`, and the `allowPublicOverrides` value is set to `true`, then all objects in the bucket default to private unless they are configured with a `public-read` ACL. Individual objects with a `public-read` ACL are readable by anyone in the world.
     */
    public val getObject: aws.sdk.kotlin.services.lightsail.model.AccessType? = builder.getObject

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.AccessRules = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessRules(")
        append("allowPublicOverrides=$allowPublicOverrides,")
        append("getObject=$getObject")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowPublicOverrides?.hashCode() ?: 0
        result = 31 * result + (getObject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessRules

        if (allowPublicOverrides != other.allowPublicOverrides) return false
        if (getObject != other.getObject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.AccessRules = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Boolean value that indicates whether the access control list (ACL) permissions that are applied to individual objects override the `getObject` option that is currently specified.
         *
         * When this is true, you can use the [PutObjectAcl](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html) Amazon S3 API action to set individual objects to public (read-only) using the `public-read` ACL, or to private using the `private` ACL.
         */
        public var allowPublicOverrides: kotlin.Boolean? = null
        /**
         * Specifies the anonymous access to all objects in a bucket.
         *
         * The following options can be specified:
         * + `public` - Sets all objects in the bucket to public (read-only), making them readable by anyone in the world.If the `getObject` value is set to `public`, then all objects in the bucket default to public regardless of the `allowPublicOverrides` value.
         * + `private` - Sets all objects in the bucket to private, making them readable only by you or anyone you give access to.If the `getObject` value is set to `private`, and the `allowPublicOverrides` value is set to `true`, then all objects in the bucket default to private unless they are configured with a `public-read` ACL. Individual objects with a `public-read` ACL are readable by anyone in the world.
         */
        public var getObject: aws.sdk.kotlin.services.lightsail.model.AccessType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.AccessRules) : this() {
            this.allowPublicOverrides = x.allowPublicOverrides
            this.getObject = x.getObject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.AccessRules = AccessRules(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
