// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.lightsail.auth.LightsailAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.lightsail.auth.LightsailIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.lightsail.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.lightsail.model.*
import aws.sdk.kotlin.services.lightsail.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultLightsailClient(override val config: LightsailClient.Config) : LightsailClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = LightsailIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "lightsail")
        }
        toMap()
    }
    private val authSchemeAdapter = LightsailAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.lightsail"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Allocates a static IP address.
     */
    override suspend fun allocateStaticIp(input: AllocateStaticIpRequest): AllocateStaticIpResponse {
        val op = SdkHttpOperation.build<AllocateStaticIpRequest, AllocateStaticIpResponse> {
            serializeWith = AllocateStaticIpOperationSerializer()
            deserializeWith = AllocateStaticIpOperationDeserializer()
            operationName = "AllocateStaticIp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * After the certificate is attached, your distribution accepts HTTPS traffic for all of the domains that are associated with the certificate.
     *
     * Use the `CreateCertificate` action to create a certificate that you can attach to your distribution.
     *
     * Only certificates created in the `us-east-1` Amazon Web Services Region can be attached to Lightsail distributions. Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
     */
    override suspend fun attachCertificateToDistribution(input: AttachCertificateToDistributionRequest): AttachCertificateToDistributionResponse {
        val op = SdkHttpOperation.build<AttachCertificateToDistributionRequest, AttachCertificateToDistributionResponse> {
            serializeWith = AttachCertificateToDistributionOperationSerializer()
            deserializeWith = AttachCertificateToDistributionOperationDeserializer()
            operationName = "AttachCertificateToDistribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the specified disk name.
     *
     * The `attach disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun attachDisk(input: AttachDiskRequest): AttachDiskResponse {
        val op = SdkHttpOperation.build<AttachDiskRequest, AttachDiskResponse> {
            serializeWith = AttachDiskOperationSerializer()
            deserializeWith = AttachDiskOperationDeserializer()
            operationName = "AttachDisk"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches one or more Lightsail instances to a load balancer.
     *
     * After some time, the instances are attached to the load balancer and the health check status is available.
     *
     * The `attach instances to load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun attachInstancesToLoadBalancer(input: AttachInstancesToLoadBalancerRequest): AttachInstancesToLoadBalancerResponse {
        val op = SdkHttpOperation.build<AttachInstancesToLoadBalancerRequest, AttachInstancesToLoadBalancerResponse> {
            serializeWith = AttachInstancesToLoadBalancerOperationSerializer()
            deserializeWith = AttachInstancesToLoadBalancerOperationDeserializer()
            operationName = "AttachInstancesToLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     *
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API to rotate the certificates on your account. Use the `AttachLoadBalancerTlsCertificate` action with the non-attached certificate, and it will replace the existing one and become the attached certificate.
     *
     * The `AttachLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun attachLoadBalancerTlsCertificate(input: AttachLoadBalancerTlsCertificateRequest): AttachLoadBalancerTlsCertificateResponse {
        val op = SdkHttpOperation.build<AttachLoadBalancerTlsCertificateRequest, AttachLoadBalancerTlsCertificateResponse> {
            serializeWith = AttachLoadBalancerTlsCertificateOperationSerializer()
            deserializeWith = AttachLoadBalancerTlsCertificateOperationDeserializer()
            operationName = "AttachLoadBalancerTlsCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     */
    override suspend fun attachStaticIp(input: AttachStaticIpRequest): AttachStaticIpResponse {
        val op = SdkHttpOperation.build<AttachStaticIpRequest, AttachStaticIpResponse> {
            serializeWith = AttachStaticIpOperationSerializer()
            deserializeWith = AttachStaticIpOperationDeserializer()
            operationName = "AttachStaticIp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Closes ports for a specific Amazon Lightsail instance.
     *
     * The `CloseInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun closeInstancePublicPorts(input: CloseInstancePublicPortsRequest): CloseInstancePublicPortsResponse {
        val op = SdkHttpOperation.build<CloseInstancePublicPortsRequest, CloseInstancePublicPortsResponse> {
            serializeWith = CloseInstancePublicPortsOperationSerializer()
            deserializeWith = CloseInstancePublicPortsOperationDeserializer()
            operationName = "CloseInstancePublicPorts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of an instance or a disk from one Amazon Web Services Region to another in Amazon Lightsail.
     *
     * When copying a *manual snapshot*, be sure to define the `source region`, `source snapshot name`, and `target snapshot name` parameters.
     *
     * When copying an *automatic snapshot*, be sure to define the `source region`, `source resource name`, `target snapshot name`, and either the `restore date` or the `use latest restorable auto snapshot` parameters.
     */
    override suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse {
        val op = SdkHttpOperation.build<CopySnapshotRequest, CopySnapshotResponse> {
            serializeWith = CopySnapshotOperationSerializer()
            deserializeWith = CopySnapshotOperationDeserializer()
            operationName = "CopySnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Lightsail bucket.
     *
     * A bucket is a cloud storage resource available in the Lightsail object storage service. Use buckets to store objects such as data and its descriptive metadata. For more information about buckets, see [Buckets in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun createBucket(input: CreateBucketRequest): CreateBucketResponse {
        val op = SdkHttpOperation.build<CreateBucketRequest, CreateBucketResponse> {
            serializeWith = CreateBucketOperationSerializer()
            deserializeWith = CreateBucketOperationDeserializer()
            operationName = "CreateBucket"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new access key for the specified Amazon Lightsail bucket. Access keys consist of an access key ID and corresponding secret access key.
     *
     * Access keys grant full programmatic access to the specified bucket and its objects. You can have a maximum of two access keys per bucket. Use the [GetBucketAccessKeys](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketAccessKeys.html) action to get a list of current access keys for a specific bucket. For more information about access keys, see [Creating access keys for a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys) in the *Amazon Lightsail Developer Guide*.
     *
     * The `secretAccessKey` value is returned only in response to the `CreateBucketAccessKey` action. You can get a secret access key only when you first create an access key; you cannot get the secret access key later. If you lose the secret access key, you must create a new access key.
     */
    override suspend fun createBucketAccessKey(input: CreateBucketAccessKeyRequest): CreateBucketAccessKeyResponse {
        val op = SdkHttpOperation.build<CreateBucketAccessKeyRequest, CreateBucketAccessKeyResponse> {
            serializeWith = CreateBucketAccessKeyOperationSerializer()
            deserializeWith = CreateBucketAccessKeyOperationDeserializer()
            operationName = "CreateBucketAccessKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN) distribution and a container service.
     *
     * After the certificate is valid, use the `AttachCertificateToDistribution` action to use the certificate and its domains with your distribution. Or use the `UpdateContainerService` action to use the certificate and its domains with your container service.
     *
     * Only certificates created in the `us-east-1` Amazon Web Services Region can be attached to Lightsail distributions. Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
     */
    override suspend fun createCertificate(input: CreateCertificateRequest): CreateCertificateResponse {
        val op = SdkHttpOperation.build<CreateCertificateRequest, CreateCertificateResponse> {
            serializeWith = CreateCertificateOperationSerializer()
            deserializeWith = CreateCertificateOperationDeserializer()
            operationName = "CreateCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported Amazon Lightsail snapshot. This operation results in a CloudFormation stack record that can be used to track the AWS CloudFormation stack created. Use the `get cloud formation stack records` operation to get a list of the CloudFormation stacks created.
     *
     * Wait until after your new Amazon EC2 instance is created before running the `create cloud formation stack` operation again with the same export snapshot record.
     */
    override suspend fun createCloudFormationStack(input: CreateCloudFormationStackRequest): CreateCloudFormationStackResponse {
        val op = SdkHttpOperation.build<CreateCloudFormationStackRequest, CreateCloudFormationStackResponse> {
            serializeWith = CreateCloudFormationStackOperationSerializer()
            deserializeWith = CreateCloudFormationStackOperationDeserializer()
            operationName = "CreateCloudFormationStack"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an email or SMS text message contact method.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    override suspend fun createContactMethod(input: CreateContactMethodRequest): CreateContactMethodResponse {
        val op = SdkHttpOperation.build<CreateContactMethodRequest, CreateContactMethodResponse> {
            serializeWith = CreateContactMethodOperationSerializer()
            deserializeWith = CreateContactMethodOperationDeserializer()
            operationName = "CreateContactMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Lightsail container service.
     *
     * A Lightsail container service is a compute resource to which you can deploy containers. For more information, see [Container services in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services) in the *Lightsail Dev Guide*.
     */
    override suspend fun createContainerService(input: CreateContainerServiceRequest): CreateContainerServiceResponse {
        val op = SdkHttpOperation.build<CreateContainerServiceRequest, CreateContainerServiceResponse> {
            serializeWith = CreateContainerServiceOperationSerializer()
            deserializeWith = CreateContainerServiceOperationDeserializer()
            operationName = "CreateContainerService"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a deployment for your Amazon Lightsail container service.
     *
     * A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration.
     *
     * You can deploy containers to your container service using container images from a public registry such as Amazon ECR Public, or from your local machine. For more information, see [Creating container images for your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-images) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun createContainerServiceDeployment(input: CreateContainerServiceDeploymentRequest): CreateContainerServiceDeploymentResponse {
        val op = SdkHttpOperation.build<CreateContainerServiceDeploymentRequest, CreateContainerServiceDeploymentResponse> {
            serializeWith = CreateContainerServiceDeploymentOperationSerializer()
            deserializeWith = CreateContainerServiceDeploymentOperationDeserializer()
            operationName = "CreateContainerServiceDeployment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a temporary set of log in credentials that you can use to log in to the Docker process on your local machine. After you're logged in, you can use the native Docker commands to push your local container images to the container image registry of your Amazon Lightsail account so that you can use them with your Lightsail container service. The log in credentials expire 12 hours after they are created, at which point you will need to create a new set of log in credentials.
     *
     * You can only push container images to the container service registry of your Lightsail account. You cannot pull container images or perform any other container image management actions on the container service registry.
     *
     * After you push your container images to the container image registry of your Lightsail account, use the `RegisterContainerImage` action to register the pushed images to a specific Lightsail container service.
     *
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container images to your Lightsail container service. For more information, see [Pushing and managing container images on your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun createContainerServiceRegistryLogin(input: CreateContainerServiceRegistryLoginRequest): CreateContainerServiceRegistryLoginResponse {
        val op = SdkHttpOperation.build<CreateContainerServiceRegistryLoginRequest, CreateContainerServiceRegistryLoginResponse> {
            serializeWith = CreateContainerServiceRegistryLoginOperationSerializer()
            deserializeWith = CreateContainerServiceRegistryLoginOperationDeserializer()
            operationName = "CreateContainerServiceRegistryLogin"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone (`us-east-2a`).
     *
     * The `create disk` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDisk(input: CreateDiskRequest): CreateDiskResponse {
        val op = SdkHttpOperation.build<CreateDiskRequest, CreateDiskResponse> {
            serializeWith = CreateDiskOperationSerializer()
            deserializeWith = CreateDiskOperationDeserializer()
            operationName = "CreateDisk"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to an Amazon Lightsail instance in the same Availability Zone (`us-east-2a`).
     *
     * The `create disk from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `disk snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDiskFromSnapshot(input: CreateDiskFromSnapshotRequest): CreateDiskFromSnapshotResponse {
        val op = SdkHttpOperation.build<CreateDiskFromSnapshotRequest, CreateDiskFromSnapshotResponse> {
            serializeWith = CreateDiskFromSnapshotOperationSerializer()
            deserializeWith = CreateDiskFromSnapshotOperationDeserializer()
            operationName = "CreateDiskFromSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to save data before shutting down a Lightsail instance.
     *
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the disk long enough to take a snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the snapshot status is pending.
     *
     * You can also use this operation to create a snapshot of an instance's system volume. You might want to do this, for example, to recover data from the system volume of a botched instance or to create a backup of the system volume like you would for a block storage disk. To create a snapshot of a system volume, just define the `instance name` parameter when issuing the snapshot command, and a snapshot of the defined instance's system volume will be created. After the snapshot is available, you can create a block storage disk from the snapshot and attach it to a running instance to access the data on the disk.
     *
     * The `create disk snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDiskSnapshot(input: CreateDiskSnapshotRequest): CreateDiskSnapshotResponse {
        val op = SdkHttpOperation.build<CreateDiskSnapshotRequest, CreateDiskSnapshotResponse> {
            serializeWith = CreateDiskSnapshotOperationSerializer()
            deserializeWith = CreateDiskSnapshotOperationDeserializer()
            operationName = "CreateDiskSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Lightsail content delivery network (CDN) distribution.
     *
     * A distribution is a globally distributed network of caching servers that improve the performance of your website or web application hosted on a Lightsail instance. For more information, see [Content delivery networks in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-content-delivery-network-distributions).
     */
    override suspend fun createDistribution(input: CreateDistributionRequest): CreateDistributionResponse {
        val op = SdkHttpOperation.build<CreateDistributionRequest, CreateDistributionResponse> {
            serializeWith = CreateDistributionOperationSerializer()
            deserializeWith = CreateDistributionOperationDeserializer()
            operationName = "CreateDistribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a domain resource for the specified domain (example.com).
     *
     * The `create domain` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse {
        val op = SdkHttpOperation.build<CreateDomainRequest, CreateDomainResponse> {
            serializeWith = CreateDomainOperationSerializer()
            deserializeWith = CreateDomainOperationDeserializer()
            operationName = "CreateDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates one of the following domain name system (DNS) records in a domain DNS zone: Address (A), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     *
     * The `create domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createDomainEntry(input: CreateDomainEntryRequest): CreateDomainEntryResponse {
        val op = SdkHttpOperation.build<CreateDomainEntryRequest, CreateDomainEntryResponse> {
            serializeWith = CreateDomainEntryOperationSerializer()
            deserializeWith = CreateDomainEntryOperationDeserializer()
            operationName = "CreateDomainEntry"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates two URLs that are used to access a virtual computer’s graphical user interface (GUI) session. The primary URL initiates a web-based NICE DCV session to the virtual computer's application. The secondary URL initiates a web-based NICE DCV session to the virtual computer's operating session.
     *
     * Use `StartGUISession` to open the session.
     */
    override suspend fun createGuiSessionAccessDetails(input: CreateGuiSessionAccessDetailsRequest): CreateGuiSessionAccessDetailsResponse {
        val op = SdkHttpOperation.build<CreateGuiSessionAccessDetailsRequest, CreateGuiSessionAccessDetailsResponse> {
            serializeWith = CreateGUISessionAccessDetailsOperationSerializer()
            deserializeWith = CreateGUISessionAccessDetailsOperationDeserializer()
            operationName = "CreateGUISessionAccessDetails"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of a specific virtual private server, or *instance*. You can use a snapshot to create a new instance that is based on that snapshot.
     *
     * The `create instance snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createInstanceSnapshot(input: CreateInstanceSnapshotRequest): CreateInstanceSnapshotResponse {
        val op = SdkHttpOperation.build<CreateInstanceSnapshotRequest, CreateInstanceSnapshotResponse> {
            serializeWith = CreateInstanceSnapshotOperationSerializer()
            deserializeWith = CreateInstanceSnapshotOperationDeserializer()
            operationName = "CreateInstanceSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates one or more Amazon Lightsail instances.
     *
     * The `create instances` operation supports tag-based access control via request tags. For more information, see the [Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createInstances(input: CreateInstancesRequest): CreateInstancesResponse {
        val op = SdkHttpOperation.build<CreateInstancesRequest, CreateInstancesResponse> {
            serializeWith = CreateInstancesOperationSerializer()
            deserializeWith = CreateInstancesOperationDeserializer()
            operationName = "CreateInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates one or more new instances from a manual or automatic snapshot of an instance.
     *
     * The `create instances from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `instance snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createInstancesFromSnapshot(input: CreateInstancesFromSnapshotRequest): CreateInstancesFromSnapshotResponse {
        val op = SdkHttpOperation.build<CreateInstancesFromSnapshotRequest, CreateInstancesFromSnapshotResponse> {
            serializeWith = CreateInstancesFromSnapshotOperationSerializer()
            deserializeWith = CreateInstancesFromSnapshotOperationDeserializer()
            operationName = "CreateInstancesFromSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom SSH key pair that you can use with an Amazon Lightsail instance.
     *
     * Use the [DownloadDefaultKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DownloadDefaultKeyPair.html) action to create a Lightsail default key pair in an Amazon Web Services Region where a default key pair does not currently exist.
     *
     * The `create key pair` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createKeyPair(input: CreateKeyPairRequest): CreateKeyPairResponse {
        val op = SdkHttpOperation.build<CreateKeyPairRequest, CreateKeyPairResponse> {
            serializeWith = CreateKeyPairOperationSerializer()
            deserializeWith = CreateKeyPairOperationDeserializer()
            operationName = "CreateKeyPair"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see [Configure your Lightsail instances for load balancing](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/configure-lightsail-instances-for-load-balancing). You can create up to 5 load balancers per AWS Region in your account.
     *
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load balancer settings, use the `UpdateLoadBalancerAttribute` operation.
     *
     * The `create load balancer` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerRequest, CreateLoadBalancerResponse> {
            serializeWith = CreateLoadBalancerOperationSerializer()
            deserializeWith = CreateLoadBalancerOperationDeserializer()
            operationName = "CreateLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an SSL/TLS certificate for an Amazon Lightsail load balancer.
     *
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     *
     * The `CreateLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createLoadBalancerTlsCertificate(input: CreateLoadBalancerTlsCertificateRequest): CreateLoadBalancerTlsCertificateResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerTlsCertificateRequest, CreateLoadBalancerTlsCertificateResponse> {
            serializeWith = CreateLoadBalancerTlsCertificateOperationSerializer()
            deserializeWith = CreateLoadBalancerTlsCertificateOperationDeserializer()
            operationName = "CreateLoadBalancerTlsCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new database in Amazon Lightsail.
     *
     * The `create relational database` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createRelationalDatabase(input: CreateRelationalDatabaseRequest): CreateRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<CreateRelationalDatabaseRequest, CreateRelationalDatabaseResponse> {
            serializeWith = CreateRelationalDatabaseOperationSerializer()
            deserializeWith = CreateRelationalDatabaseOperationDeserializer()
            operationName = "CreateRelationalDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new database from an existing database snapshot in Amazon Lightsail.
     *
     * You can create a new database from a snapshot in if something goes wrong with your original database, or to change it to a different plan, such as a high availability or standard plan.
     *
     * The `create relational database from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by relationalDatabaseSnapshotName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createRelationalDatabaseFromSnapshot(input: CreateRelationalDatabaseFromSnapshotRequest): CreateRelationalDatabaseFromSnapshotResponse {
        val op = SdkHttpOperation.build<CreateRelationalDatabaseFromSnapshotRequest, CreateRelationalDatabaseFromSnapshotResponse> {
            serializeWith = CreateRelationalDatabaseFromSnapshotOperationSerializer()
            deserializeWith = CreateRelationalDatabaseFromSnapshotOperationDeserializer()
            operationName = "CreateRelationalDatabaseFromSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a database, and to save data before deleting a database.
     *
     * The `create relational database snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun createRelationalDatabaseSnapshot(input: CreateRelationalDatabaseSnapshotRequest): CreateRelationalDatabaseSnapshotResponse {
        val op = SdkHttpOperation.build<CreateRelationalDatabaseSnapshotRequest, CreateRelationalDatabaseSnapshotResponse> {
            serializeWith = CreateRelationalDatabaseSnapshotOperationSerializer()
            deserializeWith = CreateRelationalDatabaseSnapshotOperationDeserializer()
            operationName = "CreateRelationalDatabaseSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an alarm.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     */
    override suspend fun deleteAlarm(input: DeleteAlarmRequest): DeleteAlarmResponse {
        val op = SdkHttpOperation.build<DeleteAlarmRequest, DeleteAlarmResponse> {
            serializeWith = DeleteAlarmOperationSerializer()
            deserializeWith = DeleteAlarmOperationDeserializer()
            operationName = "DeleteAlarm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an automatic snapshot of an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    override suspend fun deleteAutoSnapshot(input: DeleteAutoSnapshotRequest): DeleteAutoSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteAutoSnapshotRequest, DeleteAutoSnapshotResponse> {
            serializeWith = DeleteAutoSnapshotOperationSerializer()
            deserializeWith = DeleteAutoSnapshotOperationDeserializer()
            operationName = "DeleteAutoSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Amazon Lightsail bucket.
     *
     * When you delete your bucket, the bucket name is released and can be reused for a new bucket in your account or another Amazon Web Services account.
     */
    override suspend fun deleteBucket(input: DeleteBucketRequest): DeleteBucketResponse {
        val op = SdkHttpOperation.build<DeleteBucketRequest, DeleteBucketResponse> {
            serializeWith = DeleteBucketOperationSerializer()
            deserializeWith = DeleteBucketOperationDeserializer()
            operationName = "DeleteBucket"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an access key for the specified Amazon Lightsail bucket.
     *
     * We recommend that you delete an access key if the secret access key is compromised.
     *
     * For more information about access keys, see [Creating access keys for a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun deleteBucketAccessKey(input: DeleteBucketAccessKeyRequest): DeleteBucketAccessKeyResponse {
        val op = SdkHttpOperation.build<DeleteBucketAccessKeyRequest, DeleteBucketAccessKeyResponse> {
            serializeWith = DeleteBucketAccessKeyOperationSerializer()
            deserializeWith = DeleteBucketAccessKeyOperationDeserializer()
            operationName = "DeleteBucketAccessKey"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * Certificates that are currently attached to a distribution cannot be deleted. Use the `DetachCertificateFromDistribution` action to detach a certificate from a distribution.
     */
    override suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse {
        val op = SdkHttpOperation.build<DeleteCertificateRequest, DeleteCertificateResponse> {
            serializeWith = DeleteCertificateOperationSerializer()
            deserializeWith = DeleteCertificateOperationDeserializer()
            operationName = "DeleteCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a contact method.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    override suspend fun deleteContactMethod(input: DeleteContactMethodRequest): DeleteContactMethodResponse {
        val op = SdkHttpOperation.build<DeleteContactMethodRequest, DeleteContactMethodResponse> {
            serializeWith = DeleteContactMethodOperationSerializer()
            deserializeWith = DeleteContactMethodOperationDeserializer()
            operationName = "DeleteContactMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a container image that is registered to your Amazon Lightsail container service.
     */
    override suspend fun deleteContainerImage(input: DeleteContainerImageRequest): DeleteContainerImageResponse {
        val op = SdkHttpOperation.build<DeleteContainerImageRequest, DeleteContainerImageResponse> {
            serializeWith = DeleteContainerImageOperationSerializer()
            deserializeWith = DeleteContainerImageOperationDeserializer()
            operationName = "DeleteContainerImage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes your Amazon Lightsail container service.
     */
    override suspend fun deleteContainerService(input: DeleteContainerServiceRequest): DeleteContainerServiceResponse {
        val op = SdkHttpOperation.build<DeleteContainerServiceRequest, DeleteContainerServiceResponse> {
            serializeWith = DeleteContainerServiceOperationSerializer()
            deserializeWith = DeleteContainerServiceOperationDeserializer()
            operationName = "DeleteContainerService"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified block storage disk. The disk must be in the `available` state (not attached to a Lightsail instance).
     *
     * The disk may remain in the `deleting` state for several minutes.
     *
     * The `delete disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteDisk(input: DeleteDiskRequest): DeleteDiskResponse {
        val op = SdkHttpOperation.build<DeleteDiskRequest, DeleteDiskResponse> {
            serializeWith = DeleteDiskOperationSerializer()
            deserializeWith = DeleteDiskOperationDeserializer()
            operationName = "DeleteDisk"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified disk snapshot.
     *
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the disk.
     *
     * The `delete disk snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `disk snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteDiskSnapshot(input: DeleteDiskSnapshotRequest): DeleteDiskSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteDiskSnapshotRequest, DeleteDiskSnapshotResponse> {
            serializeWith = DeleteDiskSnapshotOperationSerializer()
            deserializeWith = DeleteDiskSnapshotOperationDeserializer()
            operationName = "DeleteDiskSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes your Amazon Lightsail content delivery network (CDN) distribution.
     */
    override suspend fun deleteDistribution(input: DeleteDistributionRequest): DeleteDistributionResponse {
        val op = SdkHttpOperation.build<DeleteDistributionRequest, DeleteDistributionResponse> {
            serializeWith = DeleteDistributionOperationSerializer()
            deserializeWith = DeleteDistributionOperationDeserializer()
            operationName = "DeleteDistribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified domain recordset and all of its domain records.
     *
     * The `delete domain` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse {
        val op = SdkHttpOperation.build<DeleteDomainRequest, DeleteDomainResponse> {
            serializeWith = DeleteDomainOperationSerializer()
            deserializeWith = DeleteDomainOperationDeserializer()
            operationName = "DeleteDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specific domain entry.
     *
     * The `delete domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteDomainEntry(input: DeleteDomainEntryRequest): DeleteDomainEntryResponse {
        val op = SdkHttpOperation.build<DeleteDomainEntryRequest, DeleteDomainEntryResponse> {
            serializeWith = DeleteDomainEntryOperationSerializer()
            deserializeWith = DeleteDomainEntryOperationDeserializer()
            operationName = "DeleteDomainEntry"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Lightsail instance.
     *
     * The `delete instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse {
        val op = SdkHttpOperation.build<DeleteInstanceRequest, DeleteInstanceResponse> {
            serializeWith = DeleteInstanceOperationSerializer()
            deserializeWith = DeleteInstanceOperationDeserializer()
            operationName = "DeleteInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specific snapshot of a virtual private server (or *instance*).
     *
     * The `delete instance snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `instance snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteInstanceSnapshot(input: DeleteInstanceSnapshotRequest): DeleteInstanceSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteInstanceSnapshotRequest, DeleteInstanceSnapshotResponse> {
            serializeWith = DeleteInstanceSnapshotOperationSerializer()
            deserializeWith = DeleteInstanceSnapshotOperationDeserializer()
            operationName = "DeleteInstanceSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified key pair by removing the public key from Amazon Lightsail.
     *
     * You can delete key pairs that were created using the [ImportKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_ImportKeyPair.html) and [CreateKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateKeyPair.html) actions, as well as the Lightsail default key pair. A new default key pair will not be created unless you launch an instance without specifying a custom key pair, or you call the [DownloadDefaultKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DownloadDefaultKeyPair.html) API.
     *
     * The `delete key pair` operation supports tag-based access control via resource tags applied to the resource identified by `key pair name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteKeyPair(input: DeleteKeyPairRequest): DeleteKeyPairResponse {
        val op = SdkHttpOperation.build<DeleteKeyPairRequest, DeleteKeyPairResponse> {
            serializeWith = DeleteKeyPairOperationSerializer()
            deserializeWith = DeleteKeyPairOperationDeserializer()
            operationName = "DeleteKeyPair"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the instance after a host key mismatch.
     *
     * Perform this operation only if you were expecting the host key or certificate mismatch or if you are familiar with the new host key or certificate on the instance. For more information, see [Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP client](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection).
     */
    override suspend fun deleteKnownHostKeys(input: DeleteKnownHostKeysRequest): DeleteKnownHostKeysResponse {
        val op = SdkHttpOperation.build<DeleteKnownHostKeysRequest, DeleteKnownHostKeysResponse> {
            serializeWith = DeleteKnownHostKeysOperationSerializer()
            deserializeWith = DeleteKnownHostKeysOperationDeserializer()
            operationName = "DeleteKnownHostKeys"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted, you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     *
     * The `delete load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> {
            serializeWith = DeleteLoadBalancerOperationSerializer()
            deserializeWith = DeleteLoadBalancerOperationDeserializer()
            operationName = "DeleteLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     *
     * The `DeleteLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteLoadBalancerTlsCertificate(input: DeleteLoadBalancerTlsCertificateRequest): DeleteLoadBalancerTlsCertificateResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerTlsCertificateRequest, DeleteLoadBalancerTlsCertificateResponse> {
            serializeWith = DeleteLoadBalancerTlsCertificateOperationSerializer()
            deserializeWith = DeleteLoadBalancerTlsCertificateOperationDeserializer()
            operationName = "DeleteLoadBalancerTlsCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a database in Amazon Lightsail.
     *
     * The `delete relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteRelationalDatabase(input: DeleteRelationalDatabaseRequest): DeleteRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<DeleteRelationalDatabaseRequest, DeleteRelationalDatabaseResponse> {
            serializeWith = DeleteRelationalDatabaseOperationSerializer()
            deserializeWith = DeleteRelationalDatabaseOperationDeserializer()
            operationName = "DeleteRelationalDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a database snapshot in Amazon Lightsail.
     *
     * The `delete relational database snapshot` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun deleteRelationalDatabaseSnapshot(input: DeleteRelationalDatabaseSnapshotRequest): DeleteRelationalDatabaseSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteRelationalDatabaseSnapshotRequest, DeleteRelationalDatabaseSnapshotResponse> {
            serializeWith = DeleteRelationalDatabaseSnapshotOperationSerializer()
            deserializeWith = DeleteRelationalDatabaseSnapshotOperationDeserializer()
            operationName = "DeleteRelationalDatabaseSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * After the certificate is detached, your distribution stops accepting traffic for all of the domains that are associated with the certificate.
     */
    override suspend fun detachCertificateFromDistribution(input: DetachCertificateFromDistributionRequest): DetachCertificateFromDistributionResponse {
        val op = SdkHttpOperation.build<DetachCertificateFromDistributionRequest, DetachCertificateFromDistributionResponse> {
            serializeWith = DetachCertificateFromDistributionOperationSerializer()
            deserializeWith = DetachCertificateFromDistributionOperationDeserializer()
            operationName = "DetachCertificateFromDistribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the device within your operating system before stopping the instance and detaching the disk.
     *
     * The `detach disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun detachDisk(input: DetachDiskRequest): DetachDiskResponse {
        val op = SdkHttpOperation.build<DetachDiskRequest, DetachDiskResponse> {
            serializeWith = DetachDiskOperationSerializer()
            deserializeWith = DetachDiskOperationDeserializer()
            operationName = "DetachDisk"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches the specified instances from a Lightsail load balancer.
     *
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     *
     * The `detach instances from load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun detachInstancesFromLoadBalancer(input: DetachInstancesFromLoadBalancerRequest): DetachInstancesFromLoadBalancerResponse {
        val op = SdkHttpOperation.build<DetachInstancesFromLoadBalancerRequest, DetachInstancesFromLoadBalancerResponse> {
            serializeWith = DetachInstancesFromLoadBalancerOperationSerializer()
            deserializeWith = DetachInstancesFromLoadBalancerOperationDeserializer()
            operationName = "DetachInstancesFromLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     */
    override suspend fun detachStaticIp(input: DetachStaticIpRequest): DetachStaticIpResponse {
        val op = SdkHttpOperation.build<DetachStaticIpRequest, DetachStaticIpResponse> {
            serializeWith = DetachStaticIpOperationSerializer()
            deserializeWith = DetachStaticIpOperationDeserializer()
            operationName = "DetachStaticIp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    override suspend fun disableAddOn(input: DisableAddOnRequest): DisableAddOnResponse {
        val op = SdkHttpOperation.build<DisableAddOnRequest, DisableAddOnResponse> {
            serializeWith = DisableAddOnOperationSerializer()
            deserializeWith = DisableAddOnOperationDeserializer()
            operationName = "DisableAddOn"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Downloads the regional Amazon Lightsail default key pair.
     *
     * This action also creates a Lightsail default key pair if a default key pair does not currently exist in the Amazon Web Services Region.
     */
    override suspend fun downloadDefaultKeyPair(input: DownloadDefaultKeyPairRequest): DownloadDefaultKeyPairResponse {
        val op = SdkHttpOperation.build<DownloadDefaultKeyPairRequest, DownloadDefaultKeyPairResponse> {
            serializeWith = DownloadDefaultKeyPairOperationSerializer()
            deserializeWith = DownloadDefaultKeyPairOperationDeserializer()
            operationName = "DownloadDefaultKeyPair"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    override suspend fun enableAddOn(input: EnableAddOnRequest): EnableAddOnResponse {
        val op = SdkHttpOperation.build<EnableAddOnRequest, EnableAddOnResponse> {
            serializeWith = EnableAddOnOperationSerializer()
            deserializeWith = EnableAddOnOperationDeserializer()
            operationName = "EnableAddOn"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2). This operation results in an export snapshot record that can be used with the `create cloud formation stack` operation to create new Amazon EC2 instances.
     *
     * Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the instance system disk appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the source Lightsail snapshot.
     *
     * The `export snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `source snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     *
     * Use the `get instance snapshots` or `get disk snapshots` operations to get a list of snapshots that you can export to Amazon EC2.
     */
    override suspend fun exportSnapshot(input: ExportSnapshotRequest): ExportSnapshotResponse {
        val op = SdkHttpOperation.build<ExportSnapshotRequest, ExportSnapshotResponse> {
            serializeWith = ExportSnapshotOperationSerializer()
            deserializeWith = ExportSnapshotOperationDeserializer()
            operationName = "ExportSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the names of all active (not deleted) resources.
     */
    override suspend fun getActiveNames(input: GetActiveNamesRequest): GetActiveNamesResponse {
        val op = SdkHttpOperation.build<GetActiveNamesRequest, GetActiveNamesResponse> {
            serializeWith = GetActiveNamesOperationSerializer()
            deserializeWith = GetActiveNamesOperationDeserializer()
            operationName = "GetActiveNames"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the configured alarms. Specify an alarm name in your request to return information about a specific alarm, or specify a monitored resource name to return information about all alarms for a specific resource.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     */
    override suspend fun getAlarms(input: GetAlarmsRequest): GetAlarmsResponse {
        val op = SdkHttpOperation.build<GetAlarmsRequest, GetAlarmsResponse> {
            serializeWith = GetAlarmsOperationSerializer()
            deserializeWith = GetAlarmsOperationDeserializer()
            operationName = "GetAlarms"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the available automatic snapshots for an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    override suspend fun getAutoSnapshots(input: GetAutoSnapshotsRequest): GetAutoSnapshotsResponse {
        val op = SdkHttpOperation.build<GetAutoSnapshotsRequest, GetAutoSnapshotsResponse> {
            serializeWith = GetAutoSnapshotsOperationSerializer()
            deserializeWith = GetAutoSnapshotsOperationDeserializer()
            operationName = "GetAutoSnapshots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of available instance images, or *blueprints*. You can use a blueprint to create a new instance already running a specific operating system, as well as a preinstalled app or development stack. The software each instance is running depends on the blueprint image you choose.
     *
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.
     */
    override suspend fun getBlueprints(input: GetBlueprintsRequest): GetBlueprintsResponse {
        val op = SdkHttpOperation.build<GetBlueprintsRequest, GetBlueprintsResponse> {
            serializeWith = GetBlueprintsOperationSerializer()
            deserializeWith = GetBlueprintsOperationDeserializer()
            operationName = "GetBlueprints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the existing access key IDs for the specified Amazon Lightsail bucket.
     *
     * This action does not return the secret access key value of an access key. You can get a secret access key only when you create it from the response of the [CreateBucketAccessKey](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html) action. If you lose the secret access key, you must create a new access key.
     */
    override suspend fun getBucketAccessKeys(input: GetBucketAccessKeysRequest): GetBucketAccessKeysResponse {
        val op = SdkHttpOperation.build<GetBucketAccessKeysRequest, GetBucketAccessKeysResponse> {
            serializeWith = GetBucketAccessKeysOperationSerializer()
            deserializeWith = GetBucketAccessKeysOperationDeserializer()
            operationName = "GetBucketAccessKeys"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the bundles that you can apply to a Amazon Lightsail bucket.
     *
     * The bucket bundle specifies the monthly cost, storage quota, and data transfer quota for a bucket.
     *
     * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to update the bundle for a bucket.
     */
    override suspend fun getBucketBundles(input: GetBucketBundlesRequest): GetBucketBundlesResponse {
        val op = SdkHttpOperation.build<GetBucketBundlesRequest, GetBucketBundlesResponse> {
            serializeWith = GetBucketBundlesOperationSerializer()
            deserializeWith = GetBucketBundlesOperationDeserializer()
            operationName = "GetBucketBundles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the data points of a specific metric for an Amazon Lightsail bucket.
     *
     * Metrics report the utilization of a bucket. View and collect metric data regularly to monitor the number of objects stored in a bucket (including object versions) and the storage space used by those objects.
     */
    override suspend fun getBucketMetricData(input: GetBucketMetricDataRequest): GetBucketMetricDataResponse {
        val op = SdkHttpOperation.build<GetBucketMetricDataRequest, GetBucketMetricDataResponse> {
            serializeWith = GetBucketMetricDataOperationSerializer()
            deserializeWith = GetBucketMetricDataOperationDeserializer()
            operationName = "GetBucketMetricData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about one or more Amazon Lightsail buckets. The information returned includes the synchronization status of the Amazon Simple Storage Service (Amazon S3) account-level block public access feature for your Lightsail buckets.
     *
     * For more information about buckets, see [Buckets in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun getBuckets(input: GetBucketsRequest): GetBucketsResponse {
        val op = SdkHttpOperation.build<GetBucketsRequest, GetBucketsResponse> {
            serializeWith = GetBucketsOperationSerializer()
            deserializeWith = GetBucketsOperationDeserializer()
            operationName = "GetBuckets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the bundles that you can apply to an Amazon Lightsail instance when you create it.
     *
     * A bundle describes the specifications of an instance, such as the monthly cost, amount of memory, the number of vCPUs, amount of storage space, and monthly network data transfer quota.
     *
     * Bundles are referred to as *instance plans* in the Lightsail console.
     */
    override suspend fun getBundles(input: GetBundlesRequest): GetBundlesResponse {
        val op = SdkHttpOperation.build<GetBundlesRequest, GetBundlesResponse> {
            serializeWith = GetBundlesOperationSerializer()
            deserializeWith = GetBundlesOperationDeserializer()
            operationName = "GetBundles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about one or more Amazon Lightsail SSL/TLS certificates.
     *
     * To get a summary of a certificate, omit `includeCertificateDetails` from your request. The response will include only the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.
     */
    override suspend fun getCertificates(input: GetCertificatesRequest): GetCertificatesResponse {
        val op = SdkHttpOperation.build<GetCertificatesRequest, GetCertificatesResponse> {
            serializeWith = GetCertificatesOperationSerializer()
            deserializeWith = GetCertificatesOperationDeserializer()
            operationName = "GetCertificates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the CloudFormation stack record created as a result of the `create cloud formation stack` operation.
     *
     * An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail snapshot.
     */
    override suspend fun getCloudFormationStackRecords(input: GetCloudFormationStackRecordsRequest): GetCloudFormationStackRecordsResponse {
        val op = SdkHttpOperation.build<GetCloudFormationStackRecordsRequest, GetCloudFormationStackRecordsResponse> {
            serializeWith = GetCloudFormationStackRecordsOperationSerializer()
            deserializeWith = GetCloudFormationStackRecordsOperationDeserializer()
            operationName = "GetCloudFormationStackRecords"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the configured contact methods. Specify a protocol in your request to return information about a specific contact method.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    override suspend fun getContactMethods(input: GetContactMethodsRequest): GetContactMethodsResponse {
        val op = SdkHttpOperation.build<GetContactMethodsRequest, GetContactMethodsResponse> {
            serializeWith = GetContactMethodsOperationSerializer()
            deserializeWith = GetContactMethodsOperationDeserializer()
            operationName = "GetContactMethods"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about Amazon Lightsail containers, such as the current version of the Lightsail Control (lightsailctl) plugin.
     */
    override suspend fun getContainerApiMetadata(input: GetContainerApiMetadataRequest): GetContainerApiMetadataResponse {
        val op = SdkHttpOperation.build<GetContainerApiMetadataRequest, GetContainerApiMetadataResponse> {
            serializeWith = GetContainerAPIMetadataOperationSerializer()
            deserializeWith = GetContainerAPIMetadataOperationDeserializer()
            operationName = "GetContainerAPIMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the container images that are registered to your Amazon Lightsail container service.
     *
     * If you created a deployment on your Lightsail container service that uses container images from a public registry like Docker Hub, those images are not returned as part of this action. Those images are not registered to your Lightsail container service.
     */
    override suspend fun getContainerImages(input: GetContainerImagesRequest): GetContainerImagesResponse {
        val op = SdkHttpOperation.build<GetContainerImagesRequest, GetContainerImagesResponse> {
            serializeWith = GetContainerImagesOperationSerializer()
            deserializeWith = GetContainerImagesOperationDeserializer()
            operationName = "GetContainerImages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the log events of a container of your Amazon Lightsail container service.
     *
     * If your container service has more than one node (i.e., a scale greater than 1), then the log events that are returned for the specified container are merged from all nodes on your container service.
     *
     * Container logs are retained for a certain amount of time. For more information, see [Amazon Lightsail endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in the *Amazon Web Services General Reference*.
     */
    override suspend fun getContainerLog(input: GetContainerLogRequest): GetContainerLogResponse {
        val op = SdkHttpOperation.build<GetContainerLogRequest, GetContainerLogResponse> {
            serializeWith = GetContainerLogOperationSerializer()
            deserializeWith = GetContainerLogOperationDeserializer()
            operationName = "GetContainerLog"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the deployments for your Amazon Lightsail container service
     *
     * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to your container service.
     *
     * The deployments are ordered by version in ascending order. The newest version is listed at the top of the response.
     *
     * A set number of deployments are kept before the oldest one is replaced with the newest one. For more information, see [Amazon Lightsail endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in the *Amazon Web Services General Reference*.
     */
    override suspend fun getContainerServiceDeployments(input: GetContainerServiceDeploymentsRequest): GetContainerServiceDeploymentsResponse {
        val op = SdkHttpOperation.build<GetContainerServiceDeploymentsRequest, GetContainerServiceDeploymentsResponse> {
            serializeWith = GetContainerServiceDeploymentsOperationSerializer()
            deserializeWith = GetContainerServiceDeploymentsOperationDeserializer()
            operationName = "GetContainerServiceDeployments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the data points of a specific metric of your Amazon Lightsail container service.
     *
     * Metrics report the utilization of your resources. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getContainerServiceMetricData(input: GetContainerServiceMetricDataRequest): GetContainerServiceMetricDataResponse {
        val op = SdkHttpOperation.build<GetContainerServiceMetricDataRequest, GetContainerServiceMetricDataResponse> {
            serializeWith = GetContainerServiceMetricDataOperationSerializer()
            deserializeWith = GetContainerServiceMetricDataOperationDeserializer()
            operationName = "GetContainerServiceMetricData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of powers that can be specified for your Amazon Lightsail container services.
     *
     * The power specifies the amount of memory, the number of vCPUs, and the base price of the container service.
     */
    override suspend fun getContainerServicePowers(input: GetContainerServicePowersRequest): GetContainerServicePowersResponse {
        val op = SdkHttpOperation.build<GetContainerServicePowersRequest, GetContainerServicePowersResponse> {
            serializeWith = GetContainerServicePowersOperationSerializer()
            deserializeWith = GetContainerServicePowersOperationDeserializer()
            operationName = "GetContainerServicePowers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about one or more of your Amazon Lightsail container services.
     */
    override suspend fun getContainerServices(input: GetContainerServicesRequest): GetContainerServicesResponse {
        val op = SdkHttpOperation.build<GetContainerServicesRequest, GetContainerServicesResponse> {
            serializeWith = GetContainerServicesOperationSerializer()
            deserializeWith = GetContainerServicesOperationDeserializer()
            operationName = "GetContainerServices"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the cost estimate for a specified resource. A cost estimate will not generate for a resource that has been deleted.
     */
    override suspend fun getCostEstimate(input: GetCostEstimateRequest): GetCostEstimateResponse {
        val op = SdkHttpOperation.build<GetCostEstimateRequest, GetCostEstimateResponse> {
            serializeWith = GetCostEstimateOperationSerializer()
            deserializeWith = GetCostEstimateOperationDeserializer()
            operationName = "GetCostEstimate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific block storage disk.
     */
    override suspend fun getDisk(input: GetDiskRequest): GetDiskResponse {
        val op = SdkHttpOperation.build<GetDiskRequest, GetDiskResponse> {
            serializeWith = GetDiskOperationSerializer()
            deserializeWith = GetDiskOperationDeserializer()
            operationName = "GetDisk"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific block storage disk snapshot.
     */
    override suspend fun getDiskSnapshot(input: GetDiskSnapshotRequest): GetDiskSnapshotResponse {
        val op = SdkHttpOperation.build<GetDiskSnapshotRequest, GetDiskSnapshotResponse> {
            serializeWith = GetDiskSnapshotOperationSerializer()
            deserializeWith = GetDiskSnapshotOperationDeserializer()
            operationName = "GetDiskSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all block storage disk snapshots in your AWS account and region.
     */
    override suspend fun getDiskSnapshots(input: GetDiskSnapshotsRequest): GetDiskSnapshotsResponse {
        val op = SdkHttpOperation.build<GetDiskSnapshotsRequest, GetDiskSnapshotsResponse> {
            serializeWith = GetDiskSnapshotsOperationSerializer()
            deserializeWith = GetDiskSnapshotsOperationDeserializer()
            operationName = "GetDiskSnapshots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all block storage disks in your AWS account and region.
     */
    override suspend fun getDisks(input: GetDisksRequest): GetDisksResponse {
        val op = SdkHttpOperation.build<GetDisksRequest, GetDisksResponse> {
            serializeWith = GetDisksOperationSerializer()
            deserializeWith = GetDisksOperationDeserializer()
            operationName = "GetDisks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the bundles that can be applied to your Amazon Lightsail content delivery network (CDN) distributions.
     *
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your distribution.
     */
    override suspend fun getDistributionBundles(input: GetDistributionBundlesRequest): GetDistributionBundlesResponse {
        val op = SdkHttpOperation.build<GetDistributionBundlesRequest, GetDistributionBundlesResponse> {
            serializeWith = GetDistributionBundlesOperationSerializer()
            deserializeWith = GetDistributionBundlesOperationDeserializer()
            operationName = "GetDistributionBundles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail content delivery network (CDN) distribution.
     */
    override suspend fun getDistributionLatestCacheReset(input: GetDistributionLatestCacheResetRequest): GetDistributionLatestCacheResetResponse {
        val op = SdkHttpOperation.build<GetDistributionLatestCacheResetRequest, GetDistributionLatestCacheResetResponse> {
            serializeWith = GetDistributionLatestCacheResetOperationSerializer()
            deserializeWith = GetDistributionLatestCacheResetOperationDeserializer()
            operationName = "GetDistributionLatestCacheReset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the data points of a specific metric for an Amazon Lightsail content delivery network (CDN) distribution.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getDistributionMetricData(input: GetDistributionMetricDataRequest): GetDistributionMetricDataResponse {
        val op = SdkHttpOperation.build<GetDistributionMetricDataRequest, GetDistributionMetricDataResponse> {
            serializeWith = GetDistributionMetricDataOperationSerializer()
            deserializeWith = GetDistributionMetricDataOperationDeserializer()
            operationName = "GetDistributionMetricData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about one or more of your Amazon Lightsail content delivery network (CDN) distributions.
     */
    override suspend fun getDistributions(input: GetDistributionsRequest): GetDistributionsResponse {
        val op = SdkHttpOperation.build<GetDistributionsRequest, GetDistributionsResponse> {
            serializeWith = GetDistributionsOperationSerializer()
            deserializeWith = GetDistributionsOperationDeserializer()
            operationName = "GetDistributions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific domain recordset.
     */
    override suspend fun getDomain(input: GetDomainRequest): GetDomainResponse {
        val op = SdkHttpOperation.build<GetDomainRequest, GetDomainResponse> {
            serializeWith = GetDomainOperationSerializer()
            deserializeWith = GetDomainOperationDeserializer()
            operationName = "GetDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all domains in the user's account.
     */
    override suspend fun getDomains(input: GetDomainsRequest): GetDomainsResponse {
        val op = SdkHttpOperation.build<GetDomainsRequest, GetDomainsResponse> {
            serializeWith = GetDomainsOperationSerializer()
            deserializeWith = GetDomainsOperationDeserializer()
            operationName = "GetDomains"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns all export snapshot records created as a result of the `export snapshot` operation.
     *
     * An export snapshot record can be used to create a new Amazon EC2 instance and its related resources with the [CreateCloudFormationStack](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateCloudFormationStack.html) action.
     */
    override suspend fun getExportSnapshotRecords(input: GetExportSnapshotRecordsRequest): GetExportSnapshotRecordsResponse {
        val op = SdkHttpOperation.build<GetExportSnapshotRecordsRequest, GetExportSnapshotRecordsResponse> {
            serializeWith = GetExportSnapshotRecordsOperationSerializer()
            deserializeWith = GetExportSnapshotRecordsOperationDeserializer()
            operationName = "GetExportSnapshotRecords"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     */
    override suspend fun getInstance(input: GetInstanceRequest): GetInstanceResponse {
        val op = SdkHttpOperation.build<GetInstanceRequest, GetInstanceResponse> {
            serializeWith = GetInstanceOperationSerializer()
            deserializeWith = GetInstanceOperationDeserializer()
            operationName = "GetInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or *instance*.
     *
     * The `get instance access details` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun getInstanceAccessDetails(input: GetInstanceAccessDetailsRequest): GetInstanceAccessDetailsResponse {
        val op = SdkHttpOperation.build<GetInstanceAccessDetailsRequest, GetInstanceAccessDetailsResponse> {
            serializeWith = GetInstanceAccessDetailsOperationSerializer()
            deserializeWith = GetInstanceAccessDetailsOperationDeserializer()
            operationName = "GetInstanceAccessDetails"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getInstanceMetricData(input: GetInstanceMetricDataRequest): GetInstanceMetricDataResponse {
        val op = SdkHttpOperation.build<GetInstanceMetricDataRequest, GetInstanceMetricDataResponse> {
            serializeWith = GetInstanceMetricDataOperationSerializer()
            deserializeWith = GetInstanceMetricDataOperationDeserializer()
            operationName = "GetInstanceMetricData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses allowed to connect to the instance through the ports, and the protocol.
     */
    override suspend fun getInstancePortStates(input: GetInstancePortStatesRequest): GetInstancePortStatesResponse {
        val op = SdkHttpOperation.build<GetInstancePortStatesRequest, GetInstancePortStatesResponse> {
            serializeWith = GetInstancePortStatesOperationSerializer()
            deserializeWith = GetInstancePortStatesOperationDeserializer()
            operationName = "GetInstancePortStates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific instance snapshot.
     */
    override suspend fun getInstanceSnapshot(input: GetInstanceSnapshotRequest): GetInstanceSnapshotResponse {
        val op = SdkHttpOperation.build<GetInstanceSnapshotRequest, GetInstanceSnapshotResponse> {
            serializeWith = GetInstanceSnapshotOperationSerializer()
            deserializeWith = GetInstanceSnapshotOperationDeserializer()
            operationName = "GetInstanceSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns all instance snapshots for the user's account.
     */
    override suspend fun getInstanceSnapshots(input: GetInstanceSnapshotsRequest): GetInstanceSnapshotsResponse {
        val op = SdkHttpOperation.build<GetInstanceSnapshotsRequest, GetInstanceSnapshotsResponse> {
            serializeWith = GetInstanceSnapshotsOperationSerializer()
            deserializeWith = GetInstanceSnapshotsOperationDeserializer()
            operationName = "GetInstanceSnapshots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the state of a specific instance. Works on one instance at a time.
     */
    override suspend fun getInstanceState(input: GetInstanceStateRequest): GetInstanceStateResponse {
        val op = SdkHttpOperation.build<GetInstanceStateRequest, GetInstanceStateResponse> {
            serializeWith = GetInstanceStateOperationSerializer()
            deserializeWith = GetInstanceStateOperationDeserializer()
            operationName = "GetInstanceState"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all Amazon Lightsail virtual private servers, or *instances*.
     */
    override suspend fun getInstances(input: GetInstancesRequest): GetInstancesResponse {
        val op = SdkHttpOperation.build<GetInstancesRequest, GetInstancesResponse> {
            serializeWith = GetInstancesOperationSerializer()
            deserializeWith = GetInstancesOperationDeserializer()
            operationName = "GetInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific key pair.
     */
    override suspend fun getKeyPair(input: GetKeyPairRequest): GetKeyPairResponse {
        val op = SdkHttpOperation.build<GetKeyPairRequest, GetKeyPairResponse> {
            serializeWith = GetKeyPairOperationSerializer()
            deserializeWith = GetKeyPairOperationDeserializer()
            operationName = "GetKeyPair"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all key pairs in the user's account.
     */
    override suspend fun getKeyPairs(input: GetKeyPairsRequest): GetKeyPairsResponse {
        val op = SdkHttpOperation.build<GetKeyPairsRequest, GetKeyPairsResponse> {
            serializeWith = GetKeyPairsOperationSerializer()
            deserializeWith = GetKeyPairsOperationDeserializer()
            operationName = "GetKeyPairs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified Lightsail load balancer.
     */
    override suspend fun getLoadBalancer(input: GetLoadBalancerRequest): GetLoadBalancerResponse {
        val op = SdkHttpOperation.build<GetLoadBalancerRequest, GetLoadBalancerResponse> {
            serializeWith = GetLoadBalancerOperationSerializer()
            deserializeWith = GetLoadBalancerOperationDeserializer()
            operationName = "GetLoadBalancer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about health metrics for your Lightsail load balancer.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getLoadBalancerMetricData(input: GetLoadBalancerMetricDataRequest): GetLoadBalancerMetricDataResponse {
        val op = SdkHttpOperation.build<GetLoadBalancerMetricDataRequest, GetLoadBalancerMetricDataResponse> {
            serializeWith = GetLoadBalancerMetricDataOperationSerializer()
            deserializeWith = GetLoadBalancerMetricDataOperationDeserializer()
            operationName = "GetLoadBalancerMetricData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     *
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     *
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other is inactive.
     */
    override suspend fun getLoadBalancerTlsCertificates(input: GetLoadBalancerTlsCertificatesRequest): GetLoadBalancerTlsCertificatesResponse {
        val op = SdkHttpOperation.build<GetLoadBalancerTlsCertificatesRequest, GetLoadBalancerTlsCertificatesResponse> {
            serializeWith = GetLoadBalancerTlsCertificatesOperationSerializer()
            deserializeWith = GetLoadBalancerTlsCertificatesOperationDeserializer()
            operationName = "GetLoadBalancerTlsCertificates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of TLS security policies that you can apply to Lightsail load balancers.
     *
     * For more information about load balancer TLS security policies, see [Configuring TLS security policies on your Amazon Lightsail load balancers](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configure-load-balancer-tls-security-policy) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun getLoadBalancerTlsPolicies(input: GetLoadBalancerTlsPoliciesRequest): GetLoadBalancerTlsPoliciesResponse {
        val op = SdkHttpOperation.build<GetLoadBalancerTlsPoliciesRequest, GetLoadBalancerTlsPoliciesResponse> {
            serializeWith = GetLoadBalancerTlsPoliciesOperationSerializer()
            deserializeWith = GetLoadBalancerTlsPoliciesOperationDeserializer()
            operationName = "GetLoadBalancerTlsPolicies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all load balancers in an account.
     */
    override suspend fun getLoadBalancers(input: GetLoadBalancersRequest): GetLoadBalancersResponse {
        val op = SdkHttpOperation.build<GetLoadBalancersRequest, GetLoadBalancersResponse> {
            serializeWith = GetLoadBalancersOperationSerializer()
            deserializeWith = GetLoadBalancersOperationDeserializer()
            operationName = "GetLoadBalancers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific operation. Operations include events such as when you create an instance, allocate a static IP, attach a static IP, and so on.
     */
    override suspend fun getOperation(input: GetOperationRequest): GetOperationResponse {
        val op = SdkHttpOperation.build<GetOperationRequest, GetOperationResponse> {
            serializeWith = GetOperationOperationSerializer()
            deserializeWith = GetOperationOperationDeserializer()
            operationName = "GetOperation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all operations.
     *
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each subsequent call to `GetOperations` use the maximum (last) `statusChangedAt` value from the previous request.
     */
    override suspend fun getOperations(input: GetOperationsRequest): GetOperationsResponse {
        val op = SdkHttpOperation.build<GetOperationsRequest, GetOperationsResponse> {
            serializeWith = GetOperationsOperationSerializer()
            deserializeWith = GetOperationsOperationDeserializer()
            operationName = "GetOperations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets operations for a specific resource (an instance or a static IP).
     */
    override suspend fun getOperationsForResource(input: GetOperationsForResourceRequest): GetOperationsForResourceResponse {
        val op = SdkHttpOperation.build<GetOperationsForResourceRequest, GetOperationsForResourceResponse> {
            serializeWith = GetOperationsForResourceOperationSerializer()
            deserializeWith = GetOperationsForResourceOperationDeserializer()
            operationName = "GetOperationsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all valid regions for Amazon Lightsail. Use the `include availability zones` parameter to also return the Availability Zones in a region.
     */
    override suspend fun getRegions(input: GetRegionsRequest): GetRegionsResponse {
        val op = SdkHttpOperation.build<GetRegionsRequest, GetRegionsResponse> {
            serializeWith = GetRegionsOperationSerializer()
            deserializeWith = GetRegionsOperationDeserializer()
            operationName = "GetRegions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific database in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabase(input: GetRelationalDatabaseRequest): GetRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseRequest, GetRelationalDatabaseResponse> {
            serializeWith = GetRelationalDatabaseOperationSerializer()
            deserializeWith = GetRelationalDatabaseOperationDeserializer()
            operationName = "GetRelationalDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine version of a database.
     *
     * You can use a blueprint ID to create a new database that runs a specific database engine.
     */
    override suspend fun getRelationalDatabaseBlueprints(input: GetRelationalDatabaseBlueprintsRequest): GetRelationalDatabaseBlueprintsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseBlueprintsRequest, GetRelationalDatabaseBlueprintsResponse> {
            serializeWith = GetRelationalDatabaseBlueprintsOperationSerializer()
            deserializeWith = GetRelationalDatabaseBlueprintsOperationDeserializer()
            operationName = "GetRelationalDatabaseBlueprints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance specifications for a database.
     *
     * You can use a bundle ID to create a new database with explicit performance specifications.
     */
    override suspend fun getRelationalDatabaseBundles(input: GetRelationalDatabaseBundlesRequest): GetRelationalDatabaseBundlesResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseBundlesRequest, GetRelationalDatabaseBundlesResponse> {
            serializeWith = GetRelationalDatabaseBundlesOperationSerializer()
            deserializeWith = GetRelationalDatabaseBundlesOperationDeserializer()
            operationName = "GetRelationalDatabaseBundles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of events for a specific database in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseEvents(input: GetRelationalDatabaseEventsRequest): GetRelationalDatabaseEventsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseEventsRequest, GetRelationalDatabaseEventsResponse> {
            serializeWith = GetRelationalDatabaseEventsOperationSerializer()
            deserializeWith = GetRelationalDatabaseEventsOperationDeserializer()
            operationName = "GetRelationalDatabaseEvents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of log events for a database in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseLogEvents(input: GetRelationalDatabaseLogEventsRequest): GetRelationalDatabaseLogEventsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseLogEventsRequest, GetRelationalDatabaseLogEventsResponse> {
            serializeWith = GetRelationalDatabaseLogEventsOperationSerializer()
            deserializeWith = GetRelationalDatabaseLogEventsOperationDeserializer()
            operationName = "GetRelationalDatabaseLogEvents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of available log streams for a specific database in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseLogStreams(input: GetRelationalDatabaseLogStreamsRequest): GetRelationalDatabaseLogStreamsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseLogStreamsRequest, GetRelationalDatabaseLogStreamsResponse> {
            serializeWith = GetRelationalDatabaseLogStreamsOperationSerializer()
            deserializeWith = GetRelationalDatabaseLogStreamsOperationDeserializer()
            operationName = "GetRelationalDatabaseLogStreams"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the current, previous, or pending versions of the master user password for a Lightsail database.
     *
     * The `GetRelationalDatabaseMasterUserPassword` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName.
     */
    override suspend fun getRelationalDatabaseMasterUserPassword(input: GetRelationalDatabaseMasterUserPasswordRequest): GetRelationalDatabaseMasterUserPasswordResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseMasterUserPasswordRequest, GetRelationalDatabaseMasterUserPasswordResponse> {
            serializeWith = GetRelationalDatabaseMasterUserPasswordOperationSerializer()
            deserializeWith = GetRelationalDatabaseMasterUserPasswordOperationDeserializer()
            operationName = "GetRelationalDatabaseMasterUserPassword"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the data points of the specified metric for a database in Amazon Lightsail.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    override suspend fun getRelationalDatabaseMetricData(input: GetRelationalDatabaseMetricDataRequest): GetRelationalDatabaseMetricDataResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseMetricDataRequest, GetRelationalDatabaseMetricDataResponse> {
            serializeWith = GetRelationalDatabaseMetricDataOperationSerializer()
            deserializeWith = GetRelationalDatabaseMetricDataOperationDeserializer()
            operationName = "GetRelationalDatabaseMetricData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns all of the runtime parameters offered by the underlying database software, or engine, for a specific database in Amazon Lightsail.
     *
     * In addition to the parameter names and values, this operation returns other information about each parameter. This information includes whether changes require a reboot, whether the parameter is modifiable, the allowed values, and the data types.
     */
    override suspend fun getRelationalDatabaseParameters(input: GetRelationalDatabaseParametersRequest): GetRelationalDatabaseParametersResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseParametersRequest, GetRelationalDatabaseParametersResponse> {
            serializeWith = GetRelationalDatabaseParametersOperationSerializer()
            deserializeWith = GetRelationalDatabaseParametersOperationDeserializer()
            operationName = "GetRelationalDatabaseParameters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific database snapshot in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseSnapshot(input: GetRelationalDatabaseSnapshotRequest): GetRelationalDatabaseSnapshotResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseSnapshotRequest, GetRelationalDatabaseSnapshotResponse> {
            serializeWith = GetRelationalDatabaseSnapshotOperationSerializer()
            deserializeWith = GetRelationalDatabaseSnapshotOperationDeserializer()
            operationName = "GetRelationalDatabaseSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all of your database snapshots in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabaseSnapshots(input: GetRelationalDatabaseSnapshotsRequest): GetRelationalDatabaseSnapshotsResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabaseSnapshotsRequest, GetRelationalDatabaseSnapshotsResponse> {
            serializeWith = GetRelationalDatabaseSnapshotsOperationSerializer()
            deserializeWith = GetRelationalDatabaseSnapshotsOperationDeserializer()
            operationName = "GetRelationalDatabaseSnapshots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all of your databases in Amazon Lightsail.
     */
    override suspend fun getRelationalDatabases(input: GetRelationalDatabasesRequest): GetRelationalDatabasesResponse {
        val op = SdkHttpOperation.build<GetRelationalDatabasesRequest, GetRelationalDatabasesResponse> {
            serializeWith = GetRelationalDatabasesOperationSerializer()
            deserializeWith = GetRelationalDatabasesOperationDeserializer()
            operationName = "GetRelationalDatabases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information for five of the most recent `SetupInstanceHttps` requests that were ran on the target instance.
     */
    override suspend fun getSetupHistory(input: GetSetupHistoryRequest): GetSetupHistoryResponse {
        val op = SdkHttpOperation.build<GetSetupHistoryRequest, GetSetupHistoryResponse> {
            serializeWith = GetSetupHistoryOperationSerializer()
            deserializeWith = GetSetupHistoryOperationDeserializer()
            operationName = "GetSetupHistory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about an Amazon Lightsail static IP.
     */
    override suspend fun getStaticIp(input: GetStaticIpRequest): GetStaticIpResponse {
        val op = SdkHttpOperation.build<GetStaticIpRequest, GetStaticIpResponse> {
            serializeWith = GetStaticIpOperationSerializer()
            deserializeWith = GetStaticIpOperationDeserializer()
            operationName = "GetStaticIp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all static IPs in the user's account.
     */
    override suspend fun getStaticIps(input: GetStaticIpsRequest): GetStaticIpsResponse {
        val op = SdkHttpOperation.build<GetStaticIpsRequest, GetStaticIpsResponse> {
            serializeWith = GetStaticIpsOperationSerializer()
            deserializeWith = GetStaticIpsOperationDeserializer()
            operationName = "GetStaticIps"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Imports a public SSH key from a specific key pair.
     */
    override suspend fun importKeyPair(input: ImportKeyPairRequest): ImportKeyPairResponse {
        val op = SdkHttpOperation.build<ImportKeyPairRequest, ImportKeyPairResponse> {
            serializeWith = ImportKeyPairOperationSerializer()
            deserializeWith = ImportKeyPairOperationDeserializer()
            operationName = "ImportKeyPair"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     */
    override suspend fun isVpcPeered(input: IsVpcPeeredRequest): IsVpcPeeredResponse {
        val op = SdkHttpOperation.build<IsVpcPeeredRequest, IsVpcPeeredResponse> {
            serializeWith = IsVpcPeeredOperationSerializer()
            deserializeWith = IsVpcPeeredOperationDeserializer()
            operationName = "IsVpcPeered"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.
     *
     * The `OpenInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun openInstancePublicPorts(input: OpenInstancePublicPortsRequest): OpenInstancePublicPortsResponse {
        val op = SdkHttpOperation.build<OpenInstancePublicPortsRequest, OpenInstancePublicPortsResponse> {
            serializeWith = OpenInstancePublicPortsOperationSerializer()
            deserializeWith = OpenInstancePublicPortsOperationDeserializer()
            operationName = "OpenInstancePublicPorts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Peers the Lightsail VPC with the user's default VPC.
     */
    override suspend fun peerVpc(input: PeerVpcRequest): PeerVpcResponse {
        val op = SdkHttpOperation.build<PeerVpcRequest, PeerVpcResponse> {
            serializeWith = PeerVpcOperationSerializer()
            deserializeWith = PeerVpcOperationDeserializer()
            operationName = "PeerVpc"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates an alarm, and associates it with the specified metric.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     *
     * When this action creates an alarm, the alarm state is immediately set to `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed.
     *
     * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm. The alarm is then evaluated with the updated configuration.
     */
    override suspend fun putAlarm(input: PutAlarmRequest): PutAlarmResponse {
        val op = SdkHttpOperation.build<PutAlarmRequest, PutAlarmResponse> {
            serializeWith = PutAlarmOperationSerializer()
            deserializeWith = PutAlarmOperationDeserializer()
            operationName = "PutAlarm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol. This action also closes all currently open ports that are not included in the request. Include all of the ports and the protocols you want to open in your `PutInstancePublicPorts`request. Or use the `OpenInstancePublicPorts` action to open ports without closing currently open ports.
     *
     * The `PutInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun putInstancePublicPorts(input: PutInstancePublicPortsRequest): PutInstancePublicPortsResponse {
        val op = SdkHttpOperation.build<PutInstancePublicPortsRequest, PutInstancePublicPortsResponse> {
            serializeWith = PutInstancePublicPortsOperationSerializer()
            deserializeWith = PutInstancePublicPortsOperationDeserializer()
            operationName = "PutInstancePublicPorts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Restarts a specific instance.
     *
     * The `reboot instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun rebootInstance(input: RebootInstanceRequest): RebootInstanceResponse {
        val op = SdkHttpOperation.build<RebootInstanceRequest, RebootInstanceResponse> {
            serializeWith = RebootInstanceOperationSerializer()
            deserializeWith = RebootInstanceOperationDeserializer()
            operationName = "RebootInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Restarts a specific database in Amazon Lightsail.
     *
     * The `reboot relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun rebootRelationalDatabase(input: RebootRelationalDatabaseRequest): RebootRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<RebootRelationalDatabaseRequest, RebootRelationalDatabaseResponse> {
            serializeWith = RebootRelationalDatabaseOperationSerializer()
            deserializeWith = RebootRelationalDatabaseOperationDeserializer()
            operationName = "RebootRelationalDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Registers a container image to your Amazon Lightsail container service.
     *
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container images to your Lightsail container service. For more information, see [Pushing and managing container images on your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun registerContainerImage(input: RegisterContainerImageRequest): RegisterContainerImageResponse {
        val op = SdkHttpOperation.build<RegisterContainerImageRequest, RegisterContainerImageResponse> {
            serializeWith = RegisterContainerImageOperationSerializer()
            deserializeWith = RegisterContainerImageOperationDeserializer()
            operationName = "RegisterContainerImage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specific static IP from your account.
     */
    override suspend fun releaseStaticIp(input: ReleaseStaticIpRequest): ReleaseStaticIpResponse {
        val op = SdkHttpOperation.build<ReleaseStaticIpRequest, ReleaseStaticIpResponse> {
            serializeWith = ReleaseStaticIpOperationSerializer()
            deserializeWith = ReleaseStaticIpOperationDeserializer()
            operationName = "ReleaseStaticIp"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes currently cached content from your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * After resetting the cache, the next time a content request is made, your distribution pulls, serves, and caches it from the origin.
     */
    override suspend fun resetDistributionCache(input: ResetDistributionCacheRequest): ResetDistributionCacheResponse {
        val op = SdkHttpOperation.build<ResetDistributionCacheRequest, ResetDistributionCacheResponse> {
            serializeWith = ResetDistributionCacheOperationSerializer()
            deserializeWith = ResetDistributionCacheOperationDeserializer()
            operationName = "ResetDistributionCache"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sends a verification request to an email contact method to ensure it's owned by the requester. SMS contact methods don't need to be verified.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     *
     * A verification request is sent to the contact method when you initially create it. Use this action to send another verification request if a previous verification request was deleted, or has expired.
     *
     * Notifications are not sent to an email contact method until after it is verified, and confirmed as valid.
     */
    override suspend fun sendContactMethodVerification(input: SendContactMethodVerificationRequest): SendContactMethodVerificationResponse {
        val op = SdkHttpOperation.build<SendContactMethodVerificationRequest, SendContactMethodVerificationResponse> {
            serializeWith = SendContactMethodVerificationOperationSerializer()
            deserializeWith = SendContactMethodVerificationOperationDeserializer()
            operationName = "SendContactMethodVerification"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the IP address type for an Amazon Lightsail resource.
     *
     * Use this action to enable dual-stack for a resource, which enables IPv4 and IPv6 for the specified resource. Alternately, you can use this action to disable dual-stack, and enable IPv4 only.
     */
    override suspend fun setIpAddressType(input: SetIpAddressTypeRequest): SetIpAddressTypeResponse {
        val op = SdkHttpOperation.build<SetIpAddressTypeRequest, SetIpAddressTypeResponse> {
            serializeWith = SetIpAddressTypeOperationSerializer()
            deserializeWith = SetIpAddressTypeOperationDeserializer()
            operationName = "SetIpAddressType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the Amazon Lightsail resources that can access the specified Lightsail bucket.
     *
     * Lightsail buckets currently support setting access for Lightsail instances in the same Amazon Web Services Region.
     */
    override suspend fun setResourceAccessForBucket(input: SetResourceAccessForBucketRequest): SetResourceAccessForBucketResponse {
        val op = SdkHttpOperation.build<SetResourceAccessForBucketRequest, SetResourceAccessForBucketResponse> {
            serializeWith = SetResourceAccessForBucketOperationSerializer()
            deserializeWith = SetResourceAccessForBucketOperationDeserializer()
            operationName = "SetResourceAccessForBucket"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an SSL/TLS certificate that secures traffic for your website. After the certificate is created, it is installed on the specified Lightsail instance.
     *
     * If you provide more than one domain name in the request, at least one name must be less than or equal to 63 characters in length.
     */
    override suspend fun setupInstanceHttps(input: SetupInstanceHttpsRequest): SetupInstanceHttpsResponse {
        val op = SdkHttpOperation.build<SetupInstanceHttpsRequest, SetupInstanceHttpsResponse> {
            serializeWith = SetupInstanceHttpsOperationSerializer()
            deserializeWith = SetupInstanceHttpsOperationDeserializer()
            operationName = "SetupInstanceHttps"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Initiates a graphical user interface (GUI) session that’s used to access a virtual computer’s operating system and application. The session will be active for 1 hour. Use this action to resume the session after it expires.
     */
    override suspend fun startGuiSession(input: StartGuiSessionRequest): StartGuiSessionResponse {
        val op = SdkHttpOperation.build<StartGuiSessionRequest, StartGuiSessionResponse> {
            serializeWith = StartGUISessionOperationSerializer()
            deserializeWith = StartGUISessionOperationDeserializer()
            operationName = "StartGUISession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the `reboot instance` operation.
     *
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
     *
     * The `start instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun startInstance(input: StartInstanceRequest): StartInstanceResponse {
        val op = SdkHttpOperation.build<StartInstanceRequest, StartInstanceResponse> {
            serializeWith = StartInstanceOperationSerializer()
            deserializeWith = StartInstanceOperationDeserializer()
            operationName = "StartInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the `reboot relational database` operation.
     *
     * The `start relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun startRelationalDatabase(input: StartRelationalDatabaseRequest): StartRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<StartRelationalDatabaseRequest, StartRelationalDatabaseResponse> {
            serializeWith = StartRelationalDatabaseOperationSerializer()
            deserializeWith = StartRelationalDatabaseOperationDeserializer()
            operationName = "StartRelationalDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Terminates a web-based NICE DCV session that’s used to access a virtual computer’s operating system or application. The session will close and any unsaved data will be lost.
     */
    override suspend fun stopGuiSession(input: StopGuiSessionRequest): StopGuiSessionResponse {
        val op = SdkHttpOperation.build<StopGuiSessionRequest, StopGuiSessionResponse> {
            serializeWith = StopGUISessionOperationSerializer()
            deserializeWith = StopGUISessionOperationDeserializer()
            operationName = "StopGUISession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops a specific Amazon Lightsail instance that is currently running.
     *
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
     *
     * The `stop instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun stopInstance(input: StopInstanceRequest): StopInstanceResponse {
        val op = SdkHttpOperation.build<StopInstanceRequest, StopInstanceResponse> {
            serializeWith = StopInstanceOperationSerializer()
            deserializeWith = StopInstanceOperationDeserializer()
            operationName = "StopInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops a specific database that is currently running in Amazon Lightsail.
     *
     * The `stop relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun stopRelationalDatabase(input: StopRelationalDatabaseRequest): StopRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<StopRelationalDatabaseRequest, StopRelationalDatabaseResponse> {
            serializeWith = StopRelationalDatabaseOperationSerializer()
            deserializeWith = StopRelationalDatabaseOperationDeserializer()
            operationName = "StopRelationalDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     *
     * The `tag resource` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `resource name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured for the specified alarm, the test also sends a notification to the notification protocol (`Email` and/or `SMS`) configured for the alarm.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     */
    override suspend fun testAlarm(input: TestAlarmRequest): TestAlarmResponse {
        val op = SdkHttpOperation.build<TestAlarmRequest, TestAlarmResponse> {
            serializeWith = TestAlarmOperationSerializer()
            deserializeWith = TestAlarmOperationDeserializer()
            operationName = "TestAlarm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Unpeers the Lightsail VPC from the user's default VPC.
     */
    override suspend fun unpeerVpc(input: UnpeerVpcRequest): UnpeerVpcResponse {
        val op = SdkHttpOperation.build<UnpeerVpcRequest, UnpeerVpcResponse> {
            serializeWith = UnpeerVpcOperationSerializer()
            deserializeWith = UnpeerVpcOperationDeserializer()
            operationName = "UnpeerVpc"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource.
     *
     * The `untag resource` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `resource name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Amazon Lightsail bucket.
     *
     * Use this action to update the configuration of an existing bucket, such as versioning, public accessibility, and the Amazon Web Services accounts that can access the bucket.
     */
    override suspend fun updateBucket(input: UpdateBucketRequest): UpdateBucketResponse {
        val op = SdkHttpOperation.build<UpdateBucketRequest, UpdateBucketResponse> {
            serializeWith = UpdateBucketOperationSerializer()
            deserializeWith = UpdateBucketOperationDeserializer()
            operationName = "UpdateBucket"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the bundle, or storage plan, of an existing Amazon Lightsail bucket.
     *
     * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket. You can update a bucket's bundle only one time within a monthly Amazon Web Services billing cycle. To determine if you can update a bucket's bundle, use the [GetBuckets](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html) action. The `ableToUpdateBundle` parameter in the response will indicate whether you can currently update a bucket's bundle.
     *
     * Update a bucket's bundle if it's consistently going over its storage space or data transfer quota, or if a bucket's usage is consistently in the lower range of its storage space or data transfer quota. Due to the unpredictable usage fluctuations that a bucket might experience, we strongly recommend that you update a bucket's bundle only as a long-term strategy, instead of as a short-term, monthly cost-cutting measure. Choose a bucket bundle that will provide the bucket with ample storage space and data transfer for a long time to come.
     */
    override suspend fun updateBucketBundle(input: UpdateBucketBundleRequest): UpdateBucketBundleResponse {
        val op = SdkHttpOperation.build<UpdateBucketBundleRequest, UpdateBucketBundleResponse> {
            serializeWith = UpdateBucketBundleOperationSerializer()
            deserializeWith = UpdateBucketBundleOperationDeserializer()
            operationName = "UpdateBucketBundle"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain names.
     */
    override suspend fun updateContainerService(input: UpdateContainerServiceRequest): UpdateContainerServiceResponse {
        val op = SdkHttpOperation.build<UpdateContainerServiceRequest, UpdateContainerServiceResponse> {
            serializeWith = UpdateContainerServiceOperationSerializer()
            deserializeWith = UpdateContainerServiceOperationDeserializer()
            operationName = "UpdateContainerService"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Amazon Lightsail content delivery network (CDN) distribution.
     *
     * Use this action to update the configuration of your existing distribution.
     */
    override suspend fun updateDistribution(input: UpdateDistributionRequest): UpdateDistributionResponse {
        val op = SdkHttpOperation.build<UpdateDistributionRequest, UpdateDistributionResponse> {
            serializeWith = UpdateDistributionOperationSerializer()
            deserializeWith = UpdateDistributionOperationDeserializer()
            operationName = "UpdateDistribution"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your distribution.
     *
     * Update your distribution's bundle if your distribution is going over its monthly network transfer quota and is incurring an overage fee.
     *
     * You can update your distribution's bundle only one time within your monthly Amazon Web Services billing cycle. To determine if you can update your distribution's bundle, use the `GetDistributions` action. The `ableToUpdateBundle` parameter in the result will indicate whether you can currently update your distribution's bundle.
     */
    override suspend fun updateDistributionBundle(input: UpdateDistributionBundleRequest): UpdateDistributionBundleResponse {
        val op = SdkHttpOperation.build<UpdateDistributionBundleRequest, UpdateDistributionBundleResponse> {
            serializeWith = UpdateDistributionBundleOperationSerializer()
            deserializeWith = UpdateDistributionBundleOperationDeserializer()
            operationName = "UpdateDistributionBundle"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a domain recordset after it is created.
     *
     * The `update domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun updateDomainEntry(input: UpdateDomainEntryRequest): UpdateDomainEntryResponse {
        val op = SdkHttpOperation.build<UpdateDomainEntryRequest, UpdateDomainEntryResponse> {
            serializeWith = UpdateDomainEntryOperationSerializer()
            deserializeWith = UpdateDomainEntryOperationDeserializer()
            operationName = "UpdateDomainEntry"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the Amazon Lightsail instance metadata parameters on a running or stopped instance. When you modify the parameters on a running instance, the `GetInstance` or `GetInstances` API operation initially responds with a state of `pending`. After the parameter modifications are successfully applied, the state changes to `applied` in subsequent `GetInstance` or `GetInstances` API calls. For more information, see [Use IMDSv2 with an Amazon Lightsail instance](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-instance-metadata-service) in the *Amazon Lightsail Developer Guide*.
     */
    override suspend fun updateInstanceMetadataOptions(input: UpdateInstanceMetadataOptionsRequest): UpdateInstanceMetadataOptionsResponse {
        val op = SdkHttpOperation.build<UpdateInstanceMetadataOptionsRequest, UpdateInstanceMetadataOptionsResponse> {
            serializeWith = UpdateInstanceMetadataOptionsOperationSerializer()
            deserializeWith = UpdateInstanceMetadataOptionsOperationDeserializer()
            operationName = "UpdateInstanceMetadataOptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     *
     * The `update load balancer attribute` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun updateLoadBalancerAttribute(input: UpdateLoadBalancerAttributeRequest): UpdateLoadBalancerAttributeResponse {
        val op = SdkHttpOperation.build<UpdateLoadBalancerAttributeRequest, UpdateLoadBalancerAttributeResponse> {
            serializeWith = UpdateLoadBalancerAttributeOperationSerializer()
            deserializeWith = UpdateLoadBalancerAttributeOperationDeserializer()
            operationName = "UpdateLoadBalancerAttribute"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Allows the update of one or more attributes of a database in Amazon Lightsail.
     *
     * Updates are applied immediately, or in cases where the updates could result in an outage, are applied during the database's predefined maintenance window.
     *
     * The `update relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun updateRelationalDatabase(input: UpdateRelationalDatabaseRequest): UpdateRelationalDatabaseResponse {
        val op = SdkHttpOperation.build<UpdateRelationalDatabaseRequest, UpdateRelationalDatabaseResponse> {
            serializeWith = UpdateRelationalDatabaseOperationSerializer()
            deserializeWith = UpdateRelationalDatabaseOperationDeserializer()
            operationName = "UpdateRelationalDatabase"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Allows the update of one or more parameters of a database in Amazon Lightsail.
     *
     * Parameter updates don't cause outages; therefore, their application is not subject to the preferred maintenance window. However, there are two ways in which parameter updates are applied: `dynamic` or `pending-reboot`. Parameters marked with a `dynamic` apply type are applied immediately. Parameters marked with a `pending-reboot` apply type are applied only after the database is rebooted using the `reboot relational database` operation.
     *
     * The `update relational database parameters` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    override suspend fun updateRelationalDatabaseParameters(input: UpdateRelationalDatabaseParametersRequest): UpdateRelationalDatabaseParametersResponse {
        val op = SdkHttpOperation.build<UpdateRelationalDatabaseParametersRequest, UpdateRelationalDatabaseParametersResponse> {
            serializeWith = UpdateRelationalDatabaseParametersOperationSerializer()
            deserializeWith = UpdateRelationalDatabaseParametersOperationDeserializer()
            operationName = "UpdateRelationalDatabaseParameters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("Lightsail_20161128", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "lightsail")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
