// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.serde

import aws.sdk.kotlin.services.lightsail.model.GetContainerApiMetadataResponse
import aws.sdk.kotlin.services.lightsail.model.LightsailException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetContainerAPIMetadataOperationDeserializer: HttpDeserialize<GetContainerApiMetadataResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetContainerApiMetadataResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetContainerApiMetadataError(context, call)
        }
        val builder = GetContainerApiMetadataResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetContainerAPIMetadataOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetContainerApiMetadataError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LightsailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthenticatedException" -> UnauthenticatedExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LightsailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetContainerAPIMetadataOperationBody(builder: GetContainerApiMetadataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("metadata"))
    val METADATA_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(METADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                METADATA_DESCRIPTOR.index -> builder.metadata =
                    deserializer.deserializeList(METADATA_DESCRIPTOR) {
                        val col0 = mutableListOf<Map<String, String>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeMap(METADATA_C0_DESCRIPTOR) {
                                val map1 = mutableMapOf<String, String>()
                                while (hasNextEntry()) {
                                    val k1 = key()
                                    val v1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                    map1[k1] = v1
                                }
                                map1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
