// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.serde

import aws.sdk.kotlin.services.lightsail.model.CreateKeyPairResponse
import aws.sdk.kotlin.services.lightsail.model.KeyPair
import aws.sdk.kotlin.services.lightsail.model.LightsailException
import aws.sdk.kotlin.services.lightsail.model.Operation
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateKeyPairOperationDeserializer: HttpDeserialize<CreateKeyPairResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateKeyPairResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateKeyPairError(context, call)
        }
        val builder = CreateKeyPairResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateKeyPairOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateKeyPairError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LightsailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationFailureException" -> OperationFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthenticatedException" -> UnauthenticatedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        "AccountSetupInProgressException" -> AccountSetupInProgressExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LightsailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateKeyPairOperationBody(builder: CreateKeyPairResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYPAIR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("keyPair"))
    val OPERATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("operation"))
    val PRIVATEKEYBASE64_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("privateKeyBase64"))
    val PUBLICKEYBASE64_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("publicKeyBase64"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYPAIR_DESCRIPTOR)
        field(OPERATION_DESCRIPTOR)
        field(PRIVATEKEYBASE64_DESCRIPTOR)
        field(PUBLICKEYBASE64_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYPAIR_DESCRIPTOR.index -> builder.keyPair = deserializeKeyPairDocument(deserializer)
                OPERATION_DESCRIPTOR.index -> builder.operation = deserializeOperationDocument(deserializer)
                PRIVATEKEYBASE64_DESCRIPTOR.index -> builder.privateKeyBase64 = deserializeString()
                PUBLICKEYBASE64_DESCRIPTOR.index -> builder.publicKeyBase64 = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
