// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class UpdateInstanceMetadataOptionsRequest private constructor(builder: Builder) {
    /**
     * Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified, the existing state is maintained.
     *
     * If you specify a value of `disabled`, you cannot access your instance metadata.
     */
    public val httpEndpoint: aws.sdk.kotlin.services.lightsail.model.HttpEndpoint? = builder.httpEndpoint
    /**
     * Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only when the HTTP metadata endpoint is enabled.
     *
     * This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (`eu-north-1`).
     */
    public val httpProtocolIpv6: aws.sdk.kotlin.services.lightsail.model.HttpProtocolIpv6? = builder.httpProtocolIpv6
    /**
     * The desired HTTP PUT response hop limit for instance metadata requests. A larger number means that the instance metadata requests can travel farther. If no parameter is specified, the existing state is maintained.
     */
    public val httpPutResponseHopLimit: kotlin.Int? = builder.httpPutResponseHopLimit
    /**
     * The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is `optional`.
     *
     * If the state is `optional`, you can choose whether to retrieve instance metadata with a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials by using a valid signed token, the version 2.0 role credentials are returned.
     *
     * If the state is `required`, you must send a signed token header with all instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials. The version 1.0 credentials are not available.
     */
    public val httpTokens: aws.sdk.kotlin.services.lightsail.model.HttpTokens? = builder.httpTokens
    /**
     * The name of the instance for which to update metadata parameters.
     */
    public val instanceName: kotlin.String? = builder.instanceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.UpdateInstanceMetadataOptionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateInstanceMetadataOptionsRequest(")
        append("httpEndpoint=$httpEndpoint,")
        append("httpProtocolIpv6=$httpProtocolIpv6,")
        append("httpPutResponseHopLimit=$httpPutResponseHopLimit,")
        append("httpTokens=$httpTokens,")
        append("instanceName=$instanceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpEndpoint?.hashCode() ?: 0
        result = 31 * result + (httpProtocolIpv6?.hashCode() ?: 0)
        result = 31 * result + (httpPutResponseHopLimit ?: 0)
        result = 31 * result + (httpTokens?.hashCode() ?: 0)
        result = 31 * result + (instanceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateInstanceMetadataOptionsRequest

        if (httpEndpoint != other.httpEndpoint) return false
        if (httpProtocolIpv6 != other.httpProtocolIpv6) return false
        if (httpPutResponseHopLimit != other.httpPutResponseHopLimit) return false
        if (httpTokens != other.httpTokens) return false
        if (instanceName != other.instanceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.UpdateInstanceMetadataOptionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Enables or disables the HTTP metadata endpoint on your instances. If this parameter is not specified, the existing state is maintained.
         *
         * If you specify a value of `disabled`, you cannot access your instance metadata.
         */
        public var httpEndpoint: aws.sdk.kotlin.services.lightsail.model.HttpEndpoint? = null
        /**
         * Enables or disables the IPv6 endpoint for the instance metadata service. This setting applies only when the HTTP metadata endpoint is enabled.
         *
         * This parameter is available only for instances in the Europe (Stockholm) Amazon Web Services Region (`eu-north-1`).
         */
        public var httpProtocolIpv6: aws.sdk.kotlin.services.lightsail.model.HttpProtocolIpv6? = null
        /**
         * The desired HTTP PUT response hop limit for instance metadata requests. A larger number means that the instance metadata requests can travel farther. If no parameter is specified, the existing state is maintained.
         */
        public var httpPutResponseHopLimit: kotlin.Int? = null
        /**
         * The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is `optional`.
         *
         * If the state is `optional`, you can choose whether to retrieve instance metadata with a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials by using a valid signed token, the version 2.0 role credentials are returned.
         *
         * If the state is `required`, you must send a signed token header with all instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials. The version 1.0 credentials are not available.
         */
        public var httpTokens: aws.sdk.kotlin.services.lightsail.model.HttpTokens? = null
        /**
         * The name of the instance for which to update metadata parameters.
         */
        public var instanceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.UpdateInstanceMetadataOptionsRequest) : this() {
            this.httpEndpoint = x.httpEndpoint
            this.httpProtocolIpv6 = x.httpProtocolIpv6
            this.httpPutResponseHopLimit = x.httpPutResponseHopLimit
            this.httpTokens = x.httpTokens
            this.instanceName = x.instanceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.UpdateInstanceMetadataOptionsRequest = UpdateInstanceMetadataOptionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
