// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a static IP.
 */
public class StaticIp private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the static IP (`arn:aws:lightsail:us-east-2:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE`).
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The instance where the static IP is attached (`Amazon_Linux-1GB-Ohio-1`).
     */
    public val attachedTo: kotlin.String? = builder.attachedTo
    /**
     * The timestamp when the static IP was created (`1479735304.222`).
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The static IP address.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * A Boolean value indicating whether the static IP is attached.
     */
    public val isAttached: kotlin.Boolean? = builder.isAttached
    /**
     * The region and Availability Zone where the static IP was created.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the static IP (`StaticIP-Ohio-EXAMPLE`).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The resource type (usually `StaticIp`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.StaticIp = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StaticIp(")
        append("arn=$arn,")
        append("attachedTo=$attachedTo,")
        append("createdAt=$createdAt,")
        append("ipAddress=$ipAddress,")
        append("isAttached=$isAttached,")
        append("location=$location,")
        append("name=$name,")
        append("resourceType=$resourceType,")
        append("supportCode=$supportCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attachedTo?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (isAttached?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StaticIp

        if (arn != other.arn) return false
        if (attachedTo != other.attachedTo) return false
        if (createdAt != other.createdAt) return false
        if (ipAddress != other.ipAddress) return false
        if (isAttached != other.isAttached) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (resourceType != other.resourceType) return false
        if (supportCode != other.supportCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.StaticIp = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the static IP (`arn:aws:lightsail:us-east-2:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE`).
         */
        public var arn: kotlin.String? = null
        /**
         * The instance where the static IP is attached (`Amazon_Linux-1GB-Ohio-1`).
         */
        public var attachedTo: kotlin.String? = null
        /**
         * The timestamp when the static IP was created (`1479735304.222`).
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The static IP address.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * A Boolean value indicating whether the static IP is attached.
         */
        public var isAttached: kotlin.Boolean? = null
        /**
         * The region and Availability Zone where the static IP was created.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the static IP (`StaticIP-Ohio-EXAMPLE`).
         */
        public var name: kotlin.String? = null
        /**
         * The resource type (usually `StaticIp`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.StaticIp) : this() {
            this.arn = x.arn
            this.attachedTo = x.attachedTo
            this.createdAt = x.createdAt
            this.ipAddress = x.ipAddress
            this.isAttached = x.isAttached
            this.location = x.location
            this.name = x.name
            this.resourceType = x.resourceType
            this.supportCode = x.supportCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.StaticIp = StaticIp(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
