// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the status of a SSL/TLS certificate renewal managed by Amazon Lightsail.
 */
public class RenewalSummary private constructor(builder: Builder) {
    /**
     * An array of objects that describe the domain validation records of the certificate.
     */
    public val domainValidationRecords: List<DomainValidationRecord>? = builder.domainValidationRecords
    /**
     * The renewal status of the certificate.
     *
     * The following renewal status are possible:
     * + **`PendingAutoRenewal`** - Lightsail is attempting to automatically validate the domain names of the certificate. No further action is required.
     * + **`PendingValidation`** - Lightsail couldn't automatically validate one or more domain names of the certificate. You must take action to validate these domain names or the certificate won't be renewed. Check to make sure your certificate's domain validation records exist in your domain's DNS, and that your certificate remains in use.
     * + **`Success`** - All domain names in the certificate are validated, and Lightsail renewed the certificate. No further action is required.
     * + **`Failed`** - One or more domain names were not validated before the certificate expired, and Lightsail did not renew the certificate. You can request a new certificate using the `CreateCertificate` action.
     */
    public val renewalStatus: aws.sdk.kotlin.services.lightsail.model.RenewalStatus? = builder.renewalStatus
    /**
     * The reason for the renewal status of the certificate.
     */
    public val renewalStatusReason: kotlin.String? = builder.renewalStatusReason
    /**
     * The timestamp when the certificate was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.RenewalSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RenewalSummary(")
        append("domainValidationRecords=$domainValidationRecords,")
        append("renewalStatus=$renewalStatus,")
        append("renewalStatusReason=$renewalStatusReason,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainValidationRecords?.hashCode() ?: 0
        result = 31 * result + (renewalStatus?.hashCode() ?: 0)
        result = 31 * result + (renewalStatusReason?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RenewalSummary

        if (domainValidationRecords != other.domainValidationRecords) return false
        if (renewalStatus != other.renewalStatus) return false
        if (renewalStatusReason != other.renewalStatusReason) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.RenewalSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of objects that describe the domain validation records of the certificate.
         */
        public var domainValidationRecords: List<DomainValidationRecord>? = null
        /**
         * The renewal status of the certificate.
         *
         * The following renewal status are possible:
         * + **`PendingAutoRenewal`** - Lightsail is attempting to automatically validate the domain names of the certificate. No further action is required.
         * + **`PendingValidation`** - Lightsail couldn't automatically validate one or more domain names of the certificate. You must take action to validate these domain names or the certificate won't be renewed. Check to make sure your certificate's domain validation records exist in your domain's DNS, and that your certificate remains in use.
         * + **`Success`** - All domain names in the certificate are validated, and Lightsail renewed the certificate. No further action is required.
         * + **`Failed`** - One or more domain names were not validated before the certificate expired, and Lightsail did not renew the certificate. You can request a new certificate using the `CreateCertificate` action.
         */
        public var renewalStatus: aws.sdk.kotlin.services.lightsail.model.RenewalStatus? = null
        /**
         * The reason for the renewal status of the certificate.
         */
        public var renewalStatusReason: kotlin.String? = null
        /**
         * The timestamp when the certificate was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.RenewalSummary) : this() {
            this.domainValidationRecords = x.domainValidationRecords
            this.renewalStatus = x.renewalStatus
            this.renewalStatusReason = x.renewalStatusReason
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.RenewalSummary = RenewalSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
