// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes a database image, or blueprint. A blueprint describes the major engine version of a database.
 */
public class RelationalDatabaseBlueprint private constructor(builder: Builder) {
    /**
     * The ID for the database blueprint.
     */
    public val blueprintId: kotlin.String? = builder.blueprintId
    /**
     * The database software of the database blueprint (for example, `MySQL`).
     */
    public val engine: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseEngine? = builder.engine
    /**
     * The description of the database engine for the database blueprint.
     */
    public val engineDescription: kotlin.String? = builder.engineDescription
    /**
     * The database engine version for the database blueprint (for example, `5.7.23`).
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The description of the database engine version for the database blueprint.
     */
    public val engineVersionDescription: kotlin.String? = builder.engineVersionDescription
    /**
     * A Boolean value indicating whether the engine version is the default for the database blueprint.
     */
    public val isEngineDefault: kotlin.Boolean? = builder.isEngineDefault

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseBlueprint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RelationalDatabaseBlueprint(")
        append("blueprintId=$blueprintId,")
        append("engine=$engine,")
        append("engineDescription=$engineDescription,")
        append("engineVersion=$engineVersion,")
        append("engineVersionDescription=$engineVersionDescription,")
        append("isEngineDefault=$isEngineDefault")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blueprintId?.hashCode() ?: 0
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineDescription?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (engineVersionDescription?.hashCode() ?: 0)
        result = 31 * result + (isEngineDefault?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RelationalDatabaseBlueprint

        if (blueprintId != other.blueprintId) return false
        if (engine != other.engine) return false
        if (engineDescription != other.engineDescription) return false
        if (engineVersion != other.engineVersion) return false
        if (engineVersionDescription != other.engineVersionDescription) return false
        if (isEngineDefault != other.isEngineDefault) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseBlueprint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the database blueprint.
         */
        public var blueprintId: kotlin.String? = null
        /**
         * The database software of the database blueprint (for example, `MySQL`).
         */
        public var engine: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseEngine? = null
        /**
         * The description of the database engine for the database blueprint.
         */
        public var engineDescription: kotlin.String? = null
        /**
         * The database engine version for the database blueprint (for example, `5.7.23`).
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The description of the database engine version for the database blueprint.
         */
        public var engineVersionDescription: kotlin.String? = null
        /**
         * A Boolean value indicating whether the engine version is the default for the database blueprint.
         */
        public var isEngineDefault: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseBlueprint) : this() {
            this.blueprintId = x.blueprintId
            this.engine = x.engine
            this.engineDescription = x.engineDescription
            this.engineVersion = x.engineVersion
            this.engineVersionDescription = x.engineVersionDescription
            this.isEngineDefault = x.isEngineDefault
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseBlueprint = RelationalDatabaseBlueprint(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
