// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class RegisterContainerImageRequest private constructor(builder: Builder) {
    /**
     * The digest of the container image to be registered.
     */
    public val digest: kotlin.String? = builder.digest
    /**
     * The label for the container image when it's registered to the container service.
     *
     * Use a descriptive label that you can use to track the different versions of your registered container images.
     *
     * Use the `GetContainerImages` action to return the container images registered to a Lightsail container service. The label is the `<imagelabel>` portion of the following image name example:
     * + `:container-service-1.<imagelabel>.1`
     *
     * If the name of your container service is `mycontainerservice`, and the label that you specify is `mystaticwebsite`, then the name of the registered container image will be `:mycontainerservice.mystaticwebsite.1`.
     *
     * The number at the end of these image name examples represents the version of the registered container image. If you push and register another container image to the same Lightsail container service, with the same label, then the version number for the new registered container image will be `2`. If you push and register another container image, the version number will be `3`, and so on.
     */
    public val label: kotlin.String? = builder.label
    /**
     * The name of the container service for which to register a container image.
     */
    public val serviceName: kotlin.String? = builder.serviceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.RegisterContainerImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterContainerImageRequest(")
        append("digest=$digest,")
        append("label=$label,")
        append("serviceName=$serviceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = digest?.hashCode() ?: 0
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterContainerImageRequest

        if (digest != other.digest) return false
        if (label != other.label) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.RegisterContainerImageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The digest of the container image to be registered.
         */
        public var digest: kotlin.String? = null
        /**
         * The label for the container image when it's registered to the container service.
         *
         * Use a descriptive label that you can use to track the different versions of your registered container images.
         *
         * Use the `GetContainerImages` action to return the container images registered to a Lightsail container service. The label is the `<imagelabel>` portion of the following image name example:
         * + `:container-service-1.<imagelabel>.1`
         *
         * If the name of your container service is `mycontainerservice`, and the label that you specify is `mystaticwebsite`, then the name of the registered container image will be `:mycontainerservice.mystaticwebsite.1`.
         *
         * The number at the end of these image name examples represents the version of the registered container image. If you push and register another container image to the same Lightsail container service, with the same label, then the version number for the new registered container image will be `2`. If you push and register another container image, the version number will be `3`, and so on.
         */
        public var label: kotlin.String? = null
        /**
         * The name of the container service for which to register a container image.
         */
        public var serviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.RegisterContainerImageRequest) : this() {
            this.digest = x.digest
            this.label = x.label
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.RegisterContainerImageRequest = RegisterContainerImageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
