// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the state of the name server records update made by Amazon Lightsail to an Amazon Route 53 registered domain.
 *
 * For more information, see [DNS in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/understanding-dns-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
 */
public class NameServersUpdateState private constructor(builder: Builder) {
    /**
     * The status code for the name servers update.
     *
     * Following are the possible values:
     * + `SUCCEEDED` - The name server records were successfully updated.
     * + `PENDING` - The name server record update is in progress.
     * + `FAILED` - The name server record update failed.
     * + `STARTED` - The automatic name server record update started.
     */
    public val code: aws.sdk.kotlin.services.lightsail.model.NameServersUpdateStateCode? = builder.code
    /**
     * The message that describes the reason for the status code.
     */
    public val message: kotlin.String? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.NameServersUpdateState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NameServersUpdateState(")
        append("code=$code,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NameServersUpdateState

        if (code != other.code) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.NameServersUpdateState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The status code for the name servers update.
         *
         * Following are the possible values:
         * + `SUCCEEDED` - The name server records were successfully updated.
         * + `PENDING` - The name server record update is in progress.
         * + `FAILED` - The name server record update failed.
         * + `STARTED` - The automatic name server record update started.
         */
        public var code: aws.sdk.kotlin.services.lightsail.model.NameServersUpdateStateCode? = null
        /**
         * The message that describes the reason for the status code.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.NameServersUpdateState) : this() {
            this.code = x.code
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.NameServersUpdateState = NameServersUpdateState(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
