// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes resource being monitored by an alarm.
 *
 * An alarm is a way to monitor your Amazon Lightsail resource metrics. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
 */
public class MonitoredResourceInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource being monitored.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the Lightsail resource being monitored.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Lightsail resource type of the resource being monitored.
     *
     * Instances, load balancers, and relational databases are the only Lightsail resources that can currently be monitored by alarms.
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.MonitoredResourceInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoredResourceInfo(")
        append("arn=$arn,")
        append("name=$name,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoredResourceInfo

        if (arn != other.arn) return false
        if (name != other.name) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.MonitoredResourceInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource being monitored.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the Lightsail resource being monitored.
         */
        public var name: kotlin.String? = null
        /**
         * The Lightsail resource type of the resource being monitored.
         *
         * Instances, load balancers, and relational databases are the only Lightsail resources that can currently be monitored by alarms.
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.MonitoredResourceInfo) : this() {
            this.arn = x.arn
            this.name = x.name
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.MonitoredResourceInfo = MonitoredResourceInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
