// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the TLS security policies that are available for Lightsail load balancers.
 *
 * For more information about load balancer TLS security policies, see [Configuring TLS security policies on your Amazon Lightsail load balancers](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configure-load-balancer-tls-security-policy) in the *Amazon Lightsail Developer Guide*.
 */
public class LoadBalancerTlsPolicy private constructor(builder: Builder) {
    /**
     * The ciphers used by the TLS security policy.
     *
     * The ciphers are listed in order of preference.
     */
    public val ciphers: List<String>? = builder.ciphers
    /**
     * The description of the TLS security policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A Boolean value that indicates whether the TLS security policy is the default.
     */
    public val isDefault: kotlin.Boolean? = builder.isDefault
    /**
     * The name of the TLS security policy.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The protocols used in a given TLS security policy.
     */
    public val protocols: List<String>? = builder.protocols

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerTlsPolicy(")
        append("ciphers=$ciphers,")
        append("description=$description,")
        append("isDefault=$isDefault,")
        append("name=$name,")
        append("protocols=$protocols")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphers?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isDefault?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerTlsPolicy

        if (ciphers != other.ciphers) return false
        if (description != other.description) return false
        if (isDefault != other.isDefault) return false
        if (name != other.name) return false
        if (protocols != other.protocols) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ciphers used by the TLS security policy.
         *
         * The ciphers are listed in order of preference.
         */
        public var ciphers: List<String>? = null
        /**
         * The description of the TLS security policy.
         */
        public var description: kotlin.String? = null
        /**
         * A Boolean value that indicates whether the TLS security policy is the default.
         */
        public var isDefault: kotlin.Boolean? = null
        /**
         * The name of the TLS security policy.
         */
        public var name: kotlin.String? = null
        /**
         * The protocols used in a given TLS security policy.
         */
        public var protocols: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsPolicy) : this() {
            this.ciphers = x.ciphers
            this.description = x.description
            this.isDefault = x.isDefault
            this.name = x.name
            this.protocols = x.protocols
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsPolicy = LoadBalancerTlsPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
