// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a load balancer SSL/TLS certificate.
 *
 * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
 */
public class LoadBalancerTlsCertificate private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the SSL/TLS certificate.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when you created your SSL/TLS certificate.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The domain name for your SSL/TLS certificate.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the records.
     */
    public val domainValidationRecords: List<LoadBalancerTlsCertificateDomainValidationRecord>? = builder.domainValidationRecords
    /**
     * The validation failure reason, if any, of the certificate.
     *
     * The following failure reasons are possible:
     * + **`NO_AVAILABLE_CONTACTS`** - This failure applies to email validation, which is not available for Lightsail certificates.
     * + **`ADDITIONAL_VERIFICATION_REQUIRED`** - Lightsail requires additional information to process this certificate request. This can happen as a fraud-protection measure, such as when the domain ranks within the Alexa top 1000 websites. To provide the required information, use the [AWS Support Center](https://console.aws.amazon.com/support/home) to contact AWS Support.You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.
     * + **`DOMAIN_NOT_ALLOWED`** - One or more of the domain names in the certificate request was reported as an unsafe domain by [VirusTotal](https://www.virustotal.com/gui/home/url). To correct the problem, search for your domain name on the [VirusTotal](https://www.virustotal.com/gui/home/url) website. If your domain is reported as suspicious, see [Google Help for Hacked Websites](https://developers.google.com/web/fundamentals/security/hacked) to learn what you can do.If you believe that the result is a false positive, notify the organization that is reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a block list itself. After you correct the problem and the VirusTotal registry has been updated, request a new certificate.If you see this error and your domain is not included in the VirusTotal list, visit the [AWS Support Center](https://console.aws.amazon.com/support/home) and create a case.
     * + **`INVALID_PUBLIC_DOMAIN`** - One or more of the domain names in the certificate request is not valid. Typically, this is because a domain name in the request is not a valid top-level domain. Try to request a certificate again, correcting any spelling errors or typos that were in the failed request, and ensure that all domain names in the request are for valid top-level domains. For example, you cannot request a certificate for `example.invalidpublicdomain` because `invalidpublicdomain` is not a valid top-level domain.
     * + **`OTHER`** - Typically, this failure occurs when there is a typographical error in one or more of the domain names in the certificate request. Try to request a certificate again, correcting any spelling errors or typos that were in the failed request.
     */
    public val failureReason: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateFailureReason? = builder.failureReason
    /**
     * When `true`, the SSL/TLS certificate is attached to the Lightsail load balancer.
     */
    public val isAttached: kotlin.Boolean? = builder.isAttached
    /**
     * The time when the SSL/TLS certificate was issued.
     */
    public val issuedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.issuedAt
    /**
     * The issuer of the certificate.
     */
    public val issuer: kotlin.String? = builder.issuer
    /**
     * The algorithm used to generate the key pair (the public and private key).
     */
    public val keyAlgorithm: kotlin.String? = builder.keyAlgorithm
    /**
     * The load balancer name where your SSL/TLS certificate is attached.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The Amazon Web Services Region and Availability Zone where you created your certificate.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the SSL/TLS certificate (`my-certificate`).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The timestamp when the SSL/TLS certificate expires.
     */
    public val notAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.notAfter
    /**
     * The timestamp when the SSL/TLS certificate is first valid.
     */
    public val notBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.notBefore
    /**
     * An object that describes the status of the certificate renewal managed by Lightsail.
     */
    public val renewalSummary: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary? = builder.renewalSummary
    /**
     * The resource type (`LoadBalancerTlsCertificate`).
     * + **`Instance`** - A Lightsail instance (a virtual private server)
     * + **`StaticIp`** - A static IP address
     * + **`KeyPair`** - The key pair used to connect to a Lightsail instance
     * + **`InstanceSnapshot`** - A Lightsail instance snapshot
     * + **`Domain`** - A DNS zone
     * + **`PeeredVpc`** - A peered VPC
     * + **`LoadBalancer`** - A Lightsail load balancer
     * + **`LoadBalancerTlsCertificate`** - An SSL/TLS certificate associated with a Lightsail load balancer
     * + **`Disk`** - A Lightsail block storage disk
     * + **`DiskSnapshot`** - A block storage disk snapshot
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The reason the certificate was revoked. This value is present only when the certificate status is `REVOKED`.
     */
    public val revocationReason: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRevocationReason? = builder.revocationReason
    /**
     * The timestamp when the certificate was revoked. This value is present only when the certificate status is `REVOKED`.
     */
    public val revokedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.revokedAt
    /**
     * The serial number of the certificate.
     */
    public val serial: kotlin.String? = builder.serial
    /**
     * The algorithm that was used to sign the certificate.
     */
    public val signatureAlgorithm: kotlin.String? = builder.signatureAlgorithm
    /**
     * The validation status of the SSL/TLS certificate. Valid values are below.
     */
    public val status: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateStatus? = builder.status
    /**
     * The name of the entity that is associated with the public key contained in the certificate.
     */
    public val subject: kotlin.String? = builder.subject
    /**
     * An array of strings that specify the alternate domains (`example2.com`) and subdomains (`blog.example.com`) for the certificate.
     */
    public val subjectAlternativeNames: List<String>? = builder.subjectAlternativeNames
    /**
     * The support code. Include this code in your email to support when you have questions about your Lightsail load balancer or SSL/TLS certificate. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerTlsCertificate(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("domainName=$domainName,")
        append("domainValidationRecords=$domainValidationRecords,")
        append("failureReason=$failureReason,")
        append("isAttached=$isAttached,")
        append("issuedAt=$issuedAt,")
        append("issuer=$issuer,")
        append("keyAlgorithm=$keyAlgorithm,")
        append("loadBalancerName=$loadBalancerName,")
        append("location=$location,")
        append("name=$name,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("renewalSummary=$renewalSummary,")
        append("resourceType=$resourceType,")
        append("revocationReason=$revocationReason,")
        append("revokedAt=$revokedAt,")
        append("serial=$serial,")
        append("signatureAlgorithm=$signatureAlgorithm,")
        append("status=$status,")
        append("subject=$subject,")
        append("subjectAlternativeNames=$subjectAlternativeNames,")
        append("supportCode=$supportCode,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainValidationRecords?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (isAttached?.hashCode() ?: 0)
        result = 31 * result + (issuedAt?.hashCode() ?: 0)
        result = 31 * result + (issuer?.hashCode() ?: 0)
        result = 31 * result + (keyAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (renewalSummary?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (revocationReason?.hashCode() ?: 0)
        result = 31 * result + (revokedAt?.hashCode() ?: 0)
        result = 31 * result + (serial?.hashCode() ?: 0)
        result = 31 * result + (signatureAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNames?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerTlsCertificate

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (domainName != other.domainName) return false
        if (domainValidationRecords != other.domainValidationRecords) return false
        if (failureReason != other.failureReason) return false
        if (isAttached != other.isAttached) return false
        if (issuedAt != other.issuedAt) return false
        if (issuer != other.issuer) return false
        if (keyAlgorithm != other.keyAlgorithm) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (renewalSummary != other.renewalSummary) return false
        if (resourceType != other.resourceType) return false
        if (revocationReason != other.revocationReason) return false
        if (revokedAt != other.revokedAt) return false
        if (serial != other.serial) return false
        if (signatureAlgorithm != other.signatureAlgorithm) return false
        if (status != other.status) return false
        if (subject != other.subject) return false
        if (subjectAlternativeNames != other.subjectAlternativeNames) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the SSL/TLS certificate.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when you created your SSL/TLS certificate.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The domain name for your SSL/TLS certificate.
         */
        public var domainName: kotlin.String? = null
        /**
         * An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the records.
         */
        public var domainValidationRecords: List<LoadBalancerTlsCertificateDomainValidationRecord>? = null
        /**
         * The validation failure reason, if any, of the certificate.
         *
         * The following failure reasons are possible:
         * + **`NO_AVAILABLE_CONTACTS`** - This failure applies to email validation, which is not available for Lightsail certificates.
         * + **`ADDITIONAL_VERIFICATION_REQUIRED`** - Lightsail requires additional information to process this certificate request. This can happen as a fraud-protection measure, such as when the domain ranks within the Alexa top 1000 websites. To provide the required information, use the [AWS Support Center](https://console.aws.amazon.com/support/home) to contact AWS Support.You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.
         * + **`DOMAIN_NOT_ALLOWED`** - One or more of the domain names in the certificate request was reported as an unsafe domain by [VirusTotal](https://www.virustotal.com/gui/home/url). To correct the problem, search for your domain name on the [VirusTotal](https://www.virustotal.com/gui/home/url) website. If your domain is reported as suspicious, see [Google Help for Hacked Websites](https://developers.google.com/web/fundamentals/security/hacked) to learn what you can do.If you believe that the result is a false positive, notify the organization that is reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a block list itself. After you correct the problem and the VirusTotal registry has been updated, request a new certificate.If you see this error and your domain is not included in the VirusTotal list, visit the [AWS Support Center](https://console.aws.amazon.com/support/home) and create a case.
         * + **`INVALID_PUBLIC_DOMAIN`** - One or more of the domain names in the certificate request is not valid. Typically, this is because a domain name in the request is not a valid top-level domain. Try to request a certificate again, correcting any spelling errors or typos that were in the failed request, and ensure that all domain names in the request are for valid top-level domains. For example, you cannot request a certificate for `example.invalidpublicdomain` because `invalidpublicdomain` is not a valid top-level domain.
         * + **`OTHER`** - Typically, this failure occurs when there is a typographical error in one or more of the domain names in the certificate request. Try to request a certificate again, correcting any spelling errors or typos that were in the failed request.
         */
        public var failureReason: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateFailureReason? = null
        /**
         * When `true`, the SSL/TLS certificate is attached to the Lightsail load balancer.
         */
        public var isAttached: kotlin.Boolean? = null
        /**
         * The time when the SSL/TLS certificate was issued.
         */
        public var issuedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The issuer of the certificate.
         */
        public var issuer: kotlin.String? = null
        /**
         * The algorithm used to generate the key pair (the public and private key).
         */
        public var keyAlgorithm: kotlin.String? = null
        /**
         * The load balancer name where your SSL/TLS certificate is attached.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The Amazon Web Services Region and Availability Zone where you created your certificate.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the SSL/TLS certificate (`my-certificate`).
         */
        public var name: kotlin.String? = null
        /**
         * The timestamp when the SSL/TLS certificate expires.
         */
        public var notAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when the SSL/TLS certificate is first valid.
         */
        public var notBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the status of the certificate renewal managed by Lightsail.
         */
        public var renewalSummary: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary? = null
        /**
         * The resource type (`LoadBalancerTlsCertificate`).
         * + **`Instance`** - A Lightsail instance (a virtual private server)
         * + **`StaticIp`** - A static IP address
         * + **`KeyPair`** - The key pair used to connect to a Lightsail instance
         * + **`InstanceSnapshot`** - A Lightsail instance snapshot
         * + **`Domain`** - A DNS zone
         * + **`PeeredVpc`** - A peered VPC
         * + **`LoadBalancer`** - A Lightsail load balancer
         * + **`LoadBalancerTlsCertificate`** - An SSL/TLS certificate associated with a Lightsail load balancer
         * + **`Disk`** - A Lightsail block storage disk
         * + **`DiskSnapshot`** - A block storage disk snapshot
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The reason the certificate was revoked. This value is present only when the certificate status is `REVOKED`.
         */
        public var revocationReason: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRevocationReason? = null
        /**
         * The timestamp when the certificate was revoked. This value is present only when the certificate status is `REVOKED`.
         */
        public var revokedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The serial number of the certificate.
         */
        public var serial: kotlin.String? = null
        /**
         * The algorithm that was used to sign the certificate.
         */
        public var signatureAlgorithm: kotlin.String? = null
        /**
         * The validation status of the SSL/TLS certificate. Valid values are below.
         */
        public var status: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateStatus? = null
        /**
         * The name of the entity that is associated with the public key contained in the certificate.
         */
        public var subject: kotlin.String? = null
        /**
         * An array of strings that specify the alternate domains (`example2.com`) and subdomains (`blog.example.com`) for the certificate.
         */
        public var subjectAlternativeNames: List<String>? = null
        /**
         * The support code. Include this code in your email to support when you have questions about your Lightsail load balancer or SSL/TLS certificate. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificate) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.domainName = x.domainName
            this.domainValidationRecords = x.domainValidationRecords
            this.failureReason = x.failureReason
            this.isAttached = x.isAttached
            this.issuedAt = x.issuedAt
            this.issuer = x.issuer
            this.keyAlgorithm = x.keyAlgorithm
            this.loadBalancerName = x.loadBalancerName
            this.location = x.location
            this.name = x.name
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.renewalSummary = x.renewalSummary
            this.resourceType = x.resourceType
            this.revocationReason = x.revocationReason
            this.revokedAt = x.revokedAt
            this.serial = x.serial
            this.signatureAlgorithm = x.signatureAlgorithm
            this.status = x.status
            this.subject = x.subject
            this.subjectAlternativeNames = x.subjectAlternativeNames
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificate = LoadBalancerTlsCertificate(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary] inside the given [block]
         */
        public fun renewalSummary(block: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.Builder.() -> kotlin.Unit) {
            this.renewalSummary = aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
