// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * The metadata options for the instance.
 */
public class InstanceMetadataOptions private constructor(builder: Builder) {
    /**
     * Indicates whether the HTTP metadata endpoint on your instances is enabled or disabled.
     *
     * If the value is `disabled`, you cannot access your instance metadata.
     */
    public val httpEndpoint: aws.sdk.kotlin.services.lightsail.model.HttpEndpoint? = builder.httpEndpoint
    /**
     * Indicates whether the IPv6 endpoint for the instance metadata service is enabled or disabled.
     */
    public val httpProtocolIpv6: aws.sdk.kotlin.services.lightsail.model.HttpProtocolIpv6? = builder.httpProtocolIpv6
    /**
     * The desired HTTP PUT response hop limit for instance metadata requests. A larger number means that the instance metadata requests can travel farther.
     */
    public val httpPutResponseHopLimit: kotlin.Int? = builder.httpPutResponseHopLimit
    /**
     * The state of token usage for your instance metadata requests.
     *
     * If the state is `optional`, you can choose whether to retrieve instance metadata with a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials by using a valid signed token, the version 2.0 role credentials are returned.
     *
     * If the state is `required`, you must send a signed token header with all instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials. The version 1.0 credentials are not available.
     *
     * Not all instance blueprints in Lightsail support version 2.0 credentials. Use the `MetadataNoToken` instance metric to track the number of calls to the instance metadata service that are using version 1.0 credentials. For more information, see [Viewing instance metrics in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-health-metrics) in the *Amazon Lightsail Developer Guide*.
     */
    public val httpTokens: aws.sdk.kotlin.services.lightsail.model.HttpTokens? = builder.httpTokens
    /**
     * The state of the metadata option changes.
     *
     * The following states are possible:
     * + `pending` - The metadata options are being updated. The instance is not yet ready to process metadata traffic with the new selection.
     * + `applied` - The metadata options have been successfully applied to the instance.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.InstanceMetadataState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.InstanceMetadataOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceMetadataOptions(")
        append("httpEndpoint=$httpEndpoint,")
        append("httpProtocolIpv6=$httpProtocolIpv6,")
        append("httpPutResponseHopLimit=$httpPutResponseHopLimit,")
        append("httpTokens=$httpTokens,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpEndpoint?.hashCode() ?: 0
        result = 31 * result + (httpProtocolIpv6?.hashCode() ?: 0)
        result = 31 * result + (httpPutResponseHopLimit ?: 0)
        result = 31 * result + (httpTokens?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceMetadataOptions

        if (httpEndpoint != other.httpEndpoint) return false
        if (httpProtocolIpv6 != other.httpProtocolIpv6) return false
        if (httpPutResponseHopLimit != other.httpPutResponseHopLimit) return false
        if (httpTokens != other.httpTokens) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.InstanceMetadataOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the HTTP metadata endpoint on your instances is enabled or disabled.
         *
         * If the value is `disabled`, you cannot access your instance metadata.
         */
        public var httpEndpoint: aws.sdk.kotlin.services.lightsail.model.HttpEndpoint? = null
        /**
         * Indicates whether the IPv6 endpoint for the instance metadata service is enabled or disabled.
         */
        public var httpProtocolIpv6: aws.sdk.kotlin.services.lightsail.model.HttpProtocolIpv6? = null
        /**
         * The desired HTTP PUT response hop limit for instance metadata requests. A larger number means that the instance metadata requests can travel farther.
         */
        public var httpPutResponseHopLimit: kotlin.Int? = null
        /**
         * The state of token usage for your instance metadata requests.
         *
         * If the state is `optional`, you can choose whether to retrieve instance metadata with a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials by using a valid signed token, the version 2.0 role credentials are returned.
         *
         * If the state is `required`, you must send a signed token header with all instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials. The version 1.0 credentials are not available.
         *
         * Not all instance blueprints in Lightsail support version 2.0 credentials. Use the `MetadataNoToken` instance metric to track the number of calls to the instance metadata service that are using version 1.0 credentials. For more information, see [Viewing instance metrics in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-health-metrics) in the *Amazon Lightsail Developer Guide*.
         */
        public var httpTokens: aws.sdk.kotlin.services.lightsail.model.HttpTokens? = null
        /**
         * The state of the metadata option changes.
         *
         * The following states are possible:
         * + `pending` - The metadata options are being updated. The instance is not yet ready to process metadata traffic with the new selection.
         * + `applied` - The metadata options have been successfully applied to the instance.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.InstanceMetadataState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.InstanceMetadataOptions) : this() {
            this.httpEndpoint = x.httpEndpoint
            this.httpProtocolIpv6 = x.httpProtocolIpv6
            this.httpPutResponseHopLimit = x.httpPutResponseHopLimit
            this.httpTokens = x.httpTokens
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.InstanceMetadataOptions = InstanceMetadataOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
