// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes information about the health of the instance.
 */
public class InstanceHealthSummary private constructor(builder: Builder) {
    /**
     * Describes the overall instance health. Valid values are below.
     */
    public val instanceHealth: aws.sdk.kotlin.services.lightsail.model.InstanceHealthState? = builder.instanceHealth
    /**
     * More information about the instance health. If the `instanceHealth` is `healthy`, then an `instanceHealthReason` value is not provided.
     *
     * If **`instanceHealth`** is `initial`, the **`instanceHealthReason`** value can be one of the following:
     * + **`Lb.RegistrationInProgress`** - The target instance is in the process of being registered with the load balancer.
     * + **`Lb.InitialHealthChecking`** - The Lightsail load balancer is still sending the target instance the minimum number of health checks required to determine its health status.
     *
     * If **`instanceHealth`** is `unhealthy`, the **`instanceHealthReason`** value can be one of the following:
     * + **`Instance.ResponseCodeMismatch`** - The health checks did not return an expected HTTP code.
     * + **`Instance.Timeout`** - The health check requests timed out.
     * + **`Instance.FailedHealthChecks`** - The health checks failed because the connection to the target instance timed out, the target instance response was malformed, or the target instance failed the health check for an unknown reason.
     * + **`Lb.InternalError`** - The health checks failed due to an internal error.
     *
     * If **`instanceHealth`** is `unused`, the **`instanceHealthReason`** value can be one of the following:
     * + **`Instance.NotRegistered`** - The target instance is not registered with the target group.
     * + **`Instance.NotInUse`** - The target group is not used by any load balancer, or the target instance is in an Availability Zone that is not enabled for its load balancer.
     * + **`Instance.IpUnusable`** - The target IP address is reserved for use by a Lightsail load balancer.
     * + **`Instance.InvalidState`** - The target is in the stopped or terminated state.
     *
     * If **`instanceHealth`** is `draining`, the **`instanceHealthReason`** value can be one of the following:
     * + **`Instance.DeregistrationInProgress`** - The target instance is in the process of being deregistered and the deregistration delay period has not expired.
     */
    public val instanceHealthReason: aws.sdk.kotlin.services.lightsail.model.InstanceHealthReason? = builder.instanceHealthReason
    /**
     * The name of the Lightsail instance for which you are requesting health check data.
     */
    public val instanceName: kotlin.String? = builder.instanceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.InstanceHealthSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceHealthSummary(")
        append("instanceHealth=$instanceHealth,")
        append("instanceHealthReason=$instanceHealthReason,")
        append("instanceName=$instanceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceHealth?.hashCode() ?: 0
        result = 31 * result + (instanceHealthReason?.hashCode() ?: 0)
        result = 31 * result + (instanceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceHealthSummary

        if (instanceHealth != other.instanceHealth) return false
        if (instanceHealthReason != other.instanceHealthReason) return false
        if (instanceName != other.instanceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.InstanceHealthSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the overall instance health. Valid values are below.
         */
        public var instanceHealth: aws.sdk.kotlin.services.lightsail.model.InstanceHealthState? = null
        /**
         * More information about the instance health. If the `instanceHealth` is `healthy`, then an `instanceHealthReason` value is not provided.
         *
         * If **`instanceHealth`** is `initial`, the **`instanceHealthReason`** value can be one of the following:
         * + **`Lb.RegistrationInProgress`** - The target instance is in the process of being registered with the load balancer.
         * + **`Lb.InitialHealthChecking`** - The Lightsail load balancer is still sending the target instance the minimum number of health checks required to determine its health status.
         *
         * If **`instanceHealth`** is `unhealthy`, the **`instanceHealthReason`** value can be one of the following:
         * + **`Instance.ResponseCodeMismatch`** - The health checks did not return an expected HTTP code.
         * + **`Instance.Timeout`** - The health check requests timed out.
         * + **`Instance.FailedHealthChecks`** - The health checks failed because the connection to the target instance timed out, the target instance response was malformed, or the target instance failed the health check for an unknown reason.
         * + **`Lb.InternalError`** - The health checks failed due to an internal error.
         *
         * If **`instanceHealth`** is `unused`, the **`instanceHealthReason`** value can be one of the following:
         * + **`Instance.NotRegistered`** - The target instance is not registered with the target group.
         * + **`Instance.NotInUse`** - The target group is not used by any load balancer, or the target instance is in an Availability Zone that is not enabled for its load balancer.
         * + **`Instance.IpUnusable`** - The target IP address is reserved for use by a Lightsail load balancer.
         * + **`Instance.InvalidState`** - The target is in the stopped or terminated state.
         *
         * If **`instanceHealth`** is `draining`, the **`instanceHealthReason`** value can be one of the following:
         * + **`Instance.DeregistrationInProgress`** - The target instance is in the process of being deregistered and the deregistration delay period has not expired.
         */
        public var instanceHealthReason: aws.sdk.kotlin.services.lightsail.model.InstanceHealthReason? = null
        /**
         * The name of the Lightsail instance for which you are requesting health check data.
         */
        public var instanceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.InstanceHealthSummary) : this() {
            this.instanceHealth = x.instanceHealth
            this.instanceHealthReason = x.instanceHealthReason
            this.instanceName = x.instanceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.InstanceHealthSummary = InstanceHealthSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
