// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The parameters for gaining temporary access to one of your Amazon Lightsail instances.
 */
public class InstanceAccessDetails private constructor(builder: Builder) {
    /**
     * For SSH access, the public key to use when accessing your instance For OpenSSH clients (command line SSH), you should save this value to `tempkey-cert.pub`.
     */
    public val certKey: kotlin.String? = builder.certKey
    /**
     * For SSH access, the date on which the temporary keys expire.
     */
    public val expiresAt: aws.smithy.kotlin.runtime.time.Instant? = builder.expiresAt
    /**
     * Describes the public SSH host keys or the RDP certificate.
     */
    public val hostKeys: List<HostKeyAttributes>? = builder.hostKeys
    /**
     * The name of this Amazon Lightsail instance.
     */
    public val instanceName: kotlin.String? = builder.instanceName
    /**
     * The public IP address of the Amazon Lightsail instance.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * The IPv6 address of the Amazon Lightsail instance.
     */
    public val ipv6Addresses: List<String>? = builder.ipv6Addresses
    /**
     * For RDP access, the password for your Amazon Lightsail instance. Password will be an empty string if the password for your new instance is not ready yet. When you create an instance, it can take up to 15 minutes for the instance to be ready.
     *
     * If you create an instance using any key pair other than the default (`LightsailDefaultKeyPair`), `password` will always be an empty string.
     *
     * If you change the Administrator password on the instance, Lightsail will continue to return the original password value. When accessing the instance using RDP, you need to manually enter the Administrator password after changing it from the default.
     */
    public val password: kotlin.String? = builder.password
    /**
     * For a Windows Server-based instance, an object with the data you can use to retrieve your password. This is only needed if `password` is empty and the instance is not new (and therefore the password is not ready yet). When you create an instance, it can take up to 15 minutes for the instance to be ready.
     */
    public val passwordData: aws.sdk.kotlin.services.lightsail.model.PasswordData? = builder.passwordData
    /**
     * For SSH access, the temporary private key. For OpenSSH clients (command line SSH), you should save this value to `tempkey`).
     */
    public val privateKey: kotlin.String? = builder.privateKey
    /**
     * The protocol for these Amazon Lightsail instance access details.
     */
    public val protocol: aws.sdk.kotlin.services.lightsail.model.InstanceAccessProtocol? = builder.protocol
    /**
     * The user name to use when logging in to the Amazon Lightsail instance.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.InstanceAccessDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceAccessDetails(")
        append("certKey=$certKey,")
        append("expiresAt=$expiresAt,")
        append("hostKeys=$hostKeys,")
        append("instanceName=$instanceName,")
        append("ipAddress=$ipAddress,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("password=$password,")
        append("passwordData=$passwordData,")
        append("privateKey=$privateKey,")
        append("protocol=$protocol,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certKey?.hashCode() ?: 0
        result = 31 * result + (expiresAt?.hashCode() ?: 0)
        result = 31 * result + (hostKeys?.hashCode() ?: 0)
        result = 31 * result + (instanceName?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (passwordData?.hashCode() ?: 0)
        result = 31 * result + (privateKey?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceAccessDetails

        if (certKey != other.certKey) return false
        if (expiresAt != other.expiresAt) return false
        if (hostKeys != other.hostKeys) return false
        if (instanceName != other.instanceName) return false
        if (ipAddress != other.ipAddress) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (password != other.password) return false
        if (passwordData != other.passwordData) return false
        if (privateKey != other.privateKey) return false
        if (protocol != other.protocol) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.InstanceAccessDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For SSH access, the public key to use when accessing your instance For OpenSSH clients (command line SSH), you should save this value to `tempkey-cert.pub`.
         */
        public var certKey: kotlin.String? = null
        /**
         * For SSH access, the date on which the temporary keys expire.
         */
        public var expiresAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the public SSH host keys or the RDP certificate.
         */
        public var hostKeys: List<HostKeyAttributes>? = null
        /**
         * The name of this Amazon Lightsail instance.
         */
        public var instanceName: kotlin.String? = null
        /**
         * The public IP address of the Amazon Lightsail instance.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * The IPv6 address of the Amazon Lightsail instance.
         */
        public var ipv6Addresses: List<String>? = null
        /**
         * For RDP access, the password for your Amazon Lightsail instance. Password will be an empty string if the password for your new instance is not ready yet. When you create an instance, it can take up to 15 minutes for the instance to be ready.
         *
         * If you create an instance using any key pair other than the default (`LightsailDefaultKeyPair`), `password` will always be an empty string.
         *
         * If you change the Administrator password on the instance, Lightsail will continue to return the original password value. When accessing the instance using RDP, you need to manually enter the Administrator password after changing it from the default.
         */
        public var password: kotlin.String? = null
        /**
         * For a Windows Server-based instance, an object with the data you can use to retrieve your password. This is only needed if `password` is empty and the instance is not new (and therefore the password is not ready yet). When you create an instance, it can take up to 15 minutes for the instance to be ready.
         */
        public var passwordData: aws.sdk.kotlin.services.lightsail.model.PasswordData? = null
        /**
         * For SSH access, the temporary private key. For OpenSSH clients (command line SSH), you should save this value to `tempkey`).
         */
        public var privateKey: kotlin.String? = null
        /**
         * The protocol for these Amazon Lightsail instance access details.
         */
        public var protocol: aws.sdk.kotlin.services.lightsail.model.InstanceAccessProtocol? = null
        /**
         * The user name to use when logging in to the Amazon Lightsail instance.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.InstanceAccessDetails) : this() {
            this.certKey = x.certKey
            this.expiresAt = x.expiresAt
            this.hostKeys = x.hostKeys
            this.instanceName = x.instanceName
            this.ipAddress = x.ipAddress
            this.ipv6Addresses = x.ipv6Addresses
            this.password = x.password
            this.passwordData = x.passwordData
            this.privateKey = x.privateKey
            this.protocol = x.protocol
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.InstanceAccessDetails = InstanceAccessDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.PasswordData] inside the given [block]
         */
        public fun passwordData(block: aws.sdk.kotlin.services.lightsail.model.PasswordData.Builder.() -> kotlin.Unit) {
            this.passwordData = aws.sdk.kotlin.services.lightsail.model.PasswordData.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
