// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an instance (a virtual private server).
 */
public class Instance private constructor(builder: Builder) {
    /**
     * An array of objects representing the add-ons enabled on the instance.
     */
    public val addOns: List<AddOn>? = builder.addOns
    /**
     * The Amazon Resource Name (ARN) of the instance (`arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE`).
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The blueprint ID (`os_amlinux_2016_03`).
     */
    public val blueprintId: kotlin.String? = builder.blueprintId
    /**
     * The friendly name of the blueprint (`Amazon Linux`).
     */
    public val blueprintName: kotlin.String? = builder.blueprintName
    /**
     * The bundle for the instance (`micro_1_0`).
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The timestamp when the instance was created (`1479734909.17`) in Unix time format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The size of the vCPU and the amount of RAM for the instance.
     */
    public val hardware: aws.sdk.kotlin.services.lightsail.model.InstanceHardware? = builder.hardware
    /**
     * The IP address type of the instance.
     *
     * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
     */
    public val ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = builder.ipAddressType
    /**
     * The IPv6 addresses of the instance.
     */
    public val ipv6Addresses: List<String>? = builder.ipv6Addresses
    /**
     * A Boolean value indicating whether this instance has a static IP assigned to it.
     */
    public val isStaticIp: kotlin.Boolean? = builder.isStaticIp
    /**
     * The region name and Availability Zone where the instance is located.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The metadata options for the Amazon Lightsail instance.
     */
    public val metadataOptions: aws.sdk.kotlin.services.lightsail.model.InstanceMetadataOptions? = builder.metadataOptions
    /**
     * The name the user gave the instance (`Amazon_Linux-1GB-Ohio-1`).
     */
    public val name: kotlin.String? = builder.name
    /**
     * Information about the public ports and monthly data transfer rates for the instance.
     */
    public val networking: aws.sdk.kotlin.services.lightsail.model.InstanceNetworking? = builder.networking
    /**
     * The private IP address of the instance.
     */
    public val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * The public IP address of the instance.
     */
    public val publicIpAddress: kotlin.String? = builder.publicIpAddress
    /**
     * The type of resource (usually `Instance`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The name of the SSH key being used to connect to the instance (`LightsailDefaultKeyPair`).
     */
    public val sshKeyName: kotlin.String? = builder.sshKeyName
    /**
     * The status code and the state (`running`) for the instance.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.InstanceState? = builder.state
    /**
     * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The user name for connecting to the instance (`ec2-user`).
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.Instance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("addOns=$addOns,")
        append("arn=$arn,")
        append("blueprintId=$blueprintId,")
        append("blueprintName=$blueprintName,")
        append("bundleId=$bundleId,")
        append("createdAt=$createdAt,")
        append("hardware=$hardware,")
        append("ipAddressType=$ipAddressType,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("isStaticIp=$isStaticIp,")
        append("location=$location,")
        append("metadataOptions=$metadataOptions,")
        append("name=$name,")
        append("networking=$networking,")
        append("privateIpAddress=$privateIpAddress,")
        append("publicIpAddress=$publicIpAddress,")
        append("resourceType=$resourceType,")
        append("sshKeyName=$sshKeyName,")
        append("state=$state,")
        append("supportCode=$supportCode,")
        append("tags=$tags,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addOns?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (blueprintId?.hashCode() ?: 0)
        result = 31 * result + (blueprintName?.hashCode() ?: 0)
        result = 31 * result + (bundleId?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (hardware?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (isStaticIp?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networking?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (publicIpAddress?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sshKeyName?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Instance

        if (addOns != other.addOns) return false
        if (arn != other.arn) return false
        if (blueprintId != other.blueprintId) return false
        if (blueprintName != other.blueprintName) return false
        if (bundleId != other.bundleId) return false
        if (createdAt != other.createdAt) return false
        if (hardware != other.hardware) return false
        if (ipAddressType != other.ipAddressType) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (isStaticIp != other.isStaticIp) return false
        if (location != other.location) return false
        if (metadataOptions != other.metadataOptions) return false
        if (name != other.name) return false
        if (networking != other.networking) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (publicIpAddress != other.publicIpAddress) return false
        if (resourceType != other.resourceType) return false
        if (sshKeyName != other.sshKeyName) return false
        if (state != other.state) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.Instance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of objects representing the add-ons enabled on the instance.
         */
        public var addOns: List<AddOn>? = null
        /**
         * The Amazon Resource Name (ARN) of the instance (`arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE`).
         */
        public var arn: kotlin.String? = null
        /**
         * The blueprint ID (`os_amlinux_2016_03`).
         */
        public var blueprintId: kotlin.String? = null
        /**
         * The friendly name of the blueprint (`Amazon Linux`).
         */
        public var blueprintName: kotlin.String? = null
        /**
         * The bundle for the instance (`micro_1_0`).
         */
        public var bundleId: kotlin.String? = null
        /**
         * The timestamp when the instance was created (`1479734909.17`) in Unix time format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The size of the vCPU and the amount of RAM for the instance.
         */
        public var hardware: aws.sdk.kotlin.services.lightsail.model.InstanceHardware? = null
        /**
         * The IP address type of the instance.
         *
         * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
         */
        public var ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = null
        /**
         * The IPv6 addresses of the instance.
         */
        public var ipv6Addresses: List<String>? = null
        /**
         * A Boolean value indicating whether this instance has a static IP assigned to it.
         */
        public var isStaticIp: kotlin.Boolean? = null
        /**
         * The region name and Availability Zone where the instance is located.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The metadata options for the Amazon Lightsail instance.
         */
        public var metadataOptions: aws.sdk.kotlin.services.lightsail.model.InstanceMetadataOptions? = null
        /**
         * The name the user gave the instance (`Amazon_Linux-1GB-Ohio-1`).
         */
        public var name: kotlin.String? = null
        /**
         * Information about the public ports and monthly data transfer rates for the instance.
         */
        public var networking: aws.sdk.kotlin.services.lightsail.model.InstanceNetworking? = null
        /**
         * The private IP address of the instance.
         */
        public var privateIpAddress: kotlin.String? = null
        /**
         * The public IP address of the instance.
         */
        public var publicIpAddress: kotlin.String? = null
        /**
         * The type of resource (usually `Instance`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The name of the SSH key being used to connect to the instance (`LightsailDefaultKeyPair`).
         */
        public var sshKeyName: kotlin.String? = null
        /**
         * The status code and the state (`running`) for the instance.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.InstanceState? = null
        /**
         * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null
        /**
         * The user name for connecting to the instance (`ec2-user`).
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.Instance) : this() {
            this.addOns = x.addOns
            this.arn = x.arn
            this.blueprintId = x.blueprintId
            this.blueprintName = x.blueprintName
            this.bundleId = x.bundleId
            this.createdAt = x.createdAt
            this.hardware = x.hardware
            this.ipAddressType = x.ipAddressType
            this.ipv6Addresses = x.ipv6Addresses
            this.isStaticIp = x.isStaticIp
            this.location = x.location
            this.metadataOptions = x.metadataOptions
            this.name = x.name
            this.networking = x.networking
            this.privateIpAddress = x.privateIpAddress
            this.publicIpAddress = x.publicIpAddress
            this.resourceType = x.resourceType
            this.sshKeyName = x.sshKeyName
            this.state = x.state
            this.supportCode = x.supportCode
            this.tags = x.tags
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.Instance = Instance(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.InstanceHardware] inside the given [block]
         */
        public fun hardware(block: aws.sdk.kotlin.services.lightsail.model.InstanceHardware.Builder.() -> kotlin.Unit) {
            this.hardware = aws.sdk.kotlin.services.lightsail.model.InstanceHardware.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.InstanceMetadataOptions] inside the given [block]
         */
        public fun metadataOptions(block: aws.sdk.kotlin.services.lightsail.model.InstanceMetadataOptions.Builder.() -> kotlin.Unit) {
            this.metadataOptions = aws.sdk.kotlin.services.lightsail.model.InstanceMetadataOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.InstanceNetworking] inside the given [block]
         */
        public fun networking(block: aws.sdk.kotlin.services.lightsail.model.InstanceNetworking.Builder.() -> kotlin.Unit) {
            this.networking = aws.sdk.kotlin.services.lightsail.model.InstanceNetworking.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.InstanceState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.lightsail.model.InstanceState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.lightsail.model.InstanceState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
