// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the origin resource of an Amazon Lightsail content delivery network (CDN) distribution.
 *
 * An origin can be a Lightsail instance, bucket, container service, or load balancer. A distribution pulls content from an origin, caches it, and serves it to viewers via a worldwide network of edge servers.
 */
public class InputOrigin private constructor(builder: Builder) {
    /**
     * The name of the origin resource.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
     */
    public val protocolPolicy: aws.sdk.kotlin.services.lightsail.model.OriginProtocolPolicyEnum? = builder.protocolPolicy
    /**
     * The AWS Region name of the origin resource.
     */
    public val regionName: aws.sdk.kotlin.services.lightsail.model.RegionName? = builder.regionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.InputOrigin = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputOrigin(")
        append("name=$name,")
        append("protocolPolicy=$protocolPolicy,")
        append("regionName=$regionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (protocolPolicy?.hashCode() ?: 0)
        result = 31 * result + (regionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputOrigin

        if (name != other.name) return false
        if (protocolPolicy != other.protocolPolicy) return false
        if (regionName != other.regionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.InputOrigin = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the origin resource.
         */
        public var name: kotlin.String? = null
        /**
         * The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
         */
        public var protocolPolicy: aws.sdk.kotlin.services.lightsail.model.OriginProtocolPolicyEnum? = null
        /**
         * The AWS Region name of the origin resource.
         */
        public var regionName: aws.sdk.kotlin.services.lightsail.model.RegionName? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.InputOrigin) : this() {
            this.name = x.name
            this.protocolPolicy = x.protocolPolicy
            this.regionName = x.regionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.InputOrigin = InputOrigin(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
