// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetRelationalDatabaseMetricDataRequest private constructor(builder: Builder) {
    /**
     * The end of the time interval from which to get metric data.
     *
     * Constraints:
     * + Specified in Coordinated Universal Time (UTC).
     * + Specified in the Unix time format.For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input `1538424000` as the end time.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The metric for which you want to return information.
     *
     * Valid relational database metric names are listed below, along with the most useful `statistics` to include in your request, and the published `unit` value. All relational database metric data is available in 1-minute (60 seconds) granularity.
     * + **`CPUUtilization`** - The percentage of CPU utilization currently in use on the database.`Statistics`: The most useful statistics are `Maximum` and `Average`.`Unit`: The published unit is `Percent`.
     * + **`DatabaseConnections`** - The number of database connections in use.`Statistics`: The most useful statistics are `Maximum` and `Sum`.`Unit`: The published unit is `Count`.
     * + **`DiskQueueDepth`** - The number of outstanding IOs (read/write requests) that are waiting to access the disk.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
     * + **`FreeStorageSpace`** - The amount of available storage space.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Bytes`.
     * + **`NetworkReceiveThroughput`** - The incoming (Receive) network traffic on the database, including both customer database traffic and AWS traffic used for monitoring and replication.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Bytes/Second`.
     * + **`NetworkTransmitThroughput`** - The outgoing (Transmit) network traffic on the database, including both customer database traffic and AWS traffic used for monitoring and replication.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Bytes/Second`.
     */
    public val metricName: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseMetricName? = builder.metricName
    /**
     * The granularity, in seconds, of the returned data points.
     *
     * All relational database metric data is available in 1-minute (60 seconds) granularity.
     */
    public val period: kotlin.Int? = builder.period
    /**
     * The name of your database from which to get metric data.
     */
    public val relationalDatabaseName: kotlin.String? = builder.relationalDatabaseName
    /**
     * The start of the time interval from which to get metric data.
     *
     * Constraints:
     * + Specified in Coordinated Universal Time (UTC).
     * + Specified in the Unix time format.For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input `1538424000` as the start time.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The statistic for the metric.
     *
     * The following statistics are available:
     * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
     * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
     * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
     * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
     * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
     */
    public val statistics: List<MetricStatistic>? = builder.statistics
    /**
     * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units with each available metric, see the `metricName` parameter.
     */
    public val unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseMetricDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRelationalDatabaseMetricDataRequest(")
        append("endTime=$endTime,")
        append("metricName=$metricName,")
        append("period=$period,")
        append("relationalDatabaseName=$relationalDatabaseName,")
        append("startTime=$startTime,")
        append("statistics=$statistics,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (relationalDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRelationalDatabaseMetricDataRequest

        if (endTime != other.endTime) return false
        if (metricName != other.metricName) return false
        if (period != other.period) return false
        if (relationalDatabaseName != other.relationalDatabaseName) return false
        if (startTime != other.startTime) return false
        if (statistics != other.statistics) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseMetricDataRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end of the time interval from which to get metric data.
         *
         * Constraints:
         * + Specified in Coordinated Universal Time (UTC).
         * + Specified in the Unix time format.For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input `1538424000` as the end time.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metric for which you want to return information.
         *
         * Valid relational database metric names are listed below, along with the most useful `statistics` to include in your request, and the published `unit` value. All relational database metric data is available in 1-minute (60 seconds) granularity.
         * + **`CPUUtilization`** - The percentage of CPU utilization currently in use on the database.`Statistics`: The most useful statistics are `Maximum` and `Average`.`Unit`: The published unit is `Percent`.
         * + **`DatabaseConnections`** - The number of database connections in use.`Statistics`: The most useful statistics are `Maximum` and `Sum`.`Unit`: The published unit is `Count`.
         * + **`DiskQueueDepth`** - The number of outstanding IOs (read/write requests) that are waiting to access the disk.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
         * + **`FreeStorageSpace`** - The amount of available storage space.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Bytes`.
         * + **`NetworkReceiveThroughput`** - The incoming (Receive) network traffic on the database, including both customer database traffic and AWS traffic used for monitoring and replication.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Bytes/Second`.
         * + **`NetworkTransmitThroughput`** - The outgoing (Transmit) network traffic on the database, including both customer database traffic and AWS traffic used for monitoring and replication.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Bytes/Second`.
         */
        public var metricName: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseMetricName? = null
        /**
         * The granularity, in seconds, of the returned data points.
         *
         * All relational database metric data is available in 1-minute (60 seconds) granularity.
         */
        public var period: kotlin.Int? = null
        /**
         * The name of your database from which to get metric data.
         */
        public var relationalDatabaseName: kotlin.String? = null
        /**
         * The start of the time interval from which to get metric data.
         *
         * Constraints:
         * + Specified in Coordinated Universal Time (UTC).
         * + Specified in the Unix time format.For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input `1538424000` as the start time.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistic for the metric.
         *
         * The following statistics are available:
         * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
         * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
         * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
         * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
         * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
         */
        public var statistics: List<MetricStatistic>? = null
        /**
         * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units with each available metric, see the `metricName` parameter.
         */
        public var unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseMetricDataRequest) : this() {
            this.endTime = x.endTime
            this.metricName = x.metricName
            this.period = x.period
            this.relationalDatabaseName = x.relationalDatabaseName
            this.startTime = x.startTime
            this.statistics = x.statistics
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseMetricDataRequest = GetRelationalDatabaseMetricDataRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
