// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetBucketMetricDataRequest private constructor(builder: Builder) {
    /**
     * The name of the bucket for which to get metric data.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The timestamp indicating the latest data to be returned.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The metric for which you want to return information.
     *
     * Valid bucket metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.
     *
     * These bucket metrics are reported once per day.
     *
     * + **`BucketSizeBytes`** - The amount of data in bytes stored in a bucket. This value is calculated by summing the size of all objects in the bucket (including object versions), including the size of all parts for all incomplete multipart uploads to the bucket.Statistics: The most useful statistic is `Maximum`.Unit: The published unit is `Bytes`.
     * + **`NumberOfObjects`** - The total number of objects stored in a bucket. This value is calculated by counting all objects in the bucket (including object versions) and the total number of parts for all incomplete multipart uploads to the bucket.Statistics: The most useful statistic is `Average`.Unit: The published unit is `Count`.
     */
    public val metricName: aws.sdk.kotlin.services.lightsail.model.BucketMetricName? = builder.metricName
    /**
     * The granularity, in seconds, of the returned data points.
     *
     * Bucket storage metrics are reported once per day. Therefore, you should specify a period of 86400 seconds, which is the number of seconds in a day.
     */
    public val period: kotlin.Int? = builder.period
    /**
     * The timestamp indicating the earliest data to be returned.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The statistic for the metric.
     *
     * The following statistics are available:
     * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
     * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
     * + `Sum` - The sum of all values submitted for the matching metric. You can use this statistic to determine the total volume of a metric.
     * + `Average` - The value of `Sum` / `SampleCount` during the specified period. By comparing this statistic with the `Minimum` and `Maximum` values, you can determine the full scope of a metric and how close the average use is to the `Minimum` and `Maximum` values. This comparison helps you to know when to increase or decrease your resources.
     * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
     */
    public val statistics: List<MetricStatistic>? = builder.statistics
    /**
     * The unit for the metric data request.
     *
     * Valid units depend on the metric data being requested. For the valid units with each available metric, see the `metricName` parameter.
     */
    public val unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.GetBucketMetricDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBucketMetricDataRequest(")
        append("bucketName=$bucketName,")
        append("endTime=$endTime,")
        append("metricName=$metricName,")
        append("period=$period,")
        append("startTime=$startTime,")
        append("statistics=$statistics,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBucketMetricDataRequest

        if (bucketName != other.bucketName) return false
        if (endTime != other.endTime) return false
        if (metricName != other.metricName) return false
        if (period != other.period) return false
        if (startTime != other.startTime) return false
        if (statistics != other.statistics) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.GetBucketMetricDataRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the bucket for which to get metric data.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The timestamp indicating the latest data to be returned.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metric for which you want to return information.
         *
         * Valid bucket metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.
         *
         * These bucket metrics are reported once per day.
         *
         * + **`BucketSizeBytes`** - The amount of data in bytes stored in a bucket. This value is calculated by summing the size of all objects in the bucket (including object versions), including the size of all parts for all incomplete multipart uploads to the bucket.Statistics: The most useful statistic is `Maximum`.Unit: The published unit is `Bytes`.
         * + **`NumberOfObjects`** - The total number of objects stored in a bucket. This value is calculated by counting all objects in the bucket (including object versions) and the total number of parts for all incomplete multipart uploads to the bucket.Statistics: The most useful statistic is `Average`.Unit: The published unit is `Count`.
         */
        public var metricName: aws.sdk.kotlin.services.lightsail.model.BucketMetricName? = null
        /**
         * The granularity, in seconds, of the returned data points.
         *
         * Bucket storage metrics are reported once per day. Therefore, you should specify a period of 86400 seconds, which is the number of seconds in a day.
         */
        public var period: kotlin.Int? = null
        /**
         * The timestamp indicating the earliest data to be returned.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistic for the metric.
         *
         * The following statistics are available:
         * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
         * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
         * + `Sum` - The sum of all values submitted for the matching metric. You can use this statistic to determine the total volume of a metric.
         * + `Average` - The value of `Sum` / `SampleCount` during the specified period. By comparing this statistic with the `Minimum` and `Maximum` values, you can determine the full scope of a metric and how close the average use is to the `Minimum` and `Maximum` values. This comparison helps you to know when to increase or decrease your resources.
         * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
         */
        public var statistics: List<MetricStatistic>? = null
        /**
         * The unit for the metric data request.
         *
         * Valid units depend on the metric data being requested. For the valid units with each available metric, see the `metricName` parameter.
         */
        public var unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.GetBucketMetricDataRequest) : this() {
            this.bucketName = x.bucketName
            this.endTime = x.endTime
            this.metricName = x.metricName
            this.period = x.period
            this.startTime = x.startTime
            this.statistics = x.statistics
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.GetBucketMetricDataRequest = GetBucketMetricDataRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
