// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the settings of a public endpoint for an Amazon Lightsail container service.
 */
public class EndpointRequest private constructor(builder: Builder) {
    /**
     * The name of the container for the endpoint.
     */
    public val containerName: kotlin.String = requireNotNull(builder.containerName) { "A non-null value must be provided for containerName" }
    /**
     * The port of the container to which traffic is forwarded to.
     */
    public val containerPort: kotlin.Int = requireNotNull(builder.containerPort) { "A non-null value must be provided for containerPort" }
    /**
     * An object that describes the health check configuration of the container.
     */
    public val healthCheck: aws.sdk.kotlin.services.lightsail.model.ContainerServiceHealthCheckConfig? = builder.healthCheck

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.EndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointRequest(")
        append("containerName=$containerName,")
        append("containerPort=$containerPort,")
        append("healthCheck=$healthCheck")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerName.hashCode()
        result = 31 * result + (containerPort)
        result = 31 * result + (healthCheck?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointRequest

        if (containerName != other.containerName) return false
        if (containerPort != other.containerPort) return false
        if (healthCheck != other.healthCheck) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.EndpointRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the container for the endpoint.
         */
        public var containerName: kotlin.String? = null
        /**
         * The port of the container to which traffic is forwarded to.
         */
        public var containerPort: kotlin.Int? = null
        /**
         * An object that describes the health check configuration of the container.
         */
        public var healthCheck: aws.sdk.kotlin.services.lightsail.model.ContainerServiceHealthCheckConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.EndpointRequest) : this() {
            this.containerName = x.containerName
            this.containerPort = x.containerPort
            this.healthCheck = x.healthCheck
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.EndpointRequest = EndpointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ContainerServiceHealthCheckConfig] inside the given [block]
         */
        public fun healthCheck(block: aws.sdk.kotlin.services.lightsail.model.ContainerServiceHealthCheckConfig.Builder.() -> kotlin.Unit) {
            this.healthCheck = aws.sdk.kotlin.services.lightsail.model.ContainerServiceHealthCheckConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (containerName == null) containerName = ""
            if (containerPort == null) containerPort = 0
            return this
        }
    }
}
