// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the domain name system (DNS) records that you must add to the DNS of your registered domain to validate ownership for an Amazon Lightsail SSL/TLS certificate.
 */
public class DomainValidationRecord private constructor(builder: Builder) {
    /**
     * An object that describes the state of the canonical name (CNAME) records that are automatically added by Lightsail to the DNS of the domain to validate domain ownership.
     */
    public val dnsRecordCreationState: aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationState? = builder.dnsRecordCreationState
    /**
     * The domain name of the certificate validation record. For example, `example.com` or `www.example.com`.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
     */
    public val resourceRecord: aws.sdk.kotlin.services.lightsail.model.ResourceRecord? = builder.resourceRecord
    /**
     * The validation status of the record.
     */
    public val validationStatus: aws.sdk.kotlin.services.lightsail.model.CertificateDomainValidationStatus? = builder.validationStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.DomainValidationRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainValidationRecord(")
        append("dnsRecordCreationState=$dnsRecordCreationState,")
        append("domainName=$domainName,")
        append("resourceRecord=$resourceRecord,")
        append("validationStatus=$validationStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsRecordCreationState?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (resourceRecord?.hashCode() ?: 0)
        result = 31 * result + (validationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainValidationRecord

        if (dnsRecordCreationState != other.dnsRecordCreationState) return false
        if (domainName != other.domainName) return false
        if (resourceRecord != other.resourceRecord) return false
        if (validationStatus != other.validationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.DomainValidationRecord = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that describes the state of the canonical name (CNAME) records that are automatically added by Lightsail to the DNS of the domain to validate domain ownership.
         */
        public var dnsRecordCreationState: aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationState? = null
        /**
         * The domain name of the certificate validation record. For example, `example.com` or `www.example.com`.
         */
        public var domainName: kotlin.String? = null
        /**
         * An object that describes the DNS records to add to your domain's DNS to validate it for the certificate.
         */
        public var resourceRecord: aws.sdk.kotlin.services.lightsail.model.ResourceRecord? = null
        /**
         * The validation status of the record.
         */
        public var validationStatus: aws.sdk.kotlin.services.lightsail.model.CertificateDomainValidationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.DomainValidationRecord) : this() {
            this.dnsRecordCreationState = x.dnsRecordCreationState
            this.domainName = x.domainName
            this.resourceRecord = x.resourceRecord
            this.validationStatus = x.validationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.DomainValidationRecord = DomainValidationRecord(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationState] inside the given [block]
         */
        public fun dnsRecordCreationState(block: aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationState.Builder.() -> kotlin.Unit) {
            this.dnsRecordCreationState = aws.sdk.kotlin.services.lightsail.model.DnsRecordCreationState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceRecord] inside the given [block]
         */
        public fun resourceRecord(block: aws.sdk.kotlin.services.lightsail.model.ResourceRecord.Builder.() -> kotlin.Unit) {
            this.resourceRecord = aws.sdk.kotlin.services.lightsail.model.ResourceRecord.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
