// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a domain where you are storing recordsets.
 */
public class Domain private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the domain recordset (`arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE`).
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date when the domain recordset was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An array of key-value pairs containing information about the domain entries.
     */
    public val domainEntries: List<DomainEntry>? = builder.domainEntries
    /**
     * The AWS Region and Availability Zones where the domain recordset was created.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the domain.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An object that describes the state of the Route 53 domain delegation to a Lightsail DNS zone.
     */
    public val registeredDomainDelegationInfo: aws.sdk.kotlin.services.lightsail.model.RegisteredDomainDelegationInfo? = builder.registeredDomainDelegationInfo
    /**
     * The resource type.
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.Domain = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Domain(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("domainEntries=$domainEntries,")
        append("location=$location,")
        append("name=$name,")
        append("registeredDomainDelegationInfo=$registeredDomainDelegationInfo,")
        append("resourceType=$resourceType,")
        append("supportCode=$supportCode,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (domainEntries?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (registeredDomainDelegationInfo?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Domain

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (domainEntries != other.domainEntries) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (registeredDomainDelegationInfo != other.registeredDomainDelegationInfo) return false
        if (resourceType != other.resourceType) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.Domain = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the domain recordset (`arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE`).
         */
        public var arn: kotlin.String? = null
        /**
         * The date when the domain recordset was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of key-value pairs containing information about the domain entries.
         */
        public var domainEntries: List<DomainEntry>? = null
        /**
         * The AWS Region and Availability Zones where the domain recordset was created.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the domain.
         */
        public var name: kotlin.String? = null
        /**
         * An object that describes the state of the Route 53 domain delegation to a Lightsail DNS zone.
         */
        public var registeredDomainDelegationInfo: aws.sdk.kotlin.services.lightsail.model.RegisteredDomainDelegationInfo? = null
        /**
         * The resource type.
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.Domain) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.domainEntries = x.domainEntries
            this.location = x.location
            this.name = x.name
            this.registeredDomainDelegationInfo = x.registeredDomainDelegationInfo
            this.resourceType = x.resourceType
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.Domain = Domain(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.RegisteredDomainDelegationInfo] inside the given [block]
         */
        public fun registeredDomainDelegationInfo(block: aws.sdk.kotlin.services.lightsail.model.RegisteredDomainDelegationInfo.Builder.() -> kotlin.Unit) {
            this.registeredDomainDelegationInfo = aws.sdk.kotlin.services.lightsail.model.RegisteredDomainDelegationInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
