// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a block storage disk.
 */
public class Disk private constructor(builder: Builder) {
    /**
     * An array of objects representing the add-ons enabled on the disk.
     */
    public val addOns: List<AddOn>? = builder.addOns
    /**
     * The Amazon Resource Name (ARN) of the disk.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The resources to which the disk is attached.
     */
    public val attachedTo: kotlin.String? = builder.attachedTo
    /**
     * (Discontinued) The attachment state of the disk.
     *
     * In releases prior to November 14, 2017, this parameter returned `attached` for system disks in the API response. It is now discontinued, but still included in the response. Use `isAttached` instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val attachmentState: kotlin.String? = builder.attachmentState
    /**
     * The status of automatically mounting a storage disk to a virtual computer.
     *
     * This parameter only applies to Lightsail for Research resources.
     */
    public val autoMountStatus: aws.sdk.kotlin.services.lightsail.model.AutoMountStatus? = builder.autoMountStatus
    /**
     * The date when the disk was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * (Discontinued) The number of GB in use by the disk.
     *
     * In releases prior to November 14, 2017, this parameter was not included in the API response. It is now discontinued.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val gbInUse: kotlin.Int? = builder.gbInUse
    /**
     * The input/output operations per second (IOPS) of the disk.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * A Boolean value indicating whether the disk is attached.
     */
    public val isAttached: kotlin.Boolean? = builder.isAttached
    /**
     * A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
     */
    public val isSystemDisk: kotlin.Boolean? = builder.isSystemDisk
    /**
     * The AWS Region and Availability Zone where the disk is located.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The unique name of the disk.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The disk path.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The Lightsail resource type (`Disk`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The size of the disk in GB.
     */
    public val sizeInGb: kotlin.Int? = builder.sizeInGb
    /**
     * Describes the status of the disk.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.DiskState? = builder.state
    /**
     * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.Disk = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Disk(")
        append("addOns=$addOns,")
        append("arn=$arn,")
        append("attachedTo=$attachedTo,")
        append("attachmentState=$attachmentState,")
        append("autoMountStatus=$autoMountStatus,")
        append("createdAt=$createdAt,")
        append("gbInUse=$gbInUse,")
        append("iops=$iops,")
        append("isAttached=$isAttached,")
        append("isSystemDisk=$isSystemDisk,")
        append("location=$location,")
        append("name=$name,")
        append("path=$path,")
        append("resourceType=$resourceType,")
        append("sizeInGb=$sizeInGb,")
        append("state=$state,")
        append("supportCode=$supportCode,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addOns?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (attachedTo?.hashCode() ?: 0)
        result = 31 * result + (attachmentState?.hashCode() ?: 0)
        result = 31 * result + (autoMountStatus?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (gbInUse ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (isAttached?.hashCode() ?: 0)
        result = 31 * result + (isSystemDisk?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sizeInGb ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Disk

        if (addOns != other.addOns) return false
        if (arn != other.arn) return false
        if (attachedTo != other.attachedTo) return false
        if (attachmentState != other.attachmentState) return false
        if (autoMountStatus != other.autoMountStatus) return false
        if (createdAt != other.createdAt) return false
        if (gbInUse != other.gbInUse) return false
        if (iops != other.iops) return false
        if (isAttached != other.isAttached) return false
        if (isSystemDisk != other.isSystemDisk) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (path != other.path) return false
        if (resourceType != other.resourceType) return false
        if (sizeInGb != other.sizeInGb) return false
        if (state != other.state) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.Disk = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of objects representing the add-ons enabled on the disk.
         */
        public var addOns: List<AddOn>? = null
        /**
         * The Amazon Resource Name (ARN) of the disk.
         */
        public var arn: kotlin.String? = null
        /**
         * The resources to which the disk is attached.
         */
        public var attachedTo: kotlin.String? = null
        /**
         * (Discontinued) The attachment state of the disk.
         *
         * In releases prior to November 14, 2017, this parameter returned `attached` for system disks in the API response. It is now discontinued, but still included in the response. Use `isAttached` instead.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var attachmentState: kotlin.String? = null
        /**
         * The status of automatically mounting a storage disk to a virtual computer.
         *
         * This parameter only applies to Lightsail for Research resources.
         */
        public var autoMountStatus: aws.sdk.kotlin.services.lightsail.model.AutoMountStatus? = null
        /**
         * The date when the disk was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * (Discontinued) The number of GB in use by the disk.
         *
         * In releases prior to November 14, 2017, this parameter was not included in the API response. It is now discontinued.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var gbInUse: kotlin.Int? = null
        /**
         * The input/output operations per second (IOPS) of the disk.
         */
        public var iops: kotlin.Int? = null
        /**
         * A Boolean value indicating whether the disk is attached.
         */
        public var isAttached: kotlin.Boolean? = null
        /**
         * A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
         */
        public var isSystemDisk: kotlin.Boolean? = null
        /**
         * The AWS Region and Availability Zone where the disk is located.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The unique name of the disk.
         */
        public var name: kotlin.String? = null
        /**
         * The disk path.
         */
        public var path: kotlin.String? = null
        /**
         * The Lightsail resource type (`Disk`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The size of the disk in GB.
         */
        public var sizeInGb: kotlin.Int? = null
        /**
         * Describes the status of the disk.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.DiskState? = null
        /**
         * The support code. Include this code in your email to support when you have questions about an instance or another resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.Disk) : this() {
            this.addOns = x.addOns
            this.arn = x.arn
            this.attachedTo = x.attachedTo
            this.attachmentState = x.attachmentState
            this.autoMountStatus = x.autoMountStatus
            this.createdAt = x.createdAt
            this.gbInUse = x.gbInUse
            this.iops = x.iops
            this.isAttached = x.isAttached
            this.isSystemDisk = x.isSystemDisk
            this.location = x.location
            this.name = x.name
            this.path = x.path
            this.resourceType = x.resourceType
            this.sizeInGb = x.sizeInGb
            this.state = x.state
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.Disk = Disk(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
