// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class DeleteBucketRequest private constructor(builder: Builder) {
    /**
     * The name of the bucket to delete.
     *
     * Use the [GetBuckets](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html) action to get a list of bucket names that you can specify.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * A Boolean value that indicates whether to force delete the bucket.
     *
     * You must force delete the bucket if it has one of the following conditions:
     * + The bucket is the origin of a distribution.
     * + The bucket has instances that were granted access to it using the [SetResourceAccessForBucket](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html) action.
     * + The bucket has objects.
     * + The bucket has access keys.
     *
     * Force deleting a bucket might impact other resources that rely on the bucket, such as instances, distributions, or software that use the issued access keys.
     */
    public val forceDelete: kotlin.Boolean? = builder.forceDelete

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.DeleteBucketRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteBucketRequest(")
        append("bucketName=$bucketName,")
        append("forceDelete=$forceDelete")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (forceDelete?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteBucketRequest

        if (bucketName != other.bucketName) return false
        if (forceDelete != other.forceDelete) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.DeleteBucketRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the bucket to delete.
         *
         * Use the [GetBuckets](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html) action to get a list of bucket names that you can specify.
         */
        public var bucketName: kotlin.String? = null
        /**
         * A Boolean value that indicates whether to force delete the bucket.
         *
         * You must force delete the bucket if it has one of the following conditions:
         * + The bucket is the origin of a distribution.
         * + The bucket has instances that were granted access to it using the [SetResourceAccessForBucket](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html) action.
         * + The bucket has objects.
         * + The bucket has access keys.
         *
         * Force deleting a bucket might impact other resources that rely on the bucket, such as instances, distributions, or software that use the issued access keys.
         */
        public var forceDelete: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.DeleteBucketRequest) : this() {
            this.bucketName = x.bucketName
            this.forceDelete = x.forceDelete
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.DeleteBucketRequest = DeleteBucketRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
