// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class CreateInstancesRequest private constructor(builder: Builder) {
    /**
     * An array of objects representing the add-ons to enable for the new instance.
     */
    public val addOns: List<AddOnRequest>? = builder.addOns
    /**
     * The Availability Zone in which to create your instance. Use the following format: `us-east-2a` (case sensitive). You can get a list of Availability Zones by using the [get regions](http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html) operation. Be sure to add the `include Availability Zones` parameter to your request.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The ID for a virtual private server image (`app_wordpress_4_4` or `app_lamp_7_0`). Use the `get blueprints` operation to return a list of available images (or *blueprints*).
     *
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.
     */
    public val blueprintId: kotlin.String? = builder.blueprintId
    /**
     * The bundle of specification information for your virtual private server (or *instance*), including the pricing plan (`micro_1_0`).
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * (Discontinued) The name for your custom image.
     *
     * In releases prior to June 12, 2017, this parameter was ignored by the API. It is now discontinued.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val customImageName: kotlin.String? = builder.customImageName
    /**
     * The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas, for example: `["MyFirstInstance","MySecondInstance"]`
     */
    public val instanceNames: List<String>? = builder.instanceNames
    /**
     * The IP address type for the instance.
     *
     * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
     *
     * The default value is `dualstack`.
     */
    public val ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = builder.ipAddressType
    /**
     * The name of your key pair.
     */
    public val keyPairName: kotlin.String? = builder.keyPairName
    /**
     * The tag keys and optional values to add to the resource during create.
     *
     * Use the `TagResource` action to tag a resource after it's created.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A launch script you can create that configures a server with additional user data. For example, you might want to run `apt-get -y update`.
     *
     * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use `yum`, Debian and Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image).
     */
    public val userData: kotlin.String? = builder.userData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateInstancesRequest(")
        append("addOns=$addOns,")
        append("availabilityZone=$availabilityZone,")
        append("blueprintId=$blueprintId,")
        append("bundleId=$bundleId,")
        append("customImageName=$customImageName,")
        append("instanceNames=$instanceNames,")
        append("ipAddressType=$ipAddressType,")
        append("keyPairName=$keyPairName,")
        append("tags=$tags,")
        append("userData=$userData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addOns?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (blueprintId?.hashCode() ?: 0)
        result = 31 * result + (bundleId?.hashCode() ?: 0)
        result = 31 * result + (customImageName?.hashCode() ?: 0)
        result = 31 * result + (instanceNames?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (keyPairName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateInstancesRequest

        if (addOns != other.addOns) return false
        if (availabilityZone != other.availabilityZone) return false
        if (blueprintId != other.blueprintId) return false
        if (bundleId != other.bundleId) return false
        if (customImageName != other.customImageName) return false
        if (instanceNames != other.instanceNames) return false
        if (ipAddressType != other.ipAddressType) return false
        if (keyPairName != other.keyPairName) return false
        if (tags != other.tags) return false
        if (userData != other.userData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateInstancesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of objects representing the add-ons to enable for the new instance.
         */
        public var addOns: List<AddOnRequest>? = null
        /**
         * The Availability Zone in which to create your instance. Use the following format: `us-east-2a` (case sensitive). You can get a list of Availability Zones by using the [get regions](http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html) operation. Be sure to add the `include Availability Zones` parameter to your request.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The ID for a virtual private server image (`app_wordpress_4_4` or `app_lamp_7_0`). Use the `get blueprints` operation to return a list of available images (or *blueprints*).
         *
         * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.
         */
        public var blueprintId: kotlin.String? = null
        /**
         * The bundle of specification information for your virtual private server (or *instance*), including the pricing plan (`micro_1_0`).
         */
        public var bundleId: kotlin.String? = null
        /**
         * (Discontinued) The name for your custom image.
         *
         * In releases prior to June 12, 2017, this parameter was ignored by the API. It is now discontinued.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var customImageName: kotlin.String? = null
        /**
         * The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas, for example: `["MyFirstInstance","MySecondInstance"]`
         */
        public var instanceNames: List<String>? = null
        /**
         * The IP address type for the instance.
         *
         * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
         *
         * The default value is `dualstack`.
         */
        public var ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = null
        /**
         * The name of your key pair.
         */
        public var keyPairName: kotlin.String? = null
        /**
         * The tag keys and optional values to add to the resource during create.
         *
         * Use the `TagResource` action to tag a resource after it's created.
         */
        public var tags: List<Tag>? = null
        /**
         * A launch script you can create that configures a server with additional user data. For example, you might want to run `apt-get -y update`.
         *
         * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use `yum`, Debian and Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image).
         */
        public var userData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateInstancesRequest) : this() {
            this.addOns = x.addOns
            this.availabilityZone = x.availabilityZone
            this.blueprintId = x.blueprintId
            this.bundleId = x.bundleId
            this.customImageName = x.customImageName
            this.instanceNames = x.instanceNames
            this.ipAddressType = x.ipAddressType
            this.keyPairName = x.keyPairName
            this.tags = x.tags
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateInstancesRequest = CreateInstancesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
