// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class CreateDistributionRequest private constructor(builder: Builder) {
    /**
     * The bundle ID to use for the distribution.
     *
     * A distribution bundle describes the specifications of your distribution, such as the monthly cost and monthly network transfer quota.
     *
     * Use the `GetDistributionBundles` action to get a list of distribution bundle IDs that you can specify.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * An object that describes the cache behavior settings for the distribution.
     */
    public val cacheBehaviorSettings: aws.sdk.kotlin.services.lightsail.model.CacheSettings? = builder.cacheBehaviorSettings
    /**
     * An array of objects that describe the per-path cache behavior for the distribution.
     */
    public val cacheBehaviors: List<CacheBehaviorPerPath>? = builder.cacheBehaviors
    /**
     * An object that describes the default cache behavior for the distribution.
     */
    public val defaultCacheBehavior: aws.sdk.kotlin.services.lightsail.model.CacheBehavior? = builder.defaultCacheBehavior
    /**
     * The name for the distribution.
     */
    public val distributionName: kotlin.String? = builder.distributionName
    /**
     * The IP address type for the distribution.
     *
     * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
     *
     * The default value is `dualstack`.
     */
    public val ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = builder.ipAddressType
    /**
     * An object that describes the origin resource for the distribution, such as a Lightsail instance, bucket, or load balancer.
     *
     * The distribution pulls, caches, and serves content from the origin.
     */
    public val origin: aws.sdk.kotlin.services.lightsail.model.InputOrigin? = builder.origin
    /**
     * The tag keys and optional values to add to the distribution during create.
     *
     * Use the `TagResource` action to tag a resource after it's created.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateDistributionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDistributionRequest(")
        append("bundleId=$bundleId,")
        append("cacheBehaviorSettings=$cacheBehaviorSettings,")
        append("cacheBehaviors=$cacheBehaviors,")
        append("defaultCacheBehavior=$defaultCacheBehavior,")
        append("distributionName=$distributionName,")
        append("ipAddressType=$ipAddressType,")
        append("origin=$origin,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bundleId?.hashCode() ?: 0
        result = 31 * result + (cacheBehaviorSettings?.hashCode() ?: 0)
        result = 31 * result + (cacheBehaviors?.hashCode() ?: 0)
        result = 31 * result + (defaultCacheBehavior?.hashCode() ?: 0)
        result = 31 * result + (distributionName?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDistributionRequest

        if (bundleId != other.bundleId) return false
        if (cacheBehaviorSettings != other.cacheBehaviorSettings) return false
        if (cacheBehaviors != other.cacheBehaviors) return false
        if (defaultCacheBehavior != other.defaultCacheBehavior) return false
        if (distributionName != other.distributionName) return false
        if (ipAddressType != other.ipAddressType) return false
        if (origin != other.origin) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateDistributionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The bundle ID to use for the distribution.
         *
         * A distribution bundle describes the specifications of your distribution, such as the monthly cost and monthly network transfer quota.
         *
         * Use the `GetDistributionBundles` action to get a list of distribution bundle IDs that you can specify.
         */
        public var bundleId: kotlin.String? = null
        /**
         * An object that describes the cache behavior settings for the distribution.
         */
        public var cacheBehaviorSettings: aws.sdk.kotlin.services.lightsail.model.CacheSettings? = null
        /**
         * An array of objects that describe the per-path cache behavior for the distribution.
         */
        public var cacheBehaviors: List<CacheBehaviorPerPath>? = null
        /**
         * An object that describes the default cache behavior for the distribution.
         */
        public var defaultCacheBehavior: aws.sdk.kotlin.services.lightsail.model.CacheBehavior? = null
        /**
         * The name for the distribution.
         */
        public var distributionName: kotlin.String? = null
        /**
         * The IP address type for the distribution.
         *
         * The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4 and IPv6.
         *
         * The default value is `dualstack`.
         */
        public var ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = null
        /**
         * An object that describes the origin resource for the distribution, such as a Lightsail instance, bucket, or load balancer.
         *
         * The distribution pulls, caches, and serves content from the origin.
         */
        public var origin: aws.sdk.kotlin.services.lightsail.model.InputOrigin? = null
        /**
         * The tag keys and optional values to add to the distribution during create.
         *
         * Use the `TagResource` action to tag a resource after it's created.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateDistributionRequest) : this() {
            this.bundleId = x.bundleId
            this.cacheBehaviorSettings = x.cacheBehaviorSettings
            this.cacheBehaviors = x.cacheBehaviors
            this.defaultCacheBehavior = x.defaultCacheBehavior
            this.distributionName = x.distributionName
            this.ipAddressType = x.ipAddressType
            this.origin = x.origin
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateDistributionRequest = CreateDistributionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.CacheSettings] inside the given [block]
         */
        public fun cacheBehaviorSettings(block: aws.sdk.kotlin.services.lightsail.model.CacheSettings.Builder.() -> kotlin.Unit) {
            this.cacheBehaviorSettings = aws.sdk.kotlin.services.lightsail.model.CacheSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.CacheBehavior] inside the given [block]
         */
        public fun defaultCacheBehavior(block: aws.sdk.kotlin.services.lightsail.model.CacheBehavior.Builder.() -> kotlin.Unit) {
            this.defaultCacheBehavior = aws.sdk.kotlin.services.lightsail.model.CacheBehavior.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.InputOrigin] inside the given [block]
         */
        public fun origin(block: aws.sdk.kotlin.services.lightsail.model.InputOrigin.Builder.() -> kotlin.Unit) {
            this.origin = aws.sdk.kotlin.services.lightsail.model.InputOrigin.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
