// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the current state of a container service.
 */
public class ContainerServiceStateDetail private constructor(builder: Builder) {
    /**
     * The state code of the container service.
     *
     * The following state codes are possible:
     * + The following state codes are possible if your container service is in a `DEPLOYING` or `UPDATING` state:
     *    + `CREATING_SYSTEM_RESOURCES` - The system resources for your container service are being created.
     *    + `CREATING_NETWORK_INFRASTRUCTURE` - The network infrastructure for your container service are being created.
     *    + `PROVISIONING_CERTIFICATE` - The SSL/TLS certificate for your container service is being created.
     *    + `PROVISIONING_SERVICE` - Your container service is being provisioned.
     *    + `CREATING_DEPLOYMENT` - Your deployment is being created on your container service.
     *    + `EVALUATING_HEALTH_CHECK` - The health of your deployment is being evaluated.
     *    + `ACTIVATING_DEPLOYMENT` - Your deployment is being activated.
     * + The following state codes are possible if your container service is in a `PENDING` state:
     *    + `CERTIFICATE_LIMIT_EXCEEDED` - The SSL/TLS certificate required for your container service exceeds the maximum number of certificates allowed for your account.
     *    + `UNKNOWN_ERROR` - An error was experienced when your container service was being created.
     */
    public val code: aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetailCode? = builder.code
    /**
     * A message that provides more information for the state code.
     *
     * The state detail is populated only when a container service is in a `PENDING`, `DEPLOYING`, or `UPDATING` state.
     */
    public val message: kotlin.String? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerServiceStateDetail(")
        append("code=$code,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerServiceStateDetail

        if (code != other.code) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The state code of the container service.
         *
         * The following state codes are possible:
         * + The following state codes are possible if your container service is in a `DEPLOYING` or `UPDATING` state:
         *    + `CREATING_SYSTEM_RESOURCES` - The system resources for your container service are being created.
         *    + `CREATING_NETWORK_INFRASTRUCTURE` - The network infrastructure for your container service are being created.
         *    + `PROVISIONING_CERTIFICATE` - The SSL/TLS certificate for your container service is being created.
         *    + `PROVISIONING_SERVICE` - Your container service is being provisioned.
         *    + `CREATING_DEPLOYMENT` - Your deployment is being created on your container service.
         *    + `EVALUATING_HEALTH_CHECK` - The health of your deployment is being evaluated.
         *    + `ACTIVATING_DEPLOYMENT` - Your deployment is being activated.
         * + The following state codes are possible if your container service is in a `PENDING` state:
         *    + `CERTIFICATE_LIMIT_EXCEEDED` - The SSL/TLS certificate required for your container service exceeds the maximum number of certificates allowed for your account.
         *    + `UNKNOWN_ERROR` - An error was experienced when your container service was being created.
         */
        public var code: aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetailCode? = null
        /**
         * A message that provides more information for the state code.
         *
         * The state detail is populated only when a container service is in a `PENDING`, `DEPLOYING`, or `UPDATING` state.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetail) : this() {
            this.code = x.code
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ContainerServiceStateDetail = ContainerServiceStateDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
