// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the powers that can be specified for an Amazon Lightsail container service.
 *
 * The power specifies the amount of RAM, the number of vCPUs, and the base price of the container service.
 */
public class ContainerServicePower private constructor(builder: Builder) {
    /**
     * The number of vCPUs included in the power.
     */
    public val cpuCount: kotlin.Float? = builder.cpuCount
    /**
     * A Boolean value indicating whether the power is active and can be specified for container services.
     */
    public val isActive: kotlin.Boolean? = builder.isActive
    /**
     * The friendly name of the power (`nano`).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the power (`nano-1`).
     */
    public val powerId: kotlin.String? = builder.powerId
    /**
     * The monthly price of the power in USD.
     */
    public val price: kotlin.Float? = builder.price
    /**
     * The amount of RAM (in GB) of the power.
     */
    public val ramSizeInGb: kotlin.Float? = builder.ramSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ContainerServicePower = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerServicePower(")
        append("cpuCount=$cpuCount,")
        append("isActive=$isActive,")
        append("name=$name,")
        append("powerId=$powerId,")
        append("price=$price,")
        append("ramSizeInGb=$ramSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpuCount?.hashCode() ?: 0
        result = 31 * result + (isActive?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (powerId?.hashCode() ?: 0)
        result = 31 * result + (price?.hashCode() ?: 0)
        result = 31 * result + (ramSizeInGb?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerServicePower

        if (cpuCount != other.cpuCount) return false
        if (isActive != other.isActive) return false
        if (name != other.name) return false
        if (powerId != other.powerId) return false
        if (price != other.price) return false
        if (ramSizeInGb != other.ramSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ContainerServicePower = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of vCPUs included in the power.
         */
        public var cpuCount: kotlin.Float? = null
        /**
         * A Boolean value indicating whether the power is active and can be specified for container services.
         */
        public var isActive: kotlin.Boolean? = null
        /**
         * The friendly name of the power (`nano`).
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the power (`nano-1`).
         */
        public var powerId: kotlin.String? = null
        /**
         * The monthly price of the power in USD.
         */
        public var price: kotlin.Float? = null
        /**
         * The amount of RAM (in GB) of the power.
         */
        public var ramSizeInGb: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ContainerServicePower) : this() {
            this.cpuCount = x.cpuCount
            this.isActive = x.isActive
            this.name = x.name
            this.powerId = x.powerId
            this.price = x.price
            this.ramSizeInGb = x.ramSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ContainerServicePower = ContainerServicePower(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
