// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the settings of a container that will be launched, or that is launched, to an Amazon Lightsail container service.
 */
public class Container private constructor(builder: Builder) {
    /**
     * The launch command for the container.
     */
    public val command: List<String>? = builder.command
    /**
     * The environment variables of the container.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * The name of the image used for the container.
     *
     * Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, if your container service name is `container-service-1`, the container image label is `mystaticsite`, and you want to use the third (`3`) version of the registered container image, then you should specify `:container-service-1.mystaticsite.3`. To use the latest version of a container image, specify `latest` instead of a version number (for example, `:container-service-1.mystaticsite.latest`). Lightsail will automatically use the highest numbered version of the registered container image.
     *
     * Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
     */
    public val image: kotlin.String? = builder.image
    /**
     * The open firewall ports of the container.
     */
    public val ports: Map<String, ContainerServiceProtocol>? = builder.ports

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.Container = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Container(")
        append("command=$command,")
        append("environment=$environment,")
        append("image=$image,")
        append("ports=$ports")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = command?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (ports?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Container

        if (command != other.command) return false
        if (environment != other.environment) return false
        if (image != other.image) return false
        if (ports != other.ports) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.Container = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The launch command for the container.
         */
        public var command: List<String>? = null
        /**
         * The environment variables of the container.
         */
        public var environment: Map<String, String>? = null
        /**
         * The name of the image used for the container.
         *
         * Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, if your container service name is `container-service-1`, the container image label is `mystaticsite`, and you want to use the third (`3`) version of the registered container image, then you should specify `:container-service-1.mystaticsite.3`. To use the latest version of a container image, specify `latest` instead of a version number (for example, `:container-service-1.mystaticsite.latest`). Lightsail will automatically use the highest numbered version of the registered container image.
         *
         * Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
         */
        public var image: kotlin.String? = null
        /**
         * The open firewall ports of the container.
         */
        public var ports: Map<String, ContainerServiceProtocol>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.Container) : this() {
            this.command = x.command
            this.environment = x.environment
            this.image = x.image
            this.ports = x.ports
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.Container = Container(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
