// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a CloudFormation stack record created as a result of the `create cloud formation stack` action.
 *
 * A CloudFormation stack record provides information about the AWS CloudFormation stack used to create a new Amazon Elastic Compute Cloud instance from an exported Lightsail instance snapshot.
 */
public class CloudFormationStackRecord private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the CloudFormation stack record.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date when the CloudFormation stack record was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A list of objects describing the destination service, which is AWS CloudFormation, and the Amazon Resource Name (ARN) of the AWS CloudFormation stack.
     */
    public val destinationInfo: aws.sdk.kotlin.services.lightsail.model.DestinationInfo? = builder.destinationInfo
    /**
     * A list of objects describing the Availability Zone and Amazon Web Services Region of the CloudFormation stack record.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the CloudFormation stack record. It starts with `CloudFormationStackRecord` followed by a GUID.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Lightsail resource type (`CloudFormationStackRecord`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * A list of objects describing the source of the CloudFormation stack record.
     */
    public val sourceInfo: List<CloudFormationStackRecordSourceInfo>? = builder.sourceInfo
    /**
     * The current state of the CloudFormation stack record.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.RecordState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CloudFormationStackRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFormationStackRecord(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("destinationInfo=$destinationInfo,")
        append("location=$location,")
        append("name=$name,")
        append("resourceType=$resourceType,")
        append("sourceInfo=$sourceInfo,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (destinationInfo?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceInfo?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudFormationStackRecord

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (destinationInfo != other.destinationInfo) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (resourceType != other.resourceType) return false
        if (sourceInfo != other.sourceInfo) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CloudFormationStackRecord = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the CloudFormation stack record.
         */
        public var arn: kotlin.String? = null
        /**
         * The date when the CloudFormation stack record was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of objects describing the destination service, which is AWS CloudFormation, and the Amazon Resource Name (ARN) of the AWS CloudFormation stack.
         */
        public var destinationInfo: aws.sdk.kotlin.services.lightsail.model.DestinationInfo? = null
        /**
         * A list of objects describing the Availability Zone and Amazon Web Services Region of the CloudFormation stack record.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the CloudFormation stack record. It starts with `CloudFormationStackRecord` followed by a GUID.
         */
        public var name: kotlin.String? = null
        /**
         * The Lightsail resource type (`CloudFormationStackRecord`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * A list of objects describing the source of the CloudFormation stack record.
         */
        public var sourceInfo: List<CloudFormationStackRecordSourceInfo>? = null
        /**
         * The current state of the CloudFormation stack record.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.RecordState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CloudFormationStackRecord) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.destinationInfo = x.destinationInfo
            this.location = x.location
            this.name = x.name
            this.resourceType = x.resourceType
            this.sourceInfo = x.sourceInfo
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CloudFormationStackRecord = CloudFormationStackRecord(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.DestinationInfo] inside the given [block]
         */
        public fun destinationInfo(block: aws.sdk.kotlin.services.lightsail.model.DestinationInfo.Builder.() -> kotlin.Unit) {
            this.destinationInfo = aws.sdk.kotlin.services.lightsail.model.DestinationInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
