// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the per-path cache behavior of an Amazon Lightsail content delivery network (CDN) distribution.
 *
 * A per-path cache behavior is used to override, or add an exception to, the default cache behavior of a distribution. For example, if the `cacheBehavior` is set to `cache`, then a per-path cache behavior can be used to specify a directory, file, or file type that your distribution will cache. Alternately, if the distribution's `cacheBehavior` is `dont-cache`, then a per-path cache behavior can be used to specify a directory, file, or file type that your distribution will not cache.
 */
public class CacheBehaviorPerPath private constructor(builder: Builder) {
    /**
     * The cache behavior for the specified path.
     *
     * You can specify one of the following per-path cache behaviors:
     * + **`cache`** - This behavior caches the specified path.
     * + **`dont-cache`** - This behavior doesn't cache the specified path.
     */
    public val behavior: aws.sdk.kotlin.services.lightsail.model.BehaviorEnum? = builder.behavior
    /**
     * The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (`path/to/assets&#47;*`), and file types (`*.html, *jpg, *js`). Directories and file paths are case-sensitive.
     *
     * Examples:
     * + Specify the following to cache all files in the document root of an Apache web server running on a Lightsail instance.`var/www/html/`
     * + Specify the following file to cache only the index page in the document root of an Apache web server.`var/www/html/index.html`
     * + Specify the following to cache only the .html files in the document root of an Apache web server.`var/www/html&#47;*.html`
     * + Specify the following to cache only the .jpg, .png, and .gif files in the images sub-directory of the document root of an Apache web server.`var/www/html/images&#47;*.jpg``var/www/html/images&#47;*.png``var/www/html/images&#47;*.gif`Specify the following to cache all files in the images sub-directory of the document root of an Apache web server.`var/www/html/images/`
     */
    public val path: kotlin.String? = builder.path

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CacheBehaviorPerPath = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheBehaviorPerPath(")
        append("behavior=$behavior,")
        append("path=$path")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = behavior?.hashCode() ?: 0
        result = 31 * result + (path?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheBehaviorPerPath

        if (behavior != other.behavior) return false
        if (path != other.path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CacheBehaviorPerPath = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The cache behavior for the specified path.
         *
         * You can specify one of the following per-path cache behaviors:
         * + **`cache`** - This behavior caches the specified path.
         * + **`dont-cache`** - This behavior doesn't cache the specified path.
         */
        public var behavior: aws.sdk.kotlin.services.lightsail.model.BehaviorEnum? = null
        /**
         * The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (`path/to/assets&#47;*`), and file types (`*.html, *jpg, *js`). Directories and file paths are case-sensitive.
         *
         * Examples:
         * + Specify the following to cache all files in the document root of an Apache web server running on a Lightsail instance.`var/www/html/`
         * + Specify the following file to cache only the index page in the document root of an Apache web server.`var/www/html/index.html`
         * + Specify the following to cache only the .html files in the document root of an Apache web server.`var/www/html&#47;*.html`
         * + Specify the following to cache only the .jpg, .png, and .gif files in the images sub-directory of the document root of an Apache web server.`var/www/html/images&#47;*.jpg``var/www/html/images&#47;*.png``var/www/html/images&#47;*.gif`Specify the following to cache all files in the images sub-directory of the document root of an Apache web server.`var/www/html/images/`
         */
        public var path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CacheBehaviorPerPath) : this() {
            this.behavior = x.behavior
            this.path = x.path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CacheBehaviorPerPath = CacheBehaviorPerPath(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
