// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes the access log configuration for a bucket in the Amazon Lightsail object storage service.
 *
 * For more information about bucket access logs, see [Logging bucket requests using access logging in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-bucket-access-logs) in the *Amazon Lightsail Developer Guide*.
 */
public class BucketAccessLogConfig private constructor(builder: Builder) {
    /**
     * The name of the bucket where the access logs are saved. The destination can be a Lightsail bucket in the same account, and in the same Amazon Web Services Region as the source bucket.
     *
     * This parameter is required when enabling the access log for a bucket, and should be omitted when disabling the access log.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * A Boolean value that indicates whether bucket access logging is enabled for the bucket.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * The optional object prefix for the bucket access log.
     *
     * The prefix is an optional addition to the object key that organizes your access log files in the destination bucket. For example, if you specify a `logs/` prefix, then each log object will begin with the `logs/` prefix in its key (for example, `logs/2021-11-01-21-32-16-E568B2907131C0C0`).
     *
     * This parameter can be optionally specified when enabling the access log for a bucket, and should be omitted when disabling the access log.
     */
    public val prefix: kotlin.String? = builder.prefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketAccessLogConfig(")
        append("destination=$destination,")
        append("enabled=$enabled,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketAccessLogConfig

        if (destination != other.destination) return false
        if (enabled != other.enabled) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the bucket where the access logs are saved. The destination can be a Lightsail bucket in the same account, and in the same Amazon Web Services Region as the source bucket.
         *
         * This parameter is required when enabling the access log for a bucket, and should be omitted when disabling the access log.
         */
        public var destination: kotlin.String? = null
        /**
         * A Boolean value that indicates whether bucket access logging is enabled for the bucket.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The optional object prefix for the bucket access log.
         *
         * The prefix is an optional addition to the object key that organizes your access log files in the destination bucket. For example, if you specify a `logs/` prefix, then each log object will begin with the `logs/` prefix in its key (for example, `logs/2021-11-01-21-32-16-E568B2907131C0C0`).
         *
         * This parameter can be optionally specified when enabling the access log for a bucket, and should be omitted when disabling the access log.
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig) : this() {
            this.destination = x.destination
            this.enabled = x.enabled
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig = BucketAccessLogConfig(this)

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            return this
        }
    }
}
