// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes a blueprint (a virtual private server image).
 */
public class Blueprint private constructor(builder: Builder) {
    /**
     * Virtual computer blueprints that are supported by Lightsail for Research.
     *
     * This parameter only applies to Lightsail for Research resources.
     */
    public val appCategory: aws.sdk.kotlin.services.lightsail.model.AppCategory? = builder.appCategory
    /**
     * The ID for the virtual private server image (`app_wordpress_4_4` or `app_lamp_7_0`).
     */
    public val blueprintId: kotlin.String? = builder.blueprintId
    /**
     * The description of the blueprint.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The group name of the blueprint (`amazon-linux`).
     */
    public val group: kotlin.String? = builder.group
    /**
     * A Boolean value indicating whether the blueprint is active. Inactive blueprints are listed to support customers with existing instances but are not necessarily available for launch of new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.
     */
    public val isActive: kotlin.Boolean? = builder.isActive
    /**
     * The end-user license agreement URL for the image or blueprint.
     */
    public val licenseUrl: kotlin.String? = builder.licenseUrl
    /**
     * The minimum bundle power required to run this blueprint. For example, you need a bundle with a power value of 500 or more to create an instance that uses a blueprint with a minimum power value of 500. `0` indicates that the blueprint runs on all instance sizes.
     */
    public val minPower: kotlin.Int? = builder.minPower
    /**
     * The friendly name of the blueprint (`Amazon Linux`).
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
     */
    public val platform: aws.sdk.kotlin.services.lightsail.model.InstancePlatform? = builder.platform
    /**
     * The product URL to learn more about the image or blueprint.
     */
    public val productUrl: kotlin.String? = builder.productUrl
    /**
     * The type of the blueprint (`os` or `app`).
     */
    public val type: aws.sdk.kotlin.services.lightsail.model.BlueprintType? = builder.type
    /**
     * The version number of the operating system, application, or stack ( `2016.03.0`).
     */
    public val version: kotlin.String? = builder.version
    /**
     * The version code.
     */
    public val versionCode: kotlin.String? = builder.versionCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.Blueprint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Blueprint(")
        append("appCategory=$appCategory,")
        append("blueprintId=$blueprintId,")
        append("description=$description,")
        append("group=$group,")
        append("isActive=$isActive,")
        append("licenseUrl=$licenseUrl,")
        append("minPower=$minPower,")
        append("name=$name,")
        append("platform=$platform,")
        append("productUrl=$productUrl,")
        append("type=$type,")
        append("version=$version,")
        append("versionCode=$versionCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appCategory?.hashCode() ?: 0
        result = 31 * result + (blueprintId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (isActive?.hashCode() ?: 0)
        result = 31 * result + (licenseUrl?.hashCode() ?: 0)
        result = 31 * result + (minPower ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (productUrl?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (versionCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Blueprint

        if (appCategory != other.appCategory) return false
        if (blueprintId != other.blueprintId) return false
        if (description != other.description) return false
        if (group != other.group) return false
        if (isActive != other.isActive) return false
        if (licenseUrl != other.licenseUrl) return false
        if (minPower != other.minPower) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (productUrl != other.productUrl) return false
        if (type != other.type) return false
        if (version != other.version) return false
        if (versionCode != other.versionCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.Blueprint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Virtual computer blueprints that are supported by Lightsail for Research.
         *
         * This parameter only applies to Lightsail for Research resources.
         */
        public var appCategory: aws.sdk.kotlin.services.lightsail.model.AppCategory? = null
        /**
         * The ID for the virtual private server image (`app_wordpress_4_4` or `app_lamp_7_0`).
         */
        public var blueprintId: kotlin.String? = null
        /**
         * The description of the blueprint.
         */
        public var description: kotlin.String? = null
        /**
         * The group name of the blueprint (`amazon-linux`).
         */
        public var group: kotlin.String? = null
        /**
         * A Boolean value indicating whether the blueprint is active. Inactive blueprints are listed to support customers with existing instances but are not necessarily available for launch of new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.
         */
        public var isActive: kotlin.Boolean? = null
        /**
         * The end-user license agreement URL for the image or blueprint.
         */
        public var licenseUrl: kotlin.String? = null
        /**
         * The minimum bundle power required to run this blueprint. For example, you need a bundle with a power value of 500 or more to create an instance that uses a blueprint with a minimum power value of 500. `0` indicates that the blueprint runs on all instance sizes.
         */
        public var minPower: kotlin.Int? = null
        /**
         * The friendly name of the blueprint (`Amazon Linux`).
         */
        public var name: kotlin.String? = null
        /**
         * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
         */
        public var platform: aws.sdk.kotlin.services.lightsail.model.InstancePlatform? = null
        /**
         * The product URL to learn more about the image or blueprint.
         */
        public var productUrl: kotlin.String? = null
        /**
         * The type of the blueprint (`os` or `app`).
         */
        public var type: aws.sdk.kotlin.services.lightsail.model.BlueprintType? = null
        /**
         * The version number of the operating system, application, or stack ( `2016.03.0`).
         */
        public var version: kotlin.String? = null
        /**
         * The version code.
         */
        public var versionCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.Blueprint) : this() {
            this.appCategory = x.appCategory
            this.blueprintId = x.blueprintId
            this.description = x.description
            this.group = x.group
            this.isActive = x.isActive
            this.licenseUrl = x.licenseUrl
            this.minPower = x.minPower
            this.name = x.name
            this.platform = x.platform
            this.productUrl = x.productUrl
            this.type = x.type
            this.version = x.version
            this.versionCode = x.versionCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.Blueprint = Blueprint(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
