// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an alarm.
 *
 * An alarm is a way to monitor your Lightsail resource metrics. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
 */
public class Alarm private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the alarm.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The arithmetic operation used when comparing the specified statistic and threshold.
     */
    public val comparisonOperator: aws.sdk.kotlin.services.lightsail.model.ComparisonOperator? = builder.comparisonOperator
    /**
     * The contact protocols for the alarm, such as `Email`, `SMS` (text messaging), or both.
     */
    public val contactProtocols: List<ContactProtocol>? = builder.contactProtocols
    /**
     * The timestamp when the alarm was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The number of data points that must not within the specified threshold to trigger the alarm.
     */
    public val datapointsToAlarm: kotlin.Int? = builder.datapointsToAlarm
    /**
     * The number of periods over which data is compared to the specified threshold.
     */
    public val evaluationPeriods: kotlin.Int? = builder.evaluationPeriods
    /**
     * An object that lists information about the location of the alarm.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the metric associated with the alarm.
     */
    public val metricName: aws.sdk.kotlin.services.lightsail.model.MetricName? = builder.metricName
    /**
     * An object that lists information about the resource monitored by the alarm.
     */
    public val monitoredResourceInfo: aws.sdk.kotlin.services.lightsail.model.MonitoredResourceInfo? = builder.monitoredResourceInfo
    /**
     * The name of the alarm.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates whether the alarm is enabled.
     */
    public val notificationEnabled: kotlin.Boolean? = builder.notificationEnabled
    /**
     * The alarm states that trigger a notification.
     */
    public val notificationTriggers: List<AlarmState>? = builder.notificationTriggers
    /**
     * The period, in seconds, over which the statistic is applied.
     */
    public val period: kotlin.Int? = builder.period
    /**
     * The Lightsail resource type of the alarm.
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * The current state of the alarm.
     *
     * An alarm has the following possible states:
     * + `ALARM` - The metric is outside of the defined threshold.
     * + `INSUFFICIENT_DATA` - The alarm has just started, the metric is not available, or not enough data is available for the metric to determine the alarm state.
     * + `OK` - The metric is within the defined threshold.
     */
    public val state: aws.sdk.kotlin.services.lightsail.model.AlarmState? = builder.state
    /**
     * The statistic for the metric associated with the alarm.
     *
     * The following statistics are available:
     * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
     * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
     * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
     * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
     * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
     */
    public val statistic: aws.sdk.kotlin.services.lightsail.model.MetricStatistic? = builder.statistic
    /**
     * The support code. Include this code in your email to support when you have questions about your Lightsail alarm. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The value against which the specified statistic is compared.
     */
    public val threshold: kotlin.Double? = builder.threshold
    /**
     * Specifies how the alarm handles missing data points.
     *
     * An alarm can treat missing data in the following ways:
     * + `breaching` - Assume the missing data is not within the threshold. Missing data counts towards the number of times the metric is not within the threshold.
     * + `notBreaching` - Assume the missing data is within the threshold. Missing data does not count towards the number of times the metric is not within the threshold.
     * + `ignore` - Ignore the missing data. Maintains the current alarm state.
     * + `missing` - Missing data is treated as missing.
     */
    public val treatMissingData: aws.sdk.kotlin.services.lightsail.model.TreatMissingData? = builder.treatMissingData
    /**
     * The unit of the metric associated with the alarm.
     */
    public val unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.Alarm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Alarm(")
        append("arn=$arn,")
        append("comparisonOperator=$comparisonOperator,")
        append("contactProtocols=$contactProtocols,")
        append("createdAt=$createdAt,")
        append("datapointsToAlarm=$datapointsToAlarm,")
        append("evaluationPeriods=$evaluationPeriods,")
        append("location=$location,")
        append("metricName=$metricName,")
        append("monitoredResourceInfo=$monitoredResourceInfo,")
        append("name=$name,")
        append("notificationEnabled=$notificationEnabled,")
        append("notificationTriggers=$notificationTriggers,")
        append("period=$period,")
        append("resourceType=$resourceType,")
        append("state=$state,")
        append("statistic=$statistic,")
        append("supportCode=$supportCode,")
        append("threshold=$threshold,")
        append("treatMissingData=$treatMissingData,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (comparisonOperator?.hashCode() ?: 0)
        result = 31 * result + (contactProtocols?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (datapointsToAlarm ?: 0)
        result = 31 * result + (evaluationPeriods ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (monitoredResourceInfo?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notificationEnabled?.hashCode() ?: 0)
        result = 31 * result + (notificationTriggers?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (threshold?.hashCode() ?: 0)
        result = 31 * result + (treatMissingData?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Alarm

        if (arn != other.arn) return false
        if (comparisonOperator != other.comparisonOperator) return false
        if (contactProtocols != other.contactProtocols) return false
        if (createdAt != other.createdAt) return false
        if (datapointsToAlarm != other.datapointsToAlarm) return false
        if (evaluationPeriods != other.evaluationPeriods) return false
        if (location != other.location) return false
        if (metricName != other.metricName) return false
        if (monitoredResourceInfo != other.monitoredResourceInfo) return false
        if (name != other.name) return false
        if (notificationEnabled != other.notificationEnabled) return false
        if (notificationTriggers != other.notificationTriggers) return false
        if (period != other.period) return false
        if (resourceType != other.resourceType) return false
        if (state != other.state) return false
        if (statistic != other.statistic) return false
        if (supportCode != other.supportCode) return false
        if (threshold != other.threshold) return false
        if (treatMissingData != other.treatMissingData) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.Alarm = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the alarm.
         */
        public var arn: kotlin.String? = null
        /**
         * The arithmetic operation used when comparing the specified statistic and threshold.
         */
        public var comparisonOperator: aws.sdk.kotlin.services.lightsail.model.ComparisonOperator? = null
        /**
         * The contact protocols for the alarm, such as `Email`, `SMS` (text messaging), or both.
         */
        public var contactProtocols: List<ContactProtocol>? = null
        /**
         * The timestamp when the alarm was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of data points that must not within the specified threshold to trigger the alarm.
         */
        public var datapointsToAlarm: kotlin.Int? = null
        /**
         * The number of periods over which data is compared to the specified threshold.
         */
        public var evaluationPeriods: kotlin.Int? = null
        /**
         * An object that lists information about the location of the alarm.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the metric associated with the alarm.
         */
        public var metricName: aws.sdk.kotlin.services.lightsail.model.MetricName? = null
        /**
         * An object that lists information about the resource monitored by the alarm.
         */
        public var monitoredResourceInfo: aws.sdk.kotlin.services.lightsail.model.MonitoredResourceInfo? = null
        /**
         * The name of the alarm.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates whether the alarm is enabled.
         */
        public var notificationEnabled: kotlin.Boolean? = null
        /**
         * The alarm states that trigger a notification.
         */
        public var notificationTriggers: List<AlarmState>? = null
        /**
         * The period, in seconds, over which the statistic is applied.
         */
        public var period: kotlin.Int? = null
        /**
         * The Lightsail resource type of the alarm.
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * The current state of the alarm.
         *
         * An alarm has the following possible states:
         * + `ALARM` - The metric is outside of the defined threshold.
         * + `INSUFFICIENT_DATA` - The alarm has just started, the metric is not available, or not enough data is available for the metric to determine the alarm state.
         * + `OK` - The metric is within the defined threshold.
         */
        public var state: aws.sdk.kotlin.services.lightsail.model.AlarmState? = null
        /**
         * The statistic for the metric associated with the alarm.
         *
         * The following statistics are available:
         * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
         * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
         * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
         * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
         * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
         */
        public var statistic: aws.sdk.kotlin.services.lightsail.model.MetricStatistic? = null
        /**
         * The support code. Include this code in your email to support when you have questions about your Lightsail alarm. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The value against which the specified statistic is compared.
         */
        public var threshold: kotlin.Double? = null
        /**
         * Specifies how the alarm handles missing data points.
         *
         * An alarm can treat missing data in the following ways:
         * + `breaching` - Assume the missing data is not within the threshold. Missing data counts towards the number of times the metric is not within the threshold.
         * + `notBreaching` - Assume the missing data is within the threshold. Missing data does not count towards the number of times the metric is not within the threshold.
         * + `ignore` - Ignore the missing data. Maintains the current alarm state.
         * + `missing` - Missing data is treated as missing.
         */
        public var treatMissingData: aws.sdk.kotlin.services.lightsail.model.TreatMissingData? = null
        /**
         * The unit of the metric associated with the alarm.
         */
        public var unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.Alarm) : this() {
            this.arn = x.arn
            this.comparisonOperator = x.comparisonOperator
            this.contactProtocols = x.contactProtocols
            this.createdAt = x.createdAt
            this.datapointsToAlarm = x.datapointsToAlarm
            this.evaluationPeriods = x.evaluationPeriods
            this.location = x.location
            this.metricName = x.metricName
            this.monitoredResourceInfo = x.monitoredResourceInfo
            this.name = x.name
            this.notificationEnabled = x.notificationEnabled
            this.notificationTriggers = x.notificationTriggers
            this.period = x.period
            this.resourceType = x.resourceType
            this.state = x.state
            this.statistic = x.statistic
            this.supportCode = x.supportCode
            this.threshold = x.threshold
            this.treatMissingData = x.treatMissingData
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.Alarm = Alarm(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.MonitoredResourceInfo] inside the given [block]
         */
        public fun monitoredResourceInfo(block: aws.sdk.kotlin.services.lightsail.model.MonitoredResourceInfo.Builder.() -> kotlin.Unit) {
            this.monitoredResourceInfo = aws.sdk.kotlin.services.lightsail.model.MonitoredResourceInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
