// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * Describes a request to enable, modify, or disable an add-on for an Amazon Lightsail resource.
 *
 * An additional cost may be associated with enabling add-ons. For more information, see the [Lightsail pricing page](https://aws.amazon.com/lightsail/pricing/).
 */
public class AddOnRequest private constructor(builder: Builder) {
    /**
     * The add-on type.
     */
    public val addOnType: aws.sdk.kotlin.services.lightsail.model.AddOnType = requireNotNull(builder.addOnType) { "A non-null value must be provided for addOnType" }
    /**
     * An object that represents additional parameters when enabling or modifying the automatic snapshot add-on.
     */
    public val autoSnapshotAddOnRequest: aws.sdk.kotlin.services.lightsail.model.AutoSnapshotAddOnRequest? = builder.autoSnapshotAddOnRequest
    /**
     * An object that represents additional parameters when enabling or modifying the `StopInstanceOnIdle` add-on.
     *
     * This object only applies to Lightsail for Research resources.
     */
    public val stopInstanceOnIdleRequest: aws.sdk.kotlin.services.lightsail.model.StopInstanceOnIdleRequest? = builder.stopInstanceOnIdleRequest

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.AddOnRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddOnRequest(")
        append("addOnType=$addOnType,")
        append("autoSnapshotAddOnRequest=$autoSnapshotAddOnRequest,")
        append("stopInstanceOnIdleRequest=$stopInstanceOnIdleRequest")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addOnType.hashCode()
        result = 31 * result + (autoSnapshotAddOnRequest?.hashCode() ?: 0)
        result = 31 * result + (stopInstanceOnIdleRequest?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddOnRequest

        if (addOnType != other.addOnType) return false
        if (autoSnapshotAddOnRequest != other.autoSnapshotAddOnRequest) return false
        if (stopInstanceOnIdleRequest != other.stopInstanceOnIdleRequest) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.AddOnRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The add-on type.
         */
        public var addOnType: aws.sdk.kotlin.services.lightsail.model.AddOnType? = null
        /**
         * An object that represents additional parameters when enabling or modifying the automatic snapshot add-on.
         */
        public var autoSnapshotAddOnRequest: aws.sdk.kotlin.services.lightsail.model.AutoSnapshotAddOnRequest? = null
        /**
         * An object that represents additional parameters when enabling or modifying the `StopInstanceOnIdle` add-on.
         *
         * This object only applies to Lightsail for Research resources.
         */
        public var stopInstanceOnIdleRequest: aws.sdk.kotlin.services.lightsail.model.StopInstanceOnIdleRequest? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.AddOnRequest) : this() {
            this.addOnType = x.addOnType
            this.autoSnapshotAddOnRequest = x.autoSnapshotAddOnRequest
            this.stopInstanceOnIdleRequest = x.stopInstanceOnIdleRequest
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.AddOnRequest = AddOnRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.AutoSnapshotAddOnRequest] inside the given [block]
         */
        public fun autoSnapshotAddOnRequest(block: aws.sdk.kotlin.services.lightsail.model.AutoSnapshotAddOnRequest.Builder.() -> kotlin.Unit) {
            this.autoSnapshotAddOnRequest = aws.sdk.kotlin.services.lightsail.model.AutoSnapshotAddOnRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.StopInstanceOnIdleRequest] inside the given [block]
         */
        public fun stopInstanceOnIdleRequest(block: aws.sdk.kotlin.services.lightsail.model.StopInstanceOnIdleRequest.Builder.() -> kotlin.Unit) {
            this.stopInstanceOnIdleRequest = aws.sdk.kotlin.services.lightsail.model.StopInstanceOnIdleRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (addOnType == null) addOnType = AddOnType.SdkUnknown("no value provided")
            return this
        }
    }
}
