// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an access key for an Amazon Lightsail bucket.
 *
 * Access keys grant full programmatic access to the specified bucket and its objects. You can have a maximum of two access keys per bucket. Use the [CreateBucketAccessKey](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html) action to create an access key for a specific bucket. For more information about access keys, see [Creating access keys for a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys) in the *Amazon Lightsail Developer Guide*.
 *
 * The `secretAccessKey` value is returned only in response to the `CreateBucketAccessKey` action. You can get a secret access key only when you first create an access key; you cannot get the secret access key later. If you lose the secret access key, you must create a new access key.
 */
public class AccessKey private constructor(builder: Builder) {
    /**
     * The ID of the access key.
     */
    public val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * The timestamp when the access key was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An object that describes the last time the access key was used.
     *
     * This object does not include data in the response of a [CreateBucketAccessKey](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html) action. If the access key has not been used, the `region` and `serviceName` values are `N/A`, and the `lastUsedDate` value is null.
     */
    public val lastUsed: aws.sdk.kotlin.services.lightsail.model.AccessKeyLastUsed? = builder.lastUsed
    /**
     * The secret access key used to sign requests.
     *
     * You should store the secret access key in a safe location. We recommend that you delete the access key if the secret access key is compromised.
     */
    public val secretAccessKey: kotlin.String? = builder.secretAccessKey
    /**
     * The status of the access key.
     *
     * A status of `Active` means that the key is valid, while `Inactive` means it is not.
     */
    public val status: aws.sdk.kotlin.services.lightsail.model.StatusType? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.AccessKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessKey(")
        append("accessKeyId=*** Sensitive Data Redacted ***,")
        append("createdAt=$createdAt,")
        append("lastUsed=$lastUsed,")
        append("secretAccessKey=$secretAccessKey,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (lastUsed?.hashCode() ?: 0)
        result = 31 * result + (secretAccessKey?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessKey

        if (accessKeyId != other.accessKeyId) return false
        if (createdAt != other.createdAt) return false
        if (lastUsed != other.lastUsed) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.AccessKey = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the access key.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * The timestamp when the access key was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that describes the last time the access key was used.
         *
         * This object does not include data in the response of a [CreateBucketAccessKey](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html) action. If the access key has not been used, the `region` and `serviceName` values are `N/A`, and the `lastUsedDate` value is null.
         */
        public var lastUsed: aws.sdk.kotlin.services.lightsail.model.AccessKeyLastUsed? = null
        /**
         * The secret access key used to sign requests.
         *
         * You should store the secret access key in a safe location. We recommend that you delete the access key if the secret access key is compromised.
         */
        public var secretAccessKey: kotlin.String? = null
        /**
         * The status of the access key.
         *
         * A status of `Active` means that the key is valid, while `Inactive` means it is not.
         */
        public var status: aws.sdk.kotlin.services.lightsail.model.StatusType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.AccessKey) : this() {
            this.accessKeyId = x.accessKeyId
            this.createdAt = x.createdAt
            this.lastUsed = x.lastUsed
            this.secretAccessKey = x.secretAccessKey
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.AccessKey = AccessKey(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.AccessKeyLastUsed] inside the given [block]
         */
        public fun lastUsed(block: aws.sdk.kotlin.services.lightsail.model.AccessKeyLastUsed.Builder.() -> kotlin.Unit) {
            this.lastUsed = aws.sdk.kotlin.services.lightsail.model.AccessKeyLastUsed.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
