// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.lightsail.auth.DefaultLightsailAuthSchemeProvider
import aws.sdk.kotlin.services.lightsail.auth.LightsailAuthSchemeProvider
import aws.sdk.kotlin.services.lightsail.endpoints.DefaultLightsailEndpointProvider
import aws.sdk.kotlin.services.lightsail.endpoints.LightsailEndpointParameters
import aws.sdk.kotlin.services.lightsail.endpoints.LightsailEndpointProvider
import aws.sdk.kotlin.services.lightsail.model.AllocateStaticIpRequest
import aws.sdk.kotlin.services.lightsail.model.AllocateStaticIpResponse
import aws.sdk.kotlin.services.lightsail.model.AttachCertificateToDistributionRequest
import aws.sdk.kotlin.services.lightsail.model.AttachCertificateToDistributionResponse
import aws.sdk.kotlin.services.lightsail.model.AttachDiskRequest
import aws.sdk.kotlin.services.lightsail.model.AttachDiskResponse
import aws.sdk.kotlin.services.lightsail.model.AttachInstancesToLoadBalancerRequest
import aws.sdk.kotlin.services.lightsail.model.AttachInstancesToLoadBalancerResponse
import aws.sdk.kotlin.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest
import aws.sdk.kotlin.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse
import aws.sdk.kotlin.services.lightsail.model.AttachStaticIpRequest
import aws.sdk.kotlin.services.lightsail.model.AttachStaticIpResponse
import aws.sdk.kotlin.services.lightsail.model.CloseInstancePublicPortsRequest
import aws.sdk.kotlin.services.lightsail.model.CloseInstancePublicPortsResponse
import aws.sdk.kotlin.services.lightsail.model.CopySnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.CopySnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.CreateBucketAccessKeyRequest
import aws.sdk.kotlin.services.lightsail.model.CreateBucketAccessKeyResponse
import aws.sdk.kotlin.services.lightsail.model.CreateBucketRequest
import aws.sdk.kotlin.services.lightsail.model.CreateBucketResponse
import aws.sdk.kotlin.services.lightsail.model.CreateCertificateRequest
import aws.sdk.kotlin.services.lightsail.model.CreateCertificateResponse
import aws.sdk.kotlin.services.lightsail.model.CreateCloudFormationStackRequest
import aws.sdk.kotlin.services.lightsail.model.CreateCloudFormationStackResponse
import aws.sdk.kotlin.services.lightsail.model.CreateContactMethodRequest
import aws.sdk.kotlin.services.lightsail.model.CreateContactMethodResponse
import aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceDeploymentRequest
import aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceDeploymentResponse
import aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceRegistryLoginRequest
import aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceRegistryLoginResponse
import aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceRequest
import aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceResponse
import aws.sdk.kotlin.services.lightsail.model.CreateDiskFromSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.CreateDiskFromSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.CreateDiskRequest
import aws.sdk.kotlin.services.lightsail.model.CreateDiskResponse
import aws.sdk.kotlin.services.lightsail.model.CreateDiskSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.CreateDiskSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.CreateDistributionRequest
import aws.sdk.kotlin.services.lightsail.model.CreateDistributionResponse
import aws.sdk.kotlin.services.lightsail.model.CreateDomainEntryRequest
import aws.sdk.kotlin.services.lightsail.model.CreateDomainEntryResponse
import aws.sdk.kotlin.services.lightsail.model.CreateDomainRequest
import aws.sdk.kotlin.services.lightsail.model.CreateDomainResponse
import aws.sdk.kotlin.services.lightsail.model.CreateGuiSessionAccessDetailsRequest
import aws.sdk.kotlin.services.lightsail.model.CreateGuiSessionAccessDetailsResponse
import aws.sdk.kotlin.services.lightsail.model.CreateInstanceSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.CreateInstanceSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.CreateInstancesFromSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.CreateInstancesFromSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.CreateInstancesRequest
import aws.sdk.kotlin.services.lightsail.model.CreateInstancesResponse
import aws.sdk.kotlin.services.lightsail.model.CreateKeyPairRequest
import aws.sdk.kotlin.services.lightsail.model.CreateKeyPairResponse
import aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerRequest
import aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerResponse
import aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest
import aws.sdk.kotlin.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse
import aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseRequest
import aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseResponse
import aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.CreateRelationalDatabaseSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteAlarmRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteAlarmResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteAutoSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteAutoSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteBucketAccessKeyRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteBucketAccessKeyResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteBucketRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteBucketResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteCertificateRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteCertificateResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteContactMethodRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteContactMethodResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteContainerImageRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteContainerImageResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteContainerServiceRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteContainerServiceResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteDiskRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteDiskResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteDiskSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteDiskSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteDistributionRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteDistributionResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteDomainEntryRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteDomainEntryResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteDomainRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteDomainResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteInstanceRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteInstanceResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteInstanceSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteInstanceSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteKeyPairRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteKeyPairResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteKnownHostKeysRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteKnownHostKeysResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteLoadBalancerRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteLoadBalancerResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteRelationalDatabaseRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteRelationalDatabaseResponse
import aws.sdk.kotlin.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.DeleteRelationalDatabaseSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.DetachCertificateFromDistributionRequest
import aws.sdk.kotlin.services.lightsail.model.DetachCertificateFromDistributionResponse
import aws.sdk.kotlin.services.lightsail.model.DetachDiskRequest
import aws.sdk.kotlin.services.lightsail.model.DetachDiskResponse
import aws.sdk.kotlin.services.lightsail.model.DetachInstancesFromLoadBalancerRequest
import aws.sdk.kotlin.services.lightsail.model.DetachInstancesFromLoadBalancerResponse
import aws.sdk.kotlin.services.lightsail.model.DetachStaticIpRequest
import aws.sdk.kotlin.services.lightsail.model.DetachStaticIpResponse
import aws.sdk.kotlin.services.lightsail.model.DisableAddOnRequest
import aws.sdk.kotlin.services.lightsail.model.DisableAddOnResponse
import aws.sdk.kotlin.services.lightsail.model.DownloadDefaultKeyPairRequest
import aws.sdk.kotlin.services.lightsail.model.DownloadDefaultKeyPairResponse
import aws.sdk.kotlin.services.lightsail.model.EnableAddOnRequest
import aws.sdk.kotlin.services.lightsail.model.EnableAddOnResponse
import aws.sdk.kotlin.services.lightsail.model.ExportSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.ExportSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.GetActiveNamesRequest
import aws.sdk.kotlin.services.lightsail.model.GetActiveNamesResponse
import aws.sdk.kotlin.services.lightsail.model.GetAlarmsRequest
import aws.sdk.kotlin.services.lightsail.model.GetAlarmsResponse
import aws.sdk.kotlin.services.lightsail.model.GetAutoSnapshotsRequest
import aws.sdk.kotlin.services.lightsail.model.GetAutoSnapshotsResponse
import aws.sdk.kotlin.services.lightsail.model.GetBlueprintsRequest
import aws.sdk.kotlin.services.lightsail.model.GetBlueprintsResponse
import aws.sdk.kotlin.services.lightsail.model.GetBucketAccessKeysRequest
import aws.sdk.kotlin.services.lightsail.model.GetBucketAccessKeysResponse
import aws.sdk.kotlin.services.lightsail.model.GetBucketBundlesRequest
import aws.sdk.kotlin.services.lightsail.model.GetBucketBundlesResponse
import aws.sdk.kotlin.services.lightsail.model.GetBucketMetricDataRequest
import aws.sdk.kotlin.services.lightsail.model.GetBucketMetricDataResponse
import aws.sdk.kotlin.services.lightsail.model.GetBucketsRequest
import aws.sdk.kotlin.services.lightsail.model.GetBucketsResponse
import aws.sdk.kotlin.services.lightsail.model.GetBundlesRequest
import aws.sdk.kotlin.services.lightsail.model.GetBundlesResponse
import aws.sdk.kotlin.services.lightsail.model.GetCertificatesRequest
import aws.sdk.kotlin.services.lightsail.model.GetCertificatesResponse
import aws.sdk.kotlin.services.lightsail.model.GetCloudFormationStackRecordsRequest
import aws.sdk.kotlin.services.lightsail.model.GetCloudFormationStackRecordsResponse
import aws.sdk.kotlin.services.lightsail.model.GetContactMethodsRequest
import aws.sdk.kotlin.services.lightsail.model.GetContactMethodsResponse
import aws.sdk.kotlin.services.lightsail.model.GetContainerApiMetadataRequest
import aws.sdk.kotlin.services.lightsail.model.GetContainerApiMetadataResponse
import aws.sdk.kotlin.services.lightsail.model.GetContainerImagesRequest
import aws.sdk.kotlin.services.lightsail.model.GetContainerImagesResponse
import aws.sdk.kotlin.services.lightsail.model.GetContainerLogRequest
import aws.sdk.kotlin.services.lightsail.model.GetContainerLogResponse
import aws.sdk.kotlin.services.lightsail.model.GetContainerServiceDeploymentsRequest
import aws.sdk.kotlin.services.lightsail.model.GetContainerServiceDeploymentsResponse
import aws.sdk.kotlin.services.lightsail.model.GetContainerServiceMetricDataRequest
import aws.sdk.kotlin.services.lightsail.model.GetContainerServiceMetricDataResponse
import aws.sdk.kotlin.services.lightsail.model.GetContainerServicePowersRequest
import aws.sdk.kotlin.services.lightsail.model.GetContainerServicePowersResponse
import aws.sdk.kotlin.services.lightsail.model.GetContainerServicesRequest
import aws.sdk.kotlin.services.lightsail.model.GetContainerServicesResponse
import aws.sdk.kotlin.services.lightsail.model.GetCostEstimateRequest
import aws.sdk.kotlin.services.lightsail.model.GetCostEstimateResponse
import aws.sdk.kotlin.services.lightsail.model.GetDiskRequest
import aws.sdk.kotlin.services.lightsail.model.GetDiskResponse
import aws.sdk.kotlin.services.lightsail.model.GetDiskSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.GetDiskSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.GetDiskSnapshotsRequest
import aws.sdk.kotlin.services.lightsail.model.GetDiskSnapshotsResponse
import aws.sdk.kotlin.services.lightsail.model.GetDisksRequest
import aws.sdk.kotlin.services.lightsail.model.GetDisksResponse
import aws.sdk.kotlin.services.lightsail.model.GetDistributionBundlesRequest
import aws.sdk.kotlin.services.lightsail.model.GetDistributionBundlesResponse
import aws.sdk.kotlin.services.lightsail.model.GetDistributionLatestCacheResetRequest
import aws.sdk.kotlin.services.lightsail.model.GetDistributionLatestCacheResetResponse
import aws.sdk.kotlin.services.lightsail.model.GetDistributionMetricDataRequest
import aws.sdk.kotlin.services.lightsail.model.GetDistributionMetricDataResponse
import aws.sdk.kotlin.services.lightsail.model.GetDistributionsRequest
import aws.sdk.kotlin.services.lightsail.model.GetDistributionsResponse
import aws.sdk.kotlin.services.lightsail.model.GetDomainRequest
import aws.sdk.kotlin.services.lightsail.model.GetDomainResponse
import aws.sdk.kotlin.services.lightsail.model.GetDomainsRequest
import aws.sdk.kotlin.services.lightsail.model.GetDomainsResponse
import aws.sdk.kotlin.services.lightsail.model.GetExportSnapshotRecordsRequest
import aws.sdk.kotlin.services.lightsail.model.GetExportSnapshotRecordsResponse
import aws.sdk.kotlin.services.lightsail.model.GetInstanceAccessDetailsRequest
import aws.sdk.kotlin.services.lightsail.model.GetInstanceAccessDetailsResponse
import aws.sdk.kotlin.services.lightsail.model.GetInstanceMetricDataRequest
import aws.sdk.kotlin.services.lightsail.model.GetInstanceMetricDataResponse
import aws.sdk.kotlin.services.lightsail.model.GetInstancePortStatesRequest
import aws.sdk.kotlin.services.lightsail.model.GetInstancePortStatesResponse
import aws.sdk.kotlin.services.lightsail.model.GetInstanceRequest
import aws.sdk.kotlin.services.lightsail.model.GetInstanceResponse
import aws.sdk.kotlin.services.lightsail.model.GetInstanceSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.GetInstanceSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.GetInstanceSnapshotsRequest
import aws.sdk.kotlin.services.lightsail.model.GetInstanceSnapshotsResponse
import aws.sdk.kotlin.services.lightsail.model.GetInstanceStateRequest
import aws.sdk.kotlin.services.lightsail.model.GetInstanceStateResponse
import aws.sdk.kotlin.services.lightsail.model.GetInstancesRequest
import aws.sdk.kotlin.services.lightsail.model.GetInstancesResponse
import aws.sdk.kotlin.services.lightsail.model.GetKeyPairRequest
import aws.sdk.kotlin.services.lightsail.model.GetKeyPairResponse
import aws.sdk.kotlin.services.lightsail.model.GetKeyPairsRequest
import aws.sdk.kotlin.services.lightsail.model.GetKeyPairsResponse
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerMetricDataRequest
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerMetricDataResponse
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerRequest
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerResponse
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancerTlsPoliciesResponse
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancersRequest
import aws.sdk.kotlin.services.lightsail.model.GetLoadBalancersResponse
import aws.sdk.kotlin.services.lightsail.model.GetOperationRequest
import aws.sdk.kotlin.services.lightsail.model.GetOperationResponse
import aws.sdk.kotlin.services.lightsail.model.GetOperationsForResourceRequest
import aws.sdk.kotlin.services.lightsail.model.GetOperationsForResourceResponse
import aws.sdk.kotlin.services.lightsail.model.GetOperationsRequest
import aws.sdk.kotlin.services.lightsail.model.GetOperationsResponse
import aws.sdk.kotlin.services.lightsail.model.GetRegionsRequest
import aws.sdk.kotlin.services.lightsail.model.GetRegionsResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseBundlesRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseBundlesResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseEventsRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseEventsResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseLogEventsRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseLogEventsResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseMetricDataRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseMetricDataResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseParametersRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseParametersResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseSnapshotRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseSnapshotResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabasesRequest
import aws.sdk.kotlin.services.lightsail.model.GetRelationalDatabasesResponse
import aws.sdk.kotlin.services.lightsail.model.GetSetupHistoryRequest
import aws.sdk.kotlin.services.lightsail.model.GetSetupHistoryResponse
import aws.sdk.kotlin.services.lightsail.model.GetStaticIpRequest
import aws.sdk.kotlin.services.lightsail.model.GetStaticIpResponse
import aws.sdk.kotlin.services.lightsail.model.GetStaticIpsRequest
import aws.sdk.kotlin.services.lightsail.model.GetStaticIpsResponse
import aws.sdk.kotlin.services.lightsail.model.ImportKeyPairRequest
import aws.sdk.kotlin.services.lightsail.model.ImportKeyPairResponse
import aws.sdk.kotlin.services.lightsail.model.IsVpcPeeredRequest
import aws.sdk.kotlin.services.lightsail.model.IsVpcPeeredResponse
import aws.sdk.kotlin.services.lightsail.model.OpenInstancePublicPortsRequest
import aws.sdk.kotlin.services.lightsail.model.OpenInstancePublicPortsResponse
import aws.sdk.kotlin.services.lightsail.model.PeerVpcRequest
import aws.sdk.kotlin.services.lightsail.model.PeerVpcResponse
import aws.sdk.kotlin.services.lightsail.model.PutAlarmRequest
import aws.sdk.kotlin.services.lightsail.model.PutAlarmResponse
import aws.sdk.kotlin.services.lightsail.model.PutInstancePublicPortsRequest
import aws.sdk.kotlin.services.lightsail.model.PutInstancePublicPortsResponse
import aws.sdk.kotlin.services.lightsail.model.RebootInstanceRequest
import aws.sdk.kotlin.services.lightsail.model.RebootInstanceResponse
import aws.sdk.kotlin.services.lightsail.model.RebootRelationalDatabaseRequest
import aws.sdk.kotlin.services.lightsail.model.RebootRelationalDatabaseResponse
import aws.sdk.kotlin.services.lightsail.model.RegisterContainerImageRequest
import aws.sdk.kotlin.services.lightsail.model.RegisterContainerImageResponse
import aws.sdk.kotlin.services.lightsail.model.ReleaseStaticIpRequest
import aws.sdk.kotlin.services.lightsail.model.ReleaseStaticIpResponse
import aws.sdk.kotlin.services.lightsail.model.ResetDistributionCacheRequest
import aws.sdk.kotlin.services.lightsail.model.ResetDistributionCacheResponse
import aws.sdk.kotlin.services.lightsail.model.SendContactMethodVerificationRequest
import aws.sdk.kotlin.services.lightsail.model.SendContactMethodVerificationResponse
import aws.sdk.kotlin.services.lightsail.model.SetIpAddressTypeRequest
import aws.sdk.kotlin.services.lightsail.model.SetIpAddressTypeResponse
import aws.sdk.kotlin.services.lightsail.model.SetResourceAccessForBucketRequest
import aws.sdk.kotlin.services.lightsail.model.SetResourceAccessForBucketResponse
import aws.sdk.kotlin.services.lightsail.model.SetupInstanceHttpsRequest
import aws.sdk.kotlin.services.lightsail.model.SetupInstanceHttpsResponse
import aws.sdk.kotlin.services.lightsail.model.StartGuiSessionRequest
import aws.sdk.kotlin.services.lightsail.model.StartGuiSessionResponse
import aws.sdk.kotlin.services.lightsail.model.StartInstanceRequest
import aws.sdk.kotlin.services.lightsail.model.StartInstanceResponse
import aws.sdk.kotlin.services.lightsail.model.StartRelationalDatabaseRequest
import aws.sdk.kotlin.services.lightsail.model.StartRelationalDatabaseResponse
import aws.sdk.kotlin.services.lightsail.model.StopGuiSessionRequest
import aws.sdk.kotlin.services.lightsail.model.StopGuiSessionResponse
import aws.sdk.kotlin.services.lightsail.model.StopInstanceRequest
import aws.sdk.kotlin.services.lightsail.model.StopInstanceResponse
import aws.sdk.kotlin.services.lightsail.model.StopRelationalDatabaseRequest
import aws.sdk.kotlin.services.lightsail.model.StopRelationalDatabaseResponse
import aws.sdk.kotlin.services.lightsail.model.TagResourceRequest
import aws.sdk.kotlin.services.lightsail.model.TagResourceResponse
import aws.sdk.kotlin.services.lightsail.model.TestAlarmRequest
import aws.sdk.kotlin.services.lightsail.model.TestAlarmResponse
import aws.sdk.kotlin.services.lightsail.model.UnpeerVpcRequest
import aws.sdk.kotlin.services.lightsail.model.UnpeerVpcResponse
import aws.sdk.kotlin.services.lightsail.model.UntagResourceRequest
import aws.sdk.kotlin.services.lightsail.model.UntagResourceResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateBucketBundleRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateBucketBundleResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateBucketRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateBucketResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateContainerServiceRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateContainerServiceResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateDistributionBundleRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateDistributionBundleResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateDistributionRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateDistributionResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateDomainEntryRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateDomainEntryResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateInstanceMetadataOptionsRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateInstanceMetadataOptionsResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateLoadBalancerAttributeRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateLoadBalancerAttributeResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateRelationalDatabaseParametersRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateRelationalDatabaseParametersResponse
import aws.sdk.kotlin.services.lightsail.model.UpdateRelationalDatabaseRequest
import aws.sdk.kotlin.services.lightsail.model.UpdateRelationalDatabaseResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Lightsail"
public const val SdkVersion: String = "1.1.1"
public const val ServiceApiVersion: String = "2016-11-28"

/**
 * Amazon Lightsail is the easiest way to get started with Amazon Web Services (Amazon Web Services) for developers who need to build websites or web applications. It includes everything you need to launch your project quickly - instances (virtual private servers), container services, storage buckets, managed databases, SSD-based block storage, static IP addresses, load balancers, content delivery network (CDN) distributions, DNS management of registered domains, and resource snapshots (backups) - for a low, predictable monthly price.
 *
 * You can manage your Lightsail resources using the Lightsail console, Lightsail API, Command Line Interface (CLI), or SDKs. For more information about Lightsail concepts and tasks, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-how-to-set-up-access-keys-to-use-sdk-api-cli).
 *
 * This API Reference provides detailed information about the actions, data types, parameters, and errors of the Lightsail service. For more information about the supported Amazon Web Services Regions, endpoints, and service quotas of the Lightsail service, see [Amazon Lightsail Endpoints and Quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in the *Amazon Web Services General Reference*.
 */
public interface LightsailClient : SdkClient {
    /**
     * LightsailClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, LightsailClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Lightsail",
                "LIGHTSAIL",
                "lightsail",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, LightsailClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): LightsailClient = DefaultLightsailClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: LightsailEndpointProvider = builder.endpointProvider ?: DefaultLightsailEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: LightsailAuthSchemeProvider = builder.authSchemeProvider ?: DefaultLightsailAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Lightsail"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: LightsailEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: LightsailAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Allocates a static IP address.
     */
    public suspend fun allocateStaticIp(input: AllocateStaticIpRequest): AllocateStaticIpResponse

    /**
     * Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * After the certificate is attached, your distribution accepts HTTPS traffic for all of the domains that are associated with the certificate.
     *
     * Use the `CreateCertificate` action to create a certificate that you can attach to your distribution.
     *
     * Only certificates created in the `us-east-1` Amazon Web Services Region can be attached to Lightsail distributions. Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
     */
    public suspend fun attachCertificateToDistribution(input: AttachCertificateToDistributionRequest): AttachCertificateToDistributionResponse

    /**
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the specified disk name.
     *
     * The `attach disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun attachDisk(input: AttachDiskRequest): AttachDiskResponse

    /**
     * Attaches one or more Lightsail instances to a load balancer.
     *
     * After some time, the instances are attached to the load balancer and the health check status is available.
     *
     * The `attach instances to load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun attachInstancesToLoadBalancer(input: AttachInstancesToLoadBalancerRequest): AttachInstancesToLoadBalancerResponse

    /**
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     *
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API to rotate the certificates on your account. Use the `AttachLoadBalancerTlsCertificate` action with the non-attached certificate, and it will replace the existing one and become the attached certificate.
     *
     * The `AttachLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun attachLoadBalancerTlsCertificate(input: AttachLoadBalancerTlsCertificateRequest): AttachLoadBalancerTlsCertificateResponse

    /**
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     */
    public suspend fun attachStaticIp(input: AttachStaticIpRequest): AttachStaticIpResponse

    /**
     * Closes ports for a specific Amazon Lightsail instance.
     *
     * The `CloseInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun closeInstancePublicPorts(input: CloseInstancePublicPortsRequest): CloseInstancePublicPortsResponse

    /**
     * Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of an instance or a disk from one Amazon Web Services Region to another in Amazon Lightsail.
     *
     * When copying a *manual snapshot*, be sure to define the `source region`, `source snapshot name`, and `target snapshot name` parameters.
     *
     * When copying an *automatic snapshot*, be sure to define the `source region`, `source resource name`, `target snapshot name`, and either the `restore date` or the `use latest restorable auto snapshot` parameters.
     */
    public suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse

    /**
     * Creates an Amazon Lightsail bucket.
     *
     * A bucket is a cloud storage resource available in the Lightsail object storage service. Use buckets to store objects such as data and its descriptive metadata. For more information about buckets, see [Buckets in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
     */
    public suspend fun createBucket(input: CreateBucketRequest): CreateBucketResponse

    /**
     * Creates a new access key for the specified Amazon Lightsail bucket. Access keys consist of an access key ID and corresponding secret access key.
     *
     * Access keys grant full programmatic access to the specified bucket and its objects. You can have a maximum of two access keys per bucket. Use the [GetBucketAccessKeys](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketAccessKeys.html) action to get a list of current access keys for a specific bucket. For more information about access keys, see [Creating access keys for a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys) in the *Amazon Lightsail Developer Guide*.
     *
     * The `secretAccessKey` value is returned only in response to the `CreateBucketAccessKey` action. You can get a secret access key only when you first create an access key; you cannot get the secret access key later. If you lose the secret access key, you must create a new access key.
     */
    public suspend fun createBucketAccessKey(input: CreateBucketAccessKeyRequest): CreateBucketAccessKeyResponse

    /**
     * Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN) distribution and a container service.
     *
     * After the certificate is valid, use the `AttachCertificateToDistribution` action to use the certificate and its domains with your distribution. Or use the `UpdateContainerService` action to use the certificate and its domains with your container service.
     *
     * Only certificates created in the `us-east-1` Amazon Web Services Region can be attached to Lightsail distributions. Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
     */
    public suspend fun createCertificate(input: CreateCertificateRequest): CreateCertificateResponse

    /**
     * Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported Amazon Lightsail snapshot. This operation results in a CloudFormation stack record that can be used to track the AWS CloudFormation stack created. Use the `get cloud formation stack records` operation to get a list of the CloudFormation stacks created.
     *
     * Wait until after your new Amazon EC2 instance is created before running the `create cloud formation stack` operation again with the same export snapshot record.
     */
    public suspend fun createCloudFormationStack(input: CreateCloudFormationStackRequest): CreateCloudFormationStackResponse

    /**
     * Creates an email or SMS text message contact method.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    public suspend fun createContactMethod(input: CreateContactMethodRequest): CreateContactMethodResponse

    /**
     * Creates an Amazon Lightsail container service.
     *
     * A Lightsail container service is a compute resource to which you can deploy containers. For more information, see [Container services in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services) in the *Lightsail Dev Guide*.
     */
    public suspend fun createContainerService(input: CreateContainerServiceRequest): CreateContainerServiceResponse

    /**
     * Creates a deployment for your Amazon Lightsail container service.
     *
     * A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration.
     *
     * You can deploy containers to your container service using container images from a public registry such as Amazon ECR Public, or from your local machine. For more information, see [Creating container images for your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-images) in the *Amazon Lightsail Developer Guide*.
     */
    public suspend fun createContainerServiceDeployment(input: CreateContainerServiceDeploymentRequest): CreateContainerServiceDeploymentResponse

    /**
     * Creates a temporary set of log in credentials that you can use to log in to the Docker process on your local machine. After you're logged in, you can use the native Docker commands to push your local container images to the container image registry of your Amazon Lightsail account so that you can use them with your Lightsail container service. The log in credentials expire 12 hours after they are created, at which point you will need to create a new set of log in credentials.
     *
     * You can only push container images to the container service registry of your Lightsail account. You cannot pull container images or perform any other container image management actions on the container service registry.
     *
     * After you push your container images to the container image registry of your Lightsail account, use the `RegisterContainerImage` action to register the pushed images to a specific Lightsail container service.
     *
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container images to your Lightsail container service. For more information, see [Pushing and managing container images on your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images) in the *Amazon Lightsail Developer Guide*.
     */
    public suspend fun createContainerServiceRegistryLogin(input: CreateContainerServiceRegistryLoginRequest = CreateContainerServiceRegistryLoginRequest { }): CreateContainerServiceRegistryLoginResponse

    /**
     * Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone (`us-east-2a`).
     *
     * The `create disk` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createDisk(input: CreateDiskRequest): CreateDiskResponse

    /**
     * Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to an Amazon Lightsail instance in the same Availability Zone (`us-east-2a`).
     *
     * The `create disk from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `disk snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createDiskFromSnapshot(input: CreateDiskFromSnapshotRequest): CreateDiskFromSnapshotResponse

    /**
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to save data before shutting down a Lightsail instance.
     *
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the disk long enough to take a snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the snapshot status is pending.
     *
     * You can also use this operation to create a snapshot of an instance's system volume. You might want to do this, for example, to recover data from the system volume of a botched instance or to create a backup of the system volume like you would for a block storage disk. To create a snapshot of a system volume, just define the `instance name` parameter when issuing the snapshot command, and a snapshot of the defined instance's system volume will be created. After the snapshot is available, you can create a block storage disk from the snapshot and attach it to a running instance to access the data on the disk.
     *
     * The `create disk snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createDiskSnapshot(input: CreateDiskSnapshotRequest): CreateDiskSnapshotResponse

    /**
     * Creates an Amazon Lightsail content delivery network (CDN) distribution.
     *
     * A distribution is a globally distributed network of caching servers that improve the performance of your website or web application hosted on a Lightsail instance. For more information, see [Content delivery networks in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-content-delivery-network-distributions).
     */
    public suspend fun createDistribution(input: CreateDistributionRequest): CreateDistributionResponse

    /**
     * Creates a domain resource for the specified domain (example.com).
     *
     * The `create domain` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates one of the following domain name system (DNS) records in a domain DNS zone: Address (A), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     *
     * The `create domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createDomainEntry(input: CreateDomainEntryRequest): CreateDomainEntryResponse

    /**
     * Creates two URLs that are used to access a virtual computer’s graphical user interface (GUI) session. The primary URL initiates a web-based NICE DCV session to the virtual computer's application. The secondary URL initiates a web-based NICE DCV session to the virtual computer's operating session.
     *
     * Use `StartGUISession` to open the session.
     */
    public suspend fun createGuiSessionAccessDetails(input: CreateGuiSessionAccessDetailsRequest): CreateGuiSessionAccessDetailsResponse

    /**
     * Creates a snapshot of a specific virtual private server, or *instance*. You can use a snapshot to create a new instance that is based on that snapshot.
     *
     * The `create instance snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createInstanceSnapshot(input: CreateInstanceSnapshotRequest): CreateInstanceSnapshotResponse

    /**
     * Creates one or more Amazon Lightsail instances.
     *
     * The `create instances` operation supports tag-based access control via request tags. For more information, see the [Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createInstances(input: CreateInstancesRequest): CreateInstancesResponse

    /**
     * Creates one or more new instances from a manual or automatic snapshot of an instance.
     *
     * The `create instances from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `instance snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createInstancesFromSnapshot(input: CreateInstancesFromSnapshotRequest): CreateInstancesFromSnapshotResponse

    /**
     * Creates a custom SSH key pair that you can use with an Amazon Lightsail instance.
     *
     * Use the [DownloadDefaultKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DownloadDefaultKeyPair.html) action to create a Lightsail default key pair in an Amazon Web Services Region where a default key pair does not currently exist.
     *
     * The `create key pair` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createKeyPair(input: CreateKeyPairRequest): CreateKeyPairResponse

    /**
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see [Configure your Lightsail instances for load balancing](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/configure-lightsail-instances-for-load-balancing). You can create up to 5 load balancers per AWS Region in your account.
     *
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load balancer settings, use the `UpdateLoadBalancerAttribute` operation.
     *
     * The `create load balancer` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse

    /**
     * Creates an SSL/TLS certificate for an Amazon Lightsail load balancer.
     *
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     *
     * The `CreateLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createLoadBalancerTlsCertificate(input: CreateLoadBalancerTlsCertificateRequest): CreateLoadBalancerTlsCertificateResponse

    /**
     * Creates a new database in Amazon Lightsail.
     *
     * The `create relational database` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createRelationalDatabase(input: CreateRelationalDatabaseRequest): CreateRelationalDatabaseResponse

    /**
     * Creates a new database from an existing database snapshot in Amazon Lightsail.
     *
     * You can create a new database from a snapshot in if something goes wrong with your original database, or to change it to a different plan, such as a high availability or standard plan.
     *
     * The `create relational database from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by relationalDatabaseSnapshotName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createRelationalDatabaseFromSnapshot(input: CreateRelationalDatabaseFromSnapshotRequest): CreateRelationalDatabaseFromSnapshotResponse

    /**
     * Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a database, and to save data before deleting a database.
     *
     * The `create relational database snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun createRelationalDatabaseSnapshot(input: CreateRelationalDatabaseSnapshotRequest): CreateRelationalDatabaseSnapshotResponse

    /**
     * Deletes an alarm.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     */
    public suspend fun deleteAlarm(input: DeleteAlarmRequest): DeleteAlarmResponse

    /**
     * Deletes an automatic snapshot of an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public suspend fun deleteAutoSnapshot(input: DeleteAutoSnapshotRequest): DeleteAutoSnapshotResponse

    /**
     * Deletes a Amazon Lightsail bucket.
     *
     * When you delete your bucket, the bucket name is released and can be reused for a new bucket in your account or another Amazon Web Services account.
     */
    public suspend fun deleteBucket(input: DeleteBucketRequest): DeleteBucketResponse

    /**
     * Deletes an access key for the specified Amazon Lightsail bucket.
     *
     * We recommend that you delete an access key if the secret access key is compromised.
     *
     * For more information about access keys, see [Creating access keys for a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys) in the *Amazon Lightsail Developer Guide*.
     */
    public suspend fun deleteBucketAccessKey(input: DeleteBucketAccessKeyRequest): DeleteBucketAccessKeyResponse

    /**
     * Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * Certificates that are currently attached to a distribution cannot be deleted. Use the `DetachCertificateFromDistribution` action to detach a certificate from a distribution.
     */
    public suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse

    /**
     * Deletes a contact method.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    public suspend fun deleteContactMethod(input: DeleteContactMethodRequest): DeleteContactMethodResponse

    /**
     * Deletes a container image that is registered to your Amazon Lightsail container service.
     */
    public suspend fun deleteContainerImage(input: DeleteContainerImageRequest): DeleteContainerImageResponse

    /**
     * Deletes your Amazon Lightsail container service.
     */
    public suspend fun deleteContainerService(input: DeleteContainerServiceRequest): DeleteContainerServiceResponse

    /**
     * Deletes the specified block storage disk. The disk must be in the `available` state (not attached to a Lightsail instance).
     *
     * The disk may remain in the `deleting` state for several minutes.
     *
     * The `delete disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteDisk(input: DeleteDiskRequest): DeleteDiskResponse

    /**
     * Deletes the specified disk snapshot.
     *
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the disk.
     *
     * The `delete disk snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `disk snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteDiskSnapshot(input: DeleteDiskSnapshotRequest): DeleteDiskSnapshotResponse

    /**
     * Deletes your Amazon Lightsail content delivery network (CDN) distribution.
     */
    public suspend fun deleteDistribution(input: DeleteDistributionRequest = DeleteDistributionRequest { }): DeleteDistributionResponse

    /**
     * Deletes the specified domain recordset and all of its domain records.
     *
     * The `delete domain` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Deletes a specific domain entry.
     *
     * The `delete domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteDomainEntry(input: DeleteDomainEntryRequest): DeleteDomainEntryResponse

    /**
     * Deletes an Amazon Lightsail instance.
     *
     * The `delete instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse

    /**
     * Deletes a specific snapshot of a virtual private server (or *instance*).
     *
     * The `delete instance snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `instance snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteInstanceSnapshot(input: DeleteInstanceSnapshotRequest): DeleteInstanceSnapshotResponse

    /**
     * Deletes the specified key pair by removing the public key from Amazon Lightsail.
     *
     * You can delete key pairs that were created using the [ImportKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_ImportKeyPair.html) and [CreateKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateKeyPair.html) actions, as well as the Lightsail default key pair. A new default key pair will not be created unless you launch an instance without specifying a custom key pair, or you call the [DownloadDefaultKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DownloadDefaultKeyPair.html) API.
     *
     * The `delete key pair` operation supports tag-based access control via resource tags applied to the resource identified by `key pair name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteKeyPair(input: DeleteKeyPairRequest): DeleteKeyPairResponse

    /**
     * Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the instance after a host key mismatch.
     *
     * Perform this operation only if you were expecting the host key or certificate mismatch or if you are familiar with the new host key or certificate on the instance. For more information, see [Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP client](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection).
     */
    public suspend fun deleteKnownHostKeys(input: DeleteKnownHostKeysRequest): DeleteKnownHostKeysResponse

    /**
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted, you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     *
     * The `delete load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse

    /**
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     *
     * The `DeleteLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteLoadBalancerTlsCertificate(input: DeleteLoadBalancerTlsCertificateRequest): DeleteLoadBalancerTlsCertificateResponse

    /**
     * Deletes a database in Amazon Lightsail.
     *
     * The `delete relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteRelationalDatabase(input: DeleteRelationalDatabaseRequest): DeleteRelationalDatabaseResponse

    /**
     * Deletes a database snapshot in Amazon Lightsail.
     *
     * The `delete relational database snapshot` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun deleteRelationalDatabaseSnapshot(input: DeleteRelationalDatabaseSnapshotRequest): DeleteRelationalDatabaseSnapshotResponse

    /**
     * Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * After the certificate is detached, your distribution stops accepting traffic for all of the domains that are associated with the certificate.
     */
    public suspend fun detachCertificateFromDistribution(input: DetachCertificateFromDistributionRequest): DetachCertificateFromDistributionResponse

    /**
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the device within your operating system before stopping the instance and detaching the disk.
     *
     * The `detach disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun detachDisk(input: DetachDiskRequest): DetachDiskResponse

    /**
     * Detaches the specified instances from a Lightsail load balancer.
     *
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     *
     * The `detach instances from load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun detachInstancesFromLoadBalancer(input: DetachInstancesFromLoadBalancerRequest): DetachInstancesFromLoadBalancerResponse

    /**
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     */
    public suspend fun detachStaticIp(input: DetachStaticIpRequest): DetachStaticIpResponse

    /**
     * Disables an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public suspend fun disableAddOn(input: DisableAddOnRequest): DisableAddOnResponse

    /**
     * Downloads the regional Amazon Lightsail default key pair.
     *
     * This action also creates a Lightsail default key pair if a default key pair does not currently exist in the Amazon Web Services Region.
     */
    public suspend fun downloadDefaultKeyPair(input: DownloadDefaultKeyPairRequest = DownloadDefaultKeyPairRequest { }): DownloadDefaultKeyPairResponse

    /**
     * Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public suspend fun enableAddOn(input: EnableAddOnRequest): EnableAddOnResponse

    /**
     * Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2). This operation results in an export snapshot record that can be used with the `create cloud formation stack` operation to create new Amazon EC2 instances.
     *
     * Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the instance system disk appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the source Lightsail snapshot.
     *
     * The `export snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `source snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     *
     * Use the `get instance snapshots` or `get disk snapshots` operations to get a list of snapshots that you can export to Amazon EC2.
     */
    public suspend fun exportSnapshot(input: ExportSnapshotRequest): ExportSnapshotResponse

    /**
     * Returns the names of all active (not deleted) resources.
     */
    public suspend fun getActiveNames(input: GetActiveNamesRequest = GetActiveNamesRequest { }): GetActiveNamesResponse

    /**
     * Returns information about the configured alarms. Specify an alarm name in your request to return information about a specific alarm, or specify a monitored resource name to return information about all alarms for a specific resource.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     */
    public suspend fun getAlarms(input: GetAlarmsRequest = GetAlarmsRequest { }): GetAlarmsResponse

    /**
     * Returns the available automatic snapshots for an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public suspend fun getAutoSnapshots(input: GetAutoSnapshotsRequest): GetAutoSnapshotsResponse

    /**
     * Returns the list of available instance images, or *blueprints*. You can use a blueprint to create a new instance already running a specific operating system, as well as a preinstalled app or development stack. The software each instance is running depends on the blueprint image you choose.
     *
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.
     */
    public suspend fun getBlueprints(input: GetBlueprintsRequest = GetBlueprintsRequest { }): GetBlueprintsResponse

    /**
     * Returns the existing access key IDs for the specified Amazon Lightsail bucket.
     *
     * This action does not return the secret access key value of an access key. You can get a secret access key only when you create it from the response of the [CreateBucketAccessKey](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html) action. If you lose the secret access key, you must create a new access key.
     */
    public suspend fun getBucketAccessKeys(input: GetBucketAccessKeysRequest): GetBucketAccessKeysResponse

    /**
     * Returns the bundles that you can apply to a Amazon Lightsail bucket.
     *
     * The bucket bundle specifies the monthly cost, storage quota, and data transfer quota for a bucket.
     *
     * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to update the bundle for a bucket.
     */
    public suspend fun getBucketBundles(input: GetBucketBundlesRequest = GetBucketBundlesRequest { }): GetBucketBundlesResponse

    /**
     * Returns the data points of a specific metric for an Amazon Lightsail bucket.
     *
     * Metrics report the utilization of a bucket. View and collect metric data regularly to monitor the number of objects stored in a bucket (including object versions) and the storage space used by those objects.
     */
    public suspend fun getBucketMetricData(input: GetBucketMetricDataRequest): GetBucketMetricDataResponse

    /**
     * Returns information about one or more Amazon Lightsail buckets. The information returned includes the synchronization status of the Amazon Simple Storage Service (Amazon S3) account-level block public access feature for your Lightsail buckets.
     *
     * For more information about buckets, see [Buckets in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
     */
    public suspend fun getBuckets(input: GetBucketsRequest = GetBucketsRequest { }): GetBucketsResponse

    /**
     * Returns the bundles that you can apply to an Amazon Lightsail instance when you create it.
     *
     * A bundle describes the specifications of an instance, such as the monthly cost, amount of memory, the number of vCPUs, amount of storage space, and monthly network data transfer quota.
     *
     * Bundles are referred to as *instance plans* in the Lightsail console.
     */
    public suspend fun getBundles(input: GetBundlesRequest = GetBundlesRequest { }): GetBundlesResponse

    /**
     * Returns information about one or more Amazon Lightsail SSL/TLS certificates.
     *
     * To get a summary of a certificate, omit `includeCertificateDetails` from your request. The response will include only the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.
     */
    public suspend fun getCertificates(input: GetCertificatesRequest = GetCertificatesRequest { }): GetCertificatesResponse

    /**
     * Returns the CloudFormation stack record created as a result of the `create cloud formation stack` operation.
     *
     * An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail snapshot.
     */
    public suspend fun getCloudFormationStackRecords(input: GetCloudFormationStackRecordsRequest = GetCloudFormationStackRecordsRequest { }): GetCloudFormationStackRecordsResponse

    /**
     * Returns information about the configured contact methods. Specify a protocol in your request to return information about a specific contact method.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     */
    public suspend fun getContactMethods(input: GetContactMethodsRequest = GetContactMethodsRequest { }): GetContactMethodsResponse

    /**
     * Returns information about Amazon Lightsail containers, such as the current version of the Lightsail Control (lightsailctl) plugin.
     */
    public suspend fun getContainerApiMetadata(input: GetContainerApiMetadataRequest = GetContainerApiMetadataRequest { }): GetContainerApiMetadataResponse

    /**
     * Returns the container images that are registered to your Amazon Lightsail container service.
     *
     * If you created a deployment on your Lightsail container service that uses container images from a public registry like Docker Hub, those images are not returned as part of this action. Those images are not registered to your Lightsail container service.
     */
    public suspend fun getContainerImages(input: GetContainerImagesRequest): GetContainerImagesResponse

    /**
     * Returns the log events of a container of your Amazon Lightsail container service.
     *
     * If your container service has more than one node (i.e., a scale greater than 1), then the log events that are returned for the specified container are merged from all nodes on your container service.
     *
     * Container logs are retained for a certain amount of time. For more information, see [Amazon Lightsail endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in the *Amazon Web Services General Reference*.
     */
    public suspend fun getContainerLog(input: GetContainerLogRequest): GetContainerLogResponse

    /**
     * Returns the deployments for your Amazon Lightsail container service
     *
     * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to your container service.
     *
     * The deployments are ordered by version in ascending order. The newest version is listed at the top of the response.
     *
     * A set number of deployments are kept before the oldest one is replaced with the newest one. For more information, see [Amazon Lightsail endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in the *Amazon Web Services General Reference*.
     */
    public suspend fun getContainerServiceDeployments(input: GetContainerServiceDeploymentsRequest): GetContainerServiceDeploymentsResponse

    /**
     * Returns the data points of a specific metric of your Amazon Lightsail container service.
     *
     * Metrics report the utilization of your resources. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    public suspend fun getContainerServiceMetricData(input: GetContainerServiceMetricDataRequest): GetContainerServiceMetricDataResponse

    /**
     * Returns the list of powers that can be specified for your Amazon Lightsail container services.
     *
     * The power specifies the amount of memory, the number of vCPUs, and the base price of the container service.
     */
    public suspend fun getContainerServicePowers(input: GetContainerServicePowersRequest = GetContainerServicePowersRequest { }): GetContainerServicePowersResponse

    /**
     * Returns information about one or more of your Amazon Lightsail container services.
     */
    public suspend fun getContainerServices(input: GetContainerServicesRequest = GetContainerServicesRequest { }): GetContainerServicesResponse

    /**
     * Retrieves information about the cost estimate for a specified resource. A cost estimate will not generate for a resource that has been deleted.
     */
    public suspend fun getCostEstimate(input: GetCostEstimateRequest): GetCostEstimateResponse

    /**
     * Returns information about a specific block storage disk.
     */
    public suspend fun getDisk(input: GetDiskRequest): GetDiskResponse

    /**
     * Returns information about a specific block storage disk snapshot.
     */
    public suspend fun getDiskSnapshot(input: GetDiskSnapshotRequest): GetDiskSnapshotResponse

    /**
     * Returns information about all block storage disk snapshots in your AWS account and region.
     */
    public suspend fun getDiskSnapshots(input: GetDiskSnapshotsRequest = GetDiskSnapshotsRequest { }): GetDiskSnapshotsResponse

    /**
     * Returns information about all block storage disks in your AWS account and region.
     */
    public suspend fun getDisks(input: GetDisksRequest = GetDisksRequest { }): GetDisksResponse

    /**
     * Returns the bundles that can be applied to your Amazon Lightsail content delivery network (CDN) distributions.
     *
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your distribution.
     */
    public suspend fun getDistributionBundles(input: GetDistributionBundlesRequest = GetDistributionBundlesRequest { }): GetDistributionBundlesResponse

    /**
     * Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail content delivery network (CDN) distribution.
     */
    public suspend fun getDistributionLatestCacheReset(input: GetDistributionLatestCacheResetRequest = GetDistributionLatestCacheResetRequest { }): GetDistributionLatestCacheResetResponse

    /**
     * Returns the data points of a specific metric for an Amazon Lightsail content delivery network (CDN) distribution.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    public suspend fun getDistributionMetricData(input: GetDistributionMetricDataRequest): GetDistributionMetricDataResponse

    /**
     * Returns information about one or more of your Amazon Lightsail content delivery network (CDN) distributions.
     */
    public suspend fun getDistributions(input: GetDistributionsRequest = GetDistributionsRequest { }): GetDistributionsResponse

    /**
     * Returns information about a specific domain recordset.
     */
    public suspend fun getDomain(input: GetDomainRequest): GetDomainResponse

    /**
     * Returns a list of all domains in the user's account.
     */
    public suspend fun getDomains(input: GetDomainsRequest = GetDomainsRequest { }): GetDomainsResponse

    /**
     * Returns all export snapshot records created as a result of the `export snapshot` operation.
     *
     * An export snapshot record can be used to create a new Amazon EC2 instance and its related resources with the [CreateCloudFormationStack](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateCloudFormationStack.html) action.
     */
    public suspend fun getExportSnapshotRecords(input: GetExportSnapshotRecordsRequest = GetExportSnapshotRecordsRequest { }): GetExportSnapshotRecordsResponse

    /**
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     */
    public suspend fun getInstance(input: GetInstanceRequest): GetInstanceResponse

    /**
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or *instance*.
     *
     * The `get instance access details` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun getInstanceAccessDetails(input: GetInstanceAccessDetailsRequest): GetInstanceAccessDetailsResponse

    /**
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    public suspend fun getInstanceMetricData(input: GetInstanceMetricDataRequest): GetInstanceMetricDataResponse

    /**
     * Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses allowed to connect to the instance through the ports, and the protocol.
     */
    public suspend fun getInstancePortStates(input: GetInstancePortStatesRequest): GetInstancePortStatesResponse

    /**
     * Returns information about a specific instance snapshot.
     */
    public suspend fun getInstanceSnapshot(input: GetInstanceSnapshotRequest): GetInstanceSnapshotResponse

    /**
     * Returns all instance snapshots for the user's account.
     */
    public suspend fun getInstanceSnapshots(input: GetInstanceSnapshotsRequest = GetInstanceSnapshotsRequest { }): GetInstanceSnapshotsResponse

    /**
     * Returns the state of a specific instance. Works on one instance at a time.
     */
    public suspend fun getInstanceState(input: GetInstanceStateRequest): GetInstanceStateResponse

    /**
     * Returns information about all Amazon Lightsail virtual private servers, or *instances*.
     */
    public suspend fun getInstances(input: GetInstancesRequest = GetInstancesRequest { }): GetInstancesResponse

    /**
     * Returns information about a specific key pair.
     */
    public suspend fun getKeyPair(input: GetKeyPairRequest): GetKeyPairResponse

    /**
     * Returns information about all key pairs in the user's account.
     */
    public suspend fun getKeyPairs(input: GetKeyPairsRequest = GetKeyPairsRequest { }): GetKeyPairsResponse

    /**
     * Returns information about the specified Lightsail load balancer.
     */
    public suspend fun getLoadBalancer(input: GetLoadBalancerRequest): GetLoadBalancerResponse

    /**
     * Returns information about health metrics for your Lightsail load balancer.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    public suspend fun getLoadBalancerMetricData(input: GetLoadBalancerMetricDataRequest): GetLoadBalancerMetricDataResponse

    /**
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     *
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     *
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other is inactive.
     */
    public suspend fun getLoadBalancerTlsCertificates(input: GetLoadBalancerTlsCertificatesRequest): GetLoadBalancerTlsCertificatesResponse

    /**
     * Returns a list of TLS security policies that you can apply to Lightsail load balancers.
     *
     * For more information about load balancer TLS security policies, see [Configuring TLS security policies on your Amazon Lightsail load balancers](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configure-load-balancer-tls-security-policy) in the *Amazon Lightsail Developer Guide*.
     */
    public suspend fun getLoadBalancerTlsPolicies(input: GetLoadBalancerTlsPoliciesRequest = GetLoadBalancerTlsPoliciesRequest { }): GetLoadBalancerTlsPoliciesResponse

    /**
     * Returns information about all load balancers in an account.
     */
    public suspend fun getLoadBalancers(input: GetLoadBalancersRequest = GetLoadBalancersRequest { }): GetLoadBalancersResponse

    /**
     * Returns information about a specific operation. Operations include events such as when you create an instance, allocate a static IP, attach a static IP, and so on.
     */
    public suspend fun getOperation(input: GetOperationRequest): GetOperationResponse

    /**
     * Returns information about all operations.
     *
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each subsequent call to `GetOperations` use the maximum (last) `statusChangedAt` value from the previous request.
     */
    public suspend fun getOperations(input: GetOperationsRequest = GetOperationsRequest { }): GetOperationsResponse

    /**
     * Gets operations for a specific resource (an instance or a static IP).
     */
    public suspend fun getOperationsForResource(input: GetOperationsForResourceRequest): GetOperationsForResourceResponse

    /**
     * Returns a list of all valid regions for Amazon Lightsail. Use the `include availability zones` parameter to also return the Availability Zones in a region.
     */
    public suspend fun getRegions(input: GetRegionsRequest = GetRegionsRequest { }): GetRegionsResponse

    /**
     * Returns information about a specific database in Amazon Lightsail.
     */
    public suspend fun getRelationalDatabase(input: GetRelationalDatabaseRequest): GetRelationalDatabaseResponse

    /**
     * Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine version of a database.
     *
     * You can use a blueprint ID to create a new database that runs a specific database engine.
     */
    public suspend fun getRelationalDatabaseBlueprints(input: GetRelationalDatabaseBlueprintsRequest = GetRelationalDatabaseBlueprintsRequest { }): GetRelationalDatabaseBlueprintsResponse

    /**
     * Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance specifications for a database.
     *
     * You can use a bundle ID to create a new database with explicit performance specifications.
     */
    public suspend fun getRelationalDatabaseBundles(input: GetRelationalDatabaseBundlesRequest = GetRelationalDatabaseBundlesRequest { }): GetRelationalDatabaseBundlesResponse

    /**
     * Returns a list of events for a specific database in Amazon Lightsail.
     */
    public suspend fun getRelationalDatabaseEvents(input: GetRelationalDatabaseEventsRequest): GetRelationalDatabaseEventsResponse

    /**
     * Returns a list of log events for a database in Amazon Lightsail.
     */
    public suspend fun getRelationalDatabaseLogEvents(input: GetRelationalDatabaseLogEventsRequest): GetRelationalDatabaseLogEventsResponse

    /**
     * Returns a list of available log streams for a specific database in Amazon Lightsail.
     */
    public suspend fun getRelationalDatabaseLogStreams(input: GetRelationalDatabaseLogStreamsRequest): GetRelationalDatabaseLogStreamsResponse

    /**
     * Returns the current, previous, or pending versions of the master user password for a Lightsail database.
     *
     * The `GetRelationalDatabaseMasterUserPassword` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName.
     */
    public suspend fun getRelationalDatabaseMasterUserPassword(input: GetRelationalDatabaseMasterUserPasswordRequest): GetRelationalDatabaseMasterUserPasswordResponse

    /**
     * Returns the data points of the specified metric for a database in Amazon Lightsail.
     *
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
     */
    public suspend fun getRelationalDatabaseMetricData(input: GetRelationalDatabaseMetricDataRequest): GetRelationalDatabaseMetricDataResponse

    /**
     * Returns all of the runtime parameters offered by the underlying database software, or engine, for a specific database in Amazon Lightsail.
     *
     * In addition to the parameter names and values, this operation returns other information about each parameter. This information includes whether changes require a reboot, whether the parameter is modifiable, the allowed values, and the data types.
     */
    public suspend fun getRelationalDatabaseParameters(input: GetRelationalDatabaseParametersRequest): GetRelationalDatabaseParametersResponse

    /**
     * Returns information about a specific database snapshot in Amazon Lightsail.
     */
    public suspend fun getRelationalDatabaseSnapshot(input: GetRelationalDatabaseSnapshotRequest): GetRelationalDatabaseSnapshotResponse

    /**
     * Returns information about all of your database snapshots in Amazon Lightsail.
     */
    public suspend fun getRelationalDatabaseSnapshots(input: GetRelationalDatabaseSnapshotsRequest = GetRelationalDatabaseSnapshotsRequest { }): GetRelationalDatabaseSnapshotsResponse

    /**
     * Returns information about all of your databases in Amazon Lightsail.
     */
    public suspend fun getRelationalDatabases(input: GetRelationalDatabasesRequest = GetRelationalDatabasesRequest { }): GetRelationalDatabasesResponse

    /**
     * Returns detailed information for five of the most recent `SetupInstanceHttps` requests that were ran on the target instance.
     */
    public suspend fun getSetupHistory(input: GetSetupHistoryRequest): GetSetupHistoryResponse

    /**
     * Returns information about an Amazon Lightsail static IP.
     */
    public suspend fun getStaticIp(input: GetStaticIpRequest): GetStaticIpResponse

    /**
     * Returns information about all static IPs in the user's account.
     */
    public suspend fun getStaticIps(input: GetStaticIpsRequest = GetStaticIpsRequest { }): GetStaticIpsResponse

    /**
     * Imports a public SSH key from a specific key pair.
     */
    public suspend fun importKeyPair(input: ImportKeyPairRequest): ImportKeyPairResponse

    /**
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     */
    public suspend fun isVpcPeered(input: IsVpcPeeredRequest = IsVpcPeeredRequest { }): IsVpcPeeredResponse

    /**
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.
     *
     * The `OpenInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun openInstancePublicPorts(input: OpenInstancePublicPortsRequest): OpenInstancePublicPortsResponse

    /**
     * Peers the Lightsail VPC with the user's default VPC.
     */
    public suspend fun peerVpc(input: PeerVpcRequest = PeerVpcRequest { }): PeerVpcResponse

    /**
     * Creates or updates an alarm, and associates it with the specified metric.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     *
     * When this action creates an alarm, the alarm state is immediately set to `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed.
     *
     * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm. The alarm is then evaluated with the updated configuration.
     */
    public suspend fun putAlarm(input: PutAlarmRequest): PutAlarmResponse

    /**
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol. This action also closes all currently open ports that are not included in the request. Include all of the ports and the protocols you want to open in your `PutInstancePublicPorts`request. Or use the `OpenInstancePublicPorts` action to open ports without closing currently open ports.
     *
     * The `PutInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun putInstancePublicPorts(input: PutInstancePublicPortsRequest): PutInstancePublicPortsResponse

    /**
     * Restarts a specific instance.
     *
     * The `reboot instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun rebootInstance(input: RebootInstanceRequest): RebootInstanceResponse

    /**
     * Restarts a specific database in Amazon Lightsail.
     *
     * The `reboot relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun rebootRelationalDatabase(input: RebootRelationalDatabaseRequest): RebootRelationalDatabaseResponse

    /**
     * Registers a container image to your Amazon Lightsail container service.
     *
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container images to your Lightsail container service. For more information, see [Pushing and managing container images on your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images) in the *Amazon Lightsail Developer Guide*.
     */
    public suspend fun registerContainerImage(input: RegisterContainerImageRequest): RegisterContainerImageResponse

    /**
     * Deletes a specific static IP from your account.
     */
    public suspend fun releaseStaticIp(input: ReleaseStaticIpRequest): ReleaseStaticIpResponse

    /**
     * Deletes currently cached content from your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * After resetting the cache, the next time a content request is made, your distribution pulls, serves, and caches it from the origin.
     */
    public suspend fun resetDistributionCache(input: ResetDistributionCacheRequest = ResetDistributionCacheRequest { }): ResetDistributionCacheResponse

    /**
     * Sends a verification request to an email contact method to ensure it's owned by the requester. SMS contact methods don't need to be verified.
     *
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
     *
     * A verification request is sent to the contact method when you initially create it. Use this action to send another verification request if a previous verification request was deleted, or has expired.
     *
     * Notifications are not sent to an email contact method until after it is verified, and confirmed as valid.
     */
    public suspend fun sendContactMethodVerification(input: SendContactMethodVerificationRequest): SendContactMethodVerificationResponse

    /**
     * Sets the IP address type for an Amazon Lightsail resource.
     *
     * Use this action to enable dual-stack for a resource, which enables IPv4 and IPv6 for the specified resource. Alternately, you can use this action to disable dual-stack, and enable IPv4 only.
     */
    public suspend fun setIpAddressType(input: SetIpAddressTypeRequest): SetIpAddressTypeResponse

    /**
     * Sets the Amazon Lightsail resources that can access the specified Lightsail bucket.
     *
     * Lightsail buckets currently support setting access for Lightsail instances in the same Amazon Web Services Region.
     */
    public suspend fun setResourceAccessForBucket(input: SetResourceAccessForBucketRequest): SetResourceAccessForBucketResponse

    /**
     * Creates an SSL/TLS certificate that secures traffic for your website. After the certificate is created, it is installed on the specified Lightsail instance.
     *
     * If you provide more than one domain name in the request, at least one name must be less than or equal to 63 characters in length.
     */
    public suspend fun setupInstanceHttps(input: SetupInstanceHttpsRequest): SetupInstanceHttpsResponse

    /**
     * Initiates a graphical user interface (GUI) session that’s used to access a virtual computer’s operating system and application. The session will be active for 1 hour. Use this action to resume the session after it expires.
     */
    public suspend fun startGuiSession(input: StartGuiSessionRequest): StartGuiSessionResponse

    /**
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the `reboot instance` operation.
     *
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
     *
     * The `start instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun startInstance(input: StartInstanceRequest): StartInstanceResponse

    /**
     * Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the `reboot relational database` operation.
     *
     * The `start relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun startRelationalDatabase(input: StartRelationalDatabaseRequest): StartRelationalDatabaseResponse

    /**
     * Terminates a web-based NICE DCV session that’s used to access a virtual computer’s operating system or application. The session will close and any unsaved data will be lost.
     */
    public suspend fun stopGuiSession(input: StopGuiSessionRequest): StopGuiSessionResponse

    /**
     * Stops a specific Amazon Lightsail instance that is currently running.
     *
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
     *
     * The `stop instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun stopInstance(input: StopInstanceRequest): StopInstanceResponse

    /**
     * Stops a specific database that is currently running in Amazon Lightsail.
     *
     * The `stop relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun stopRelationalDatabase(input: StopRelationalDatabaseRequest): StopRelationalDatabaseResponse

    /**
     * Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     *
     * The `tag resource` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `resource name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured for the specified alarm, the test also sends a notification to the notification protocol (`Email` and/or `SMS`) configured for the alarm.
     *
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
     */
    public suspend fun testAlarm(input: TestAlarmRequest): TestAlarmResponse

    /**
     * Unpeers the Lightsail VPC from the user's default VPC.
     */
    public suspend fun unpeerVpc(input: UnpeerVpcRequest = UnpeerVpcRequest { }): UnpeerVpcResponse

    /**
     * Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource.
     *
     * The `untag resource` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `resource name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Amazon Lightsail bucket.
     *
     * Use this action to update the configuration of an existing bucket, such as versioning, public accessibility, and the Amazon Web Services accounts that can access the bucket.
     */
    public suspend fun updateBucket(input: UpdateBucketRequest): UpdateBucketResponse

    /**
     * Updates the bundle, or storage plan, of an existing Amazon Lightsail bucket.
     *
     * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket. You can update a bucket's bundle only one time within a monthly Amazon Web Services billing cycle. To determine if you can update a bucket's bundle, use the [GetBuckets](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html) action. The `ableToUpdateBundle` parameter in the response will indicate whether you can currently update a bucket's bundle.
     *
     * Update a bucket's bundle if it's consistently going over its storage space or data transfer quota, or if a bucket's usage is consistently in the lower range of its storage space or data transfer quota. Due to the unpredictable usage fluctuations that a bucket might experience, we strongly recommend that you update a bucket's bundle only as a long-term strategy, instead of as a short-term, monthly cost-cutting measure. Choose a bucket bundle that will provide the bucket with ample storage space and data transfer for a long time to come.
     */
    public suspend fun updateBucketBundle(input: UpdateBucketBundleRequest): UpdateBucketBundleResponse

    /**
     * Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain names.
     */
    public suspend fun updateContainerService(input: UpdateContainerServiceRequest): UpdateContainerServiceResponse

    /**
     * Updates an existing Amazon Lightsail content delivery network (CDN) distribution.
     *
     * Use this action to update the configuration of your existing distribution.
     */
    public suspend fun updateDistribution(input: UpdateDistributionRequest): UpdateDistributionResponse

    /**
     * Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution.
     *
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your distribution.
     *
     * Update your distribution's bundle if your distribution is going over its monthly network transfer quota and is incurring an overage fee.
     *
     * You can update your distribution's bundle only one time within your monthly Amazon Web Services billing cycle. To determine if you can update your distribution's bundle, use the `GetDistributions` action. The `ableToUpdateBundle` parameter in the result will indicate whether you can currently update your distribution's bundle.
     */
    public suspend fun updateDistributionBundle(input: UpdateDistributionBundleRequest = UpdateDistributionBundleRequest { }): UpdateDistributionBundleResponse

    /**
     * Updates a domain recordset after it is created.
     *
     * The `update domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun updateDomainEntry(input: UpdateDomainEntryRequest): UpdateDomainEntryResponse

    /**
     * Modifies the Amazon Lightsail instance metadata parameters on a running or stopped instance. When you modify the parameters on a running instance, the `GetInstance` or `GetInstances` API operation initially responds with a state of `pending`. After the parameter modifications are successfully applied, the state changes to `applied` in subsequent `GetInstance` or `GetInstances` API calls. For more information, see [Use IMDSv2 with an Amazon Lightsail instance](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-instance-metadata-service) in the *Amazon Lightsail Developer Guide*.
     */
    public suspend fun updateInstanceMetadataOptions(input: UpdateInstanceMetadataOptionsRequest): UpdateInstanceMetadataOptionsResponse

    /**
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     *
     * The `update load balancer attribute` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun updateLoadBalancerAttribute(input: UpdateLoadBalancerAttributeRequest): UpdateLoadBalancerAttributeResponse

    /**
     * Allows the update of one or more attributes of a database in Amazon Lightsail.
     *
     * Updates are applied immediately, or in cases where the updates could result in an outage, are applied during the database's predefined maintenance window.
     *
     * The `update relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun updateRelationalDatabase(input: UpdateRelationalDatabaseRequest): UpdateRelationalDatabaseResponse

    /**
     * Allows the update of one or more parameters of a database in Amazon Lightsail.
     *
     * Parameter updates don't cause outages; therefore, their application is not subject to the preferred maintenance window. However, there are two ways in which parameter updates are applied: `dynamic` or `pending-reboot`. Parameters marked with a `dynamic` apply type are applied immediately. Parameters marked with a `pending-reboot` apply type are applied only after the database is rebooted using the `reboot relational database` operation.
     *
     * The `update relational database parameters` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
     */
    public suspend fun updateRelationalDatabaseParameters(input: UpdateRelationalDatabaseParametersRequest): UpdateRelationalDatabaseParametersResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun LightsailClient.withConfig(block: LightsailClient.Config.Builder.() -> Unit): LightsailClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultLightsailClient(newConfig)
}

/**
 * Allocates a static IP address.
 */
public suspend inline fun LightsailClient.allocateStaticIp(crossinline block: AllocateStaticIpRequest.Builder.() -> Unit): AllocateStaticIpResponse = allocateStaticIp(AllocateStaticIpRequest.Builder().apply(block).build())

/**
 * Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN) distribution.
 *
 * After the certificate is attached, your distribution accepts HTTPS traffic for all of the domains that are associated with the certificate.
 *
 * Use the `CreateCertificate` action to create a certificate that you can attach to your distribution.
 *
 * Only certificates created in the `us-east-1` Amazon Web Services Region can be attached to Lightsail distributions. Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
 */
public suspend inline fun LightsailClient.attachCertificateToDistribution(crossinline block: AttachCertificateToDistributionRequest.Builder.() -> Unit): AttachCertificateToDistributionResponse = attachCertificateToDistribution(AttachCertificateToDistributionRequest.Builder().apply(block).build())

/**
 * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the specified disk name.
 *
 * The `attach disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.attachDisk(crossinline block: AttachDiskRequest.Builder.() -> Unit): AttachDiskResponse = attachDisk(AttachDiskRequest.Builder().apply(block).build())

/**
 * Attaches one or more Lightsail instances to a load balancer.
 *
 * After some time, the instances are attached to the load balancer and the health check status is available.
 *
 * The `attach instances to load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.attachInstancesToLoadBalancer(crossinline block: AttachInstancesToLoadBalancerRequest.Builder.() -> Unit): AttachInstancesToLoadBalancerResponse = attachInstancesToLoadBalancer(AttachInstancesToLoadBalancerRequest.Builder().apply(block).build())

/**
 * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure version of Secure Socket Layer (SSL).
 *
 * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API to rotate the certificates on your account. Use the `AttachLoadBalancerTlsCertificate` action with the non-attached certificate, and it will replace the existing one and become the attached certificate.
 *
 * The `AttachLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.attachLoadBalancerTlsCertificate(crossinline block: AttachLoadBalancerTlsCertificateRequest.Builder.() -> Unit): AttachLoadBalancerTlsCertificateResponse = attachLoadBalancerTlsCertificate(AttachLoadBalancerTlsCertificateRequest.Builder().apply(block).build())

/**
 * Attaches a static IP address to a specific Amazon Lightsail instance.
 */
public suspend inline fun LightsailClient.attachStaticIp(crossinline block: AttachStaticIpRequest.Builder.() -> Unit): AttachStaticIpResponse = attachStaticIp(AttachStaticIpRequest.Builder().apply(block).build())

/**
 * Closes ports for a specific Amazon Lightsail instance.
 *
 * The `CloseInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.closeInstancePublicPorts(crossinline block: CloseInstancePublicPortsRequest.Builder.() -> Unit): CloseInstancePublicPortsResponse = closeInstancePublicPorts(CloseInstancePublicPortsRequest.Builder().apply(block).build())

/**
 * Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of an instance or a disk from one Amazon Web Services Region to another in Amazon Lightsail.
 *
 * When copying a *manual snapshot*, be sure to define the `source region`, `source snapshot name`, and `target snapshot name` parameters.
 *
 * When copying an *automatic snapshot*, be sure to define the `source region`, `source resource name`, `target snapshot name`, and either the `restore date` or the `use latest restorable auto snapshot` parameters.
 */
public suspend inline fun LightsailClient.copySnapshot(crossinline block: CopySnapshotRequest.Builder.() -> Unit): CopySnapshotResponse = copySnapshot(CopySnapshotRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Lightsail bucket.
 *
 * A bucket is a cloud storage resource available in the Lightsail object storage service. Use buckets to store objects such as data and its descriptive metadata. For more information about buckets, see [Buckets in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
 */
public suspend inline fun LightsailClient.createBucket(crossinline block: CreateBucketRequest.Builder.() -> Unit): CreateBucketResponse = createBucket(CreateBucketRequest.Builder().apply(block).build())

/**
 * Creates a new access key for the specified Amazon Lightsail bucket. Access keys consist of an access key ID and corresponding secret access key.
 *
 * Access keys grant full programmatic access to the specified bucket and its objects. You can have a maximum of two access keys per bucket. Use the [GetBucketAccessKeys](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketAccessKeys.html) action to get a list of current access keys for a specific bucket. For more information about access keys, see [Creating access keys for a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys) in the *Amazon Lightsail Developer Guide*.
 *
 * The `secretAccessKey` value is returned only in response to the `CreateBucketAccessKey` action. You can get a secret access key only when you first create an access key; you cannot get the secret access key later. If you lose the secret access key, you must create a new access key.
 */
public suspend inline fun LightsailClient.createBucketAccessKey(crossinline block: CreateBucketAccessKeyRequest.Builder.() -> Unit): CreateBucketAccessKeyResponse = createBucketAccessKey(CreateBucketAccessKeyRequest.Builder().apply(block).build())

/**
 * Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN) distribution and a container service.
 *
 * After the certificate is valid, use the `AttachCertificateToDistribution` action to use the certificate and its domains with your distribution. Or use the `UpdateContainerService` action to use the certificate and its domains with your container service.
 *
 * Only certificates created in the `us-east-1` Amazon Web Services Region can be attached to Lightsail distributions. Lightsail distributions are global resources that can reference an origin in any Amazon Web Services Region, and distribute its content globally. However, all distributions are located in the `us-east-1` Region.
 */
public suspend inline fun LightsailClient.createCertificate(crossinline block: CreateCertificateRequest.Builder.() -> Unit): CreateCertificateResponse = createCertificate(CreateCertificateRequest.Builder().apply(block).build())

/**
 * Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported Amazon Lightsail snapshot. This operation results in a CloudFormation stack record that can be used to track the AWS CloudFormation stack created. Use the `get cloud formation stack records` operation to get a list of the CloudFormation stacks created.
 *
 * Wait until after your new Amazon EC2 instance is created before running the `create cloud formation stack` operation again with the same export snapshot record.
 */
public suspend inline fun LightsailClient.createCloudFormationStack(crossinline block: CreateCloudFormationStackRequest.Builder.() -> Unit): CreateCloudFormationStackResponse = createCloudFormationStack(CreateCloudFormationStackRequest.Builder().apply(block).build())

/**
 * Creates an email or SMS text message contact method.
 *
 * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
 */
public suspend inline fun LightsailClient.createContactMethod(crossinline block: CreateContactMethodRequest.Builder.() -> Unit): CreateContactMethodResponse = createContactMethod(CreateContactMethodRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Lightsail container service.
 *
 * A Lightsail container service is a compute resource to which you can deploy containers. For more information, see [Container services in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services) in the *Lightsail Dev Guide*.
 */
public suspend inline fun LightsailClient.createContainerService(crossinline block: CreateContainerServiceRequest.Builder.() -> Unit): CreateContainerServiceResponse = createContainerService(CreateContainerServiceRequest.Builder().apply(block).build())

/**
 * Creates a deployment for your Amazon Lightsail container service.
 *
 * A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration.
 *
 * You can deploy containers to your container service using container images from a public registry such as Amazon ECR Public, or from your local machine. For more information, see [Creating container images for your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-images) in the *Amazon Lightsail Developer Guide*.
 */
public suspend inline fun LightsailClient.createContainerServiceDeployment(crossinline block: CreateContainerServiceDeploymentRequest.Builder.() -> Unit): CreateContainerServiceDeploymentResponse = createContainerServiceDeployment(CreateContainerServiceDeploymentRequest.Builder().apply(block).build())

/**
 * Creates a temporary set of log in credentials that you can use to log in to the Docker process on your local machine. After you're logged in, you can use the native Docker commands to push your local container images to the container image registry of your Amazon Lightsail account so that you can use them with your Lightsail container service. The log in credentials expire 12 hours after they are created, at which point you will need to create a new set of log in credentials.
 *
 * You can only push container images to the container service registry of your Lightsail account. You cannot pull container images or perform any other container image management actions on the container service registry.
 *
 * After you push your container images to the container image registry of your Lightsail account, use the `RegisterContainerImage` action to register the pushed images to a specific Lightsail container service.
 *
 * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container images to your Lightsail container service. For more information, see [Pushing and managing container images on your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images) in the *Amazon Lightsail Developer Guide*.
 */
public suspend inline fun LightsailClient.createContainerServiceRegistryLogin(crossinline block: CreateContainerServiceRegistryLoginRequest.Builder.() -> Unit): CreateContainerServiceRegistryLoginResponse = createContainerServiceRegistryLogin(CreateContainerServiceRegistryLoginRequest.Builder().apply(block).build())

/**
 * Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone (`us-east-2a`).
 *
 * The `create disk` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createDisk(crossinline block: CreateDiskRequest.Builder.() -> Unit): CreateDiskResponse = createDisk(CreateDiskRequest.Builder().apply(block).build())

/**
 * Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to an Amazon Lightsail instance in the same Availability Zone (`us-east-2a`).
 *
 * The `create disk from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `disk snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createDiskFromSnapshot(crossinline block: CreateDiskFromSnapshotRequest.Builder.() -> Unit): CreateDiskFromSnapshotResponse = createDiskFromSnapshot(CreateDiskFromSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to save data before shutting down a Lightsail instance.
 *
 * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the disk long enough to take a snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the snapshot status is pending.
 *
 * You can also use this operation to create a snapshot of an instance's system volume. You might want to do this, for example, to recover data from the system volume of a botched instance or to create a backup of the system volume like you would for a block storage disk. To create a snapshot of a system volume, just define the `instance name` parameter when issuing the snapshot command, and a snapshot of the defined instance's system volume will be created. After the snapshot is available, you can create a block storage disk from the snapshot and attach it to a running instance to access the data on the disk.
 *
 * The `create disk snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createDiskSnapshot(crossinline block: CreateDiskSnapshotRequest.Builder.() -> Unit): CreateDiskSnapshotResponse = createDiskSnapshot(CreateDiskSnapshotRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Lightsail content delivery network (CDN) distribution.
 *
 * A distribution is a globally distributed network of caching servers that improve the performance of your website or web application hosted on a Lightsail instance. For more information, see [Content delivery networks in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-content-delivery-network-distributions).
 */
public suspend inline fun LightsailClient.createDistribution(crossinline block: CreateDistributionRequest.Builder.() -> Unit): CreateDistributionResponse = createDistribution(CreateDistributionRequest.Builder().apply(block).build())

/**
 * Creates a domain resource for the specified domain (example.com).
 *
 * The `create domain` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createDomain(crossinline block: CreateDomainRequest.Builder.() -> Unit): CreateDomainResponse = createDomain(CreateDomainRequest.Builder().apply(block).build())

/**
 * Creates one of the following domain name system (DNS) records in a domain DNS zone: Address (A), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
 *
 * The `create domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createDomainEntry(crossinline block: CreateDomainEntryRequest.Builder.() -> Unit): CreateDomainEntryResponse = createDomainEntry(CreateDomainEntryRequest.Builder().apply(block).build())

/**
 * Creates two URLs that are used to access a virtual computer’s graphical user interface (GUI) session. The primary URL initiates a web-based NICE DCV session to the virtual computer's application. The secondary URL initiates a web-based NICE DCV session to the virtual computer's operating session.
 *
 * Use `StartGUISession` to open the session.
 */
public suspend inline fun LightsailClient.createGuiSessionAccessDetails(crossinline block: CreateGuiSessionAccessDetailsRequest.Builder.() -> Unit): CreateGuiSessionAccessDetailsResponse = createGuiSessionAccessDetails(CreateGuiSessionAccessDetailsRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of a specific virtual private server, or *instance*. You can use a snapshot to create a new instance that is based on that snapshot.
 *
 * The `create instance snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createInstanceSnapshot(crossinline block: CreateInstanceSnapshotRequest.Builder.() -> Unit): CreateInstanceSnapshotResponse = createInstanceSnapshot(CreateInstanceSnapshotRequest.Builder().apply(block).build())

/**
 * Creates one or more Amazon Lightsail instances.
 *
 * The `create instances` operation supports tag-based access control via request tags. For more information, see the [Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createInstances(crossinline block: CreateInstancesRequest.Builder.() -> Unit): CreateInstancesResponse = createInstances(CreateInstancesRequest.Builder().apply(block).build())

/**
 * Creates one or more new instances from a manual or automatic snapshot of an instance.
 *
 * The `create instances from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `instance snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createInstancesFromSnapshot(crossinline block: CreateInstancesFromSnapshotRequest.Builder.() -> Unit): CreateInstancesFromSnapshotResponse = createInstancesFromSnapshot(CreateInstancesFromSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a custom SSH key pair that you can use with an Amazon Lightsail instance.
 *
 * Use the [DownloadDefaultKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DownloadDefaultKeyPair.html) action to create a Lightsail default key pair in an Amazon Web Services Region where a default key pair does not currently exist.
 *
 * The `create key pair` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createKeyPair(crossinline block: CreateKeyPairRequest.Builder.() -> Unit): CreateKeyPairResponse = createKeyPair(CreateKeyPairRequest.Builder().apply(block).build())

/**
 * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see [Configure your Lightsail instances for load balancing](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/configure-lightsail-instances-for-load-balancing). You can create up to 5 load balancers per AWS Region in your account.
 *
 * When you create a load balancer, you can specify a unique name and port settings. To change additional load balancer settings, use the `UpdateLoadBalancerAttribute` operation.
 *
 * The `create load balancer` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createLoadBalancer(crossinline block: CreateLoadBalancerRequest.Builder.() -> Unit): CreateLoadBalancerResponse = createLoadBalancer(CreateLoadBalancerRequest.Builder().apply(block).build())

/**
 * Creates an SSL/TLS certificate for an Amazon Lightsail load balancer.
 *
 * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
 *
 * The `CreateLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createLoadBalancerTlsCertificate(crossinline block: CreateLoadBalancerTlsCertificateRequest.Builder.() -> Unit): CreateLoadBalancerTlsCertificateResponse = createLoadBalancerTlsCertificate(CreateLoadBalancerTlsCertificateRequest.Builder().apply(block).build())

/**
 * Creates a new database in Amazon Lightsail.
 *
 * The `create relational database` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createRelationalDatabase(crossinline block: CreateRelationalDatabaseRequest.Builder.() -> Unit): CreateRelationalDatabaseResponse = createRelationalDatabase(CreateRelationalDatabaseRequest.Builder().apply(block).build())

/**
 * Creates a new database from an existing database snapshot in Amazon Lightsail.
 *
 * You can create a new database from a snapshot in if something goes wrong with your original database, or to change it to a different plan, such as a high availability or standard plan.
 *
 * The `create relational database from snapshot` operation supports tag-based access control via request tags and resource tags applied to the resource identified by relationalDatabaseSnapshotName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createRelationalDatabaseFromSnapshot(crossinline block: CreateRelationalDatabaseFromSnapshotRequest.Builder.() -> Unit): CreateRelationalDatabaseFromSnapshotResponse = createRelationalDatabaseFromSnapshot(CreateRelationalDatabaseFromSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a database, and to save data before deleting a database.
 *
 * The `create relational database snapshot` operation supports tag-based access control via request tags. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.createRelationalDatabaseSnapshot(crossinline block: CreateRelationalDatabaseSnapshotRequest.Builder.() -> Unit): CreateRelationalDatabaseSnapshotResponse = createRelationalDatabaseSnapshot(CreateRelationalDatabaseSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes an alarm.
 *
 * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
 */
public suspend inline fun LightsailClient.deleteAlarm(crossinline block: DeleteAlarmRequest.Builder.() -> Unit): DeleteAlarmResponse = deleteAlarm(DeleteAlarmRequest.Builder().apply(block).build())

/**
 * Deletes an automatic snapshot of an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
 */
public suspend inline fun LightsailClient.deleteAutoSnapshot(crossinline block: DeleteAutoSnapshotRequest.Builder.() -> Unit): DeleteAutoSnapshotResponse = deleteAutoSnapshot(DeleteAutoSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes a Amazon Lightsail bucket.
 *
 * When you delete your bucket, the bucket name is released and can be reused for a new bucket in your account or another Amazon Web Services account.
 */
public suspend inline fun LightsailClient.deleteBucket(crossinline block: DeleteBucketRequest.Builder.() -> Unit): DeleteBucketResponse = deleteBucket(DeleteBucketRequest.Builder().apply(block).build())

/**
 * Deletes an access key for the specified Amazon Lightsail bucket.
 *
 * We recommend that you delete an access key if the secret access key is compromised.
 *
 * For more information about access keys, see [Creating access keys for a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys) in the *Amazon Lightsail Developer Guide*.
 */
public suspend inline fun LightsailClient.deleteBucketAccessKey(crossinline block: DeleteBucketAccessKeyRequest.Builder.() -> Unit): DeleteBucketAccessKeyResponse = deleteBucketAccessKey(DeleteBucketAccessKeyRequest.Builder().apply(block).build())

/**
 * Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN) distribution.
 *
 * Certificates that are currently attached to a distribution cannot be deleted. Use the `DetachCertificateFromDistribution` action to detach a certificate from a distribution.
 */
public suspend inline fun LightsailClient.deleteCertificate(crossinline block: DeleteCertificateRequest.Builder.() -> Unit): DeleteCertificateResponse = deleteCertificate(DeleteCertificateRequest.Builder().apply(block).build())

/**
 * Deletes a contact method.
 *
 * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
 */
public suspend inline fun LightsailClient.deleteContactMethod(crossinline block: DeleteContactMethodRequest.Builder.() -> Unit): DeleteContactMethodResponse = deleteContactMethod(DeleteContactMethodRequest.Builder().apply(block).build())

/**
 * Deletes a container image that is registered to your Amazon Lightsail container service.
 */
public suspend inline fun LightsailClient.deleteContainerImage(crossinline block: DeleteContainerImageRequest.Builder.() -> Unit): DeleteContainerImageResponse = deleteContainerImage(DeleteContainerImageRequest.Builder().apply(block).build())

/**
 * Deletes your Amazon Lightsail container service.
 */
public suspend inline fun LightsailClient.deleteContainerService(crossinline block: DeleteContainerServiceRequest.Builder.() -> Unit): DeleteContainerServiceResponse = deleteContainerService(DeleteContainerServiceRequest.Builder().apply(block).build())

/**
 * Deletes the specified block storage disk. The disk must be in the `available` state (not attached to a Lightsail instance).
 *
 * The disk may remain in the `deleting` state for several minutes.
 *
 * The `delete disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteDisk(crossinline block: DeleteDiskRequest.Builder.() -> Unit): DeleteDiskResponse = deleteDisk(DeleteDiskRequest.Builder().apply(block).build())

/**
 * Deletes the specified disk snapshot.
 *
 * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the disk.
 *
 * The `delete disk snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `disk snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteDiskSnapshot(crossinline block: DeleteDiskSnapshotRequest.Builder.() -> Unit): DeleteDiskSnapshotResponse = deleteDiskSnapshot(DeleteDiskSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes your Amazon Lightsail content delivery network (CDN) distribution.
 */
public suspend inline fun LightsailClient.deleteDistribution(crossinline block: DeleteDistributionRequest.Builder.() -> Unit): DeleteDistributionResponse = deleteDistribution(DeleteDistributionRequest.Builder().apply(block).build())

/**
 * Deletes the specified domain recordset and all of its domain records.
 *
 * The `delete domain` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteDomain(crossinline block: DeleteDomainRequest.Builder.() -> Unit): DeleteDomainResponse = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

/**
 * Deletes a specific domain entry.
 *
 * The `delete domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteDomainEntry(crossinline block: DeleteDomainEntryRequest.Builder.() -> Unit): DeleteDomainEntryResponse = deleteDomainEntry(DeleteDomainEntryRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Lightsail instance.
 *
 * The `delete instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteInstance(crossinline block: DeleteInstanceRequest.Builder.() -> Unit): DeleteInstanceResponse = deleteInstance(DeleteInstanceRequest.Builder().apply(block).build())

/**
 * Deletes a specific snapshot of a virtual private server (or *instance*).
 *
 * The `delete instance snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `instance snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteInstanceSnapshot(crossinline block: DeleteInstanceSnapshotRequest.Builder.() -> Unit): DeleteInstanceSnapshotResponse = deleteInstanceSnapshot(DeleteInstanceSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes the specified key pair by removing the public key from Amazon Lightsail.
 *
 * You can delete key pairs that were created using the [ImportKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_ImportKeyPair.html) and [CreateKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateKeyPair.html) actions, as well as the Lightsail default key pair. A new default key pair will not be created unless you launch an instance without specifying a custom key pair, or you call the [DownloadDefaultKeyPair](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_DownloadDefaultKeyPair.html) API.
 *
 * The `delete key pair` operation supports tag-based access control via resource tags applied to the resource identified by `key pair name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteKeyPair(crossinline block: DeleteKeyPairRequest.Builder.() -> Unit): DeleteKeyPairResponse = deleteKeyPair(DeleteKeyPairRequest.Builder().apply(block).build())

/**
 * Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the instance after a host key mismatch.
 *
 * Perform this operation only if you were expecting the host key or certificate mismatch or if you are familiar with the new host key or certificate on the instance. For more information, see [Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP client](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection).
 */
public suspend inline fun LightsailClient.deleteKnownHostKeys(crossinline block: DeleteKnownHostKeysRequest.Builder.() -> Unit): DeleteKnownHostKeysResponse = deleteKnownHostKeys(DeleteKnownHostKeysRequest.Builder().apply(block).build())

/**
 * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted, you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
 *
 * The `delete load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteLoadBalancer(crossinline block: DeleteLoadBalancerRequest.Builder.() -> Unit): DeleteLoadBalancerResponse = deleteLoadBalancer(DeleteLoadBalancerRequest.Builder().apply(block).build())

/**
 * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
 *
 * The `DeleteLoadBalancerTlsCertificate` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteLoadBalancerTlsCertificate(crossinline block: DeleteLoadBalancerTlsCertificateRequest.Builder.() -> Unit): DeleteLoadBalancerTlsCertificateResponse = deleteLoadBalancerTlsCertificate(DeleteLoadBalancerTlsCertificateRequest.Builder().apply(block).build())

/**
 * Deletes a database in Amazon Lightsail.
 *
 * The `delete relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteRelationalDatabase(crossinline block: DeleteRelationalDatabaseRequest.Builder.() -> Unit): DeleteRelationalDatabaseResponse = deleteRelationalDatabase(DeleteRelationalDatabaseRequest.Builder().apply(block).build())

/**
 * Deletes a database snapshot in Amazon Lightsail.
 *
 * The `delete relational database snapshot` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.deleteRelationalDatabaseSnapshot(crossinline block: DeleteRelationalDatabaseSnapshotRequest.Builder.() -> Unit): DeleteRelationalDatabaseSnapshotResponse = deleteRelationalDatabaseSnapshot(DeleteRelationalDatabaseSnapshotRequest.Builder().apply(block).build())

/**
 * Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN) distribution.
 *
 * After the certificate is detached, your distribution stops accepting traffic for all of the domains that are associated with the certificate.
 */
public suspend inline fun LightsailClient.detachCertificateFromDistribution(crossinline block: DetachCertificateFromDistributionRequest.Builder.() -> Unit): DetachCertificateFromDistributionResponse = detachCertificateFromDistribution(DetachCertificateFromDistributionRequest.Builder().apply(block).build())

/**
 * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the device within your operating system before stopping the instance and detaching the disk.
 *
 * The `detach disk` operation supports tag-based access control via resource tags applied to the resource identified by `disk name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.detachDisk(crossinline block: DetachDiskRequest.Builder.() -> Unit): DetachDiskResponse = detachDisk(DetachDiskRequest.Builder().apply(block).build())

/**
 * Detaches the specified instances from a Lightsail load balancer.
 *
 * This operation waits until the instances are no longer needed before they are detached from the load balancer.
 *
 * The `detach instances from load balancer` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.detachInstancesFromLoadBalancer(crossinline block: DetachInstancesFromLoadBalancerRequest.Builder.() -> Unit): DetachInstancesFromLoadBalancerResponse = detachInstancesFromLoadBalancer(DetachInstancesFromLoadBalancerRequest.Builder().apply(block).build())

/**
 * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
 */
public suspend inline fun LightsailClient.detachStaticIp(crossinline block: DetachStaticIpRequest.Builder.() -> Unit): DetachStaticIpResponse = detachStaticIp(DetachStaticIpRequest.Builder().apply(block).build())

/**
 * Disables an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
 */
public suspend inline fun LightsailClient.disableAddOn(crossinline block: DisableAddOnRequest.Builder.() -> Unit): DisableAddOnResponse = disableAddOn(DisableAddOnRequest.Builder().apply(block).build())

/**
 * Downloads the regional Amazon Lightsail default key pair.
 *
 * This action also creates a Lightsail default key pair if a default key pair does not currently exist in the Amazon Web Services Region.
 */
public suspend inline fun LightsailClient.downloadDefaultKeyPair(crossinline block: DownloadDefaultKeyPairRequest.Builder.() -> Unit): DownloadDefaultKeyPairResponse = downloadDefaultKeyPair(DownloadDefaultKeyPairRequest.Builder().apply(block).build())

/**
 * Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
 */
public suspend inline fun LightsailClient.enableAddOn(crossinline block: EnableAddOnRequest.Builder.() -> Unit): EnableAddOnResponse = enableAddOn(EnableAddOnRequest.Builder().apply(block).build())

/**
 * Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2). This operation results in an export snapshot record that can be used with the `create cloud formation stack` operation to create new Amazon EC2 instances.
 *
 * Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the instance system disk appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the source Lightsail snapshot.
 *
 * The `export snapshot` operation supports tag-based access control via resource tags applied to the resource identified by `source snapshot name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 *
 * Use the `get instance snapshots` or `get disk snapshots` operations to get a list of snapshots that you can export to Amazon EC2.
 */
public suspend inline fun LightsailClient.exportSnapshot(crossinline block: ExportSnapshotRequest.Builder.() -> Unit): ExportSnapshotResponse = exportSnapshot(ExportSnapshotRequest.Builder().apply(block).build())

/**
 * Returns the names of all active (not deleted) resources.
 */
public suspend inline fun LightsailClient.getActiveNames(crossinline block: GetActiveNamesRequest.Builder.() -> Unit): GetActiveNamesResponse = getActiveNames(GetActiveNamesRequest.Builder().apply(block).build())

/**
 * Returns information about the configured alarms. Specify an alarm name in your request to return information about a specific alarm, or specify a monitored resource name to return information about all alarms for a specific resource.
 *
 * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
 */
public suspend inline fun LightsailClient.getAlarms(crossinline block: GetAlarmsRequest.Builder.() -> Unit): GetAlarmsResponse = getAlarms(GetAlarmsRequest.Builder().apply(block).build())

/**
 * Returns the available automatic snapshots for an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
 */
public suspend inline fun LightsailClient.getAutoSnapshots(crossinline block: GetAutoSnapshotsRequest.Builder.() -> Unit): GetAutoSnapshotsResponse = getAutoSnapshots(GetAutoSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns the list of available instance images, or *blueprints*. You can use a blueprint to create a new instance already running a specific operating system, as well as a preinstalled app or development stack. The software each instance is running depends on the blueprint image you choose.
 *
 * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.
 */
public suspend inline fun LightsailClient.getBlueprints(crossinline block: GetBlueprintsRequest.Builder.() -> Unit): GetBlueprintsResponse = getBlueprints(GetBlueprintsRequest.Builder().apply(block).build())

/**
 * Returns the existing access key IDs for the specified Amazon Lightsail bucket.
 *
 * This action does not return the secret access key value of an access key. You can get a secret access key only when you create it from the response of the [CreateBucketAccessKey](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html) action. If you lose the secret access key, you must create a new access key.
 */
public suspend inline fun LightsailClient.getBucketAccessKeys(crossinline block: GetBucketAccessKeysRequest.Builder.() -> Unit): GetBucketAccessKeysResponse = getBucketAccessKeys(GetBucketAccessKeysRequest.Builder().apply(block).build())

/**
 * Returns the bundles that you can apply to a Amazon Lightsail bucket.
 *
 * The bucket bundle specifies the monthly cost, storage quota, and data transfer quota for a bucket.
 *
 * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to update the bundle for a bucket.
 */
public suspend inline fun LightsailClient.getBucketBundles(crossinline block: GetBucketBundlesRequest.Builder.() -> Unit): GetBucketBundlesResponse = getBucketBundles(GetBucketBundlesRequest.Builder().apply(block).build())

/**
 * Returns the data points of a specific metric for an Amazon Lightsail bucket.
 *
 * Metrics report the utilization of a bucket. View and collect metric data regularly to monitor the number of objects stored in a bucket (including object versions) and the storage space used by those objects.
 */
public suspend inline fun LightsailClient.getBucketMetricData(crossinline block: GetBucketMetricDataRequest.Builder.() -> Unit): GetBucketMetricDataResponse = getBucketMetricData(GetBucketMetricDataRequest.Builder().apply(block).build())

/**
 * Returns information about one or more Amazon Lightsail buckets. The information returned includes the synchronization status of the Amazon Simple Storage Service (Amazon S3) account-level block public access feature for your Lightsail buckets.
 *
 * For more information about buckets, see [Buckets in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
 */
public suspend inline fun LightsailClient.getBuckets(crossinline block: GetBucketsRequest.Builder.() -> Unit): GetBucketsResponse = getBuckets(GetBucketsRequest.Builder().apply(block).build())

/**
 * Returns the bundles that you can apply to an Amazon Lightsail instance when you create it.
 *
 * A bundle describes the specifications of an instance, such as the monthly cost, amount of memory, the number of vCPUs, amount of storage space, and monthly network data transfer quota.
 *
 * Bundles are referred to as *instance plans* in the Lightsail console.
 */
public suspend inline fun LightsailClient.getBundles(crossinline block: GetBundlesRequest.Builder.() -> Unit): GetBundlesResponse = getBundles(GetBundlesRequest.Builder().apply(block).build())

/**
 * Returns information about one or more Amazon Lightsail SSL/TLS certificates.
 *
 * To get a summary of a certificate, omit `includeCertificateDetails` from your request. The response will include only the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.
 */
public suspend inline fun LightsailClient.getCertificates(crossinline block: GetCertificatesRequest.Builder.() -> Unit): GetCertificatesResponse = getCertificates(GetCertificatesRequest.Builder().apply(block).build())

/**
 * Returns the CloudFormation stack record created as a result of the `create cloud formation stack` operation.
 *
 * An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail snapshot.
 */
public suspend inline fun LightsailClient.getCloudFormationStackRecords(crossinline block: GetCloudFormationStackRecordsRequest.Builder.() -> Unit): GetCloudFormationStackRecordsResponse = getCloudFormationStackRecords(GetCloudFormationStackRecordsRequest.Builder().apply(block).build())

/**
 * Returns information about the configured contact methods. Specify a protocol in your request to return information about a specific contact method.
 *
 * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
 */
public suspend inline fun LightsailClient.getContactMethods(crossinline block: GetContactMethodsRequest.Builder.() -> Unit): GetContactMethodsResponse = getContactMethods(GetContactMethodsRequest.Builder().apply(block).build())

/**
 * Returns information about Amazon Lightsail containers, such as the current version of the Lightsail Control (lightsailctl) plugin.
 */
public suspend inline fun LightsailClient.getContainerApiMetadata(crossinline block: GetContainerApiMetadataRequest.Builder.() -> Unit): GetContainerApiMetadataResponse = getContainerApiMetadata(GetContainerApiMetadataRequest.Builder().apply(block).build())

/**
 * Returns the container images that are registered to your Amazon Lightsail container service.
 *
 * If you created a deployment on your Lightsail container service that uses container images from a public registry like Docker Hub, those images are not returned as part of this action. Those images are not registered to your Lightsail container service.
 */
public suspend inline fun LightsailClient.getContainerImages(crossinline block: GetContainerImagesRequest.Builder.() -> Unit): GetContainerImagesResponse = getContainerImages(GetContainerImagesRequest.Builder().apply(block).build())

/**
 * Returns the log events of a container of your Amazon Lightsail container service.
 *
 * If your container service has more than one node (i.e., a scale greater than 1), then the log events that are returned for the specified container are merged from all nodes on your container service.
 *
 * Container logs are retained for a certain amount of time. For more information, see [Amazon Lightsail endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in the *Amazon Web Services General Reference*.
 */
public suspend inline fun LightsailClient.getContainerLog(crossinline block: GetContainerLogRequest.Builder.() -> Unit): GetContainerLogResponse = getContainerLog(GetContainerLogRequest.Builder().apply(block).build())

/**
 * Returns the deployments for your Amazon Lightsail container service
 *
 * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to your container service.
 *
 * The deployments are ordered by version in ascending order. The newest version is listed at the top of the response.
 *
 * A set number of deployments are kept before the oldest one is replaced with the newest one. For more information, see [Amazon Lightsail endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in the *Amazon Web Services General Reference*.
 */
public suspend inline fun LightsailClient.getContainerServiceDeployments(crossinline block: GetContainerServiceDeploymentsRequest.Builder.() -> Unit): GetContainerServiceDeploymentsResponse = getContainerServiceDeployments(GetContainerServiceDeploymentsRequest.Builder().apply(block).build())

/**
 * Returns the data points of a specific metric of your Amazon Lightsail container service.
 *
 * Metrics report the utilization of your resources. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
 */
public suspend inline fun LightsailClient.getContainerServiceMetricData(crossinline block: GetContainerServiceMetricDataRequest.Builder.() -> Unit): GetContainerServiceMetricDataResponse = getContainerServiceMetricData(GetContainerServiceMetricDataRequest.Builder().apply(block).build())

/**
 * Returns the list of powers that can be specified for your Amazon Lightsail container services.
 *
 * The power specifies the amount of memory, the number of vCPUs, and the base price of the container service.
 */
public suspend inline fun LightsailClient.getContainerServicePowers(crossinline block: GetContainerServicePowersRequest.Builder.() -> Unit): GetContainerServicePowersResponse = getContainerServicePowers(GetContainerServicePowersRequest.Builder().apply(block).build())

/**
 * Returns information about one or more of your Amazon Lightsail container services.
 */
public suspend inline fun LightsailClient.getContainerServices(crossinline block: GetContainerServicesRequest.Builder.() -> Unit): GetContainerServicesResponse = getContainerServices(GetContainerServicesRequest.Builder().apply(block).build())

/**
 * Retrieves information about the cost estimate for a specified resource. A cost estimate will not generate for a resource that has been deleted.
 */
public suspend inline fun LightsailClient.getCostEstimate(crossinline block: GetCostEstimateRequest.Builder.() -> Unit): GetCostEstimateResponse = getCostEstimate(GetCostEstimateRequest.Builder().apply(block).build())

/**
 * Returns information about a specific block storage disk.
 */
public suspend inline fun LightsailClient.getDisk(crossinline block: GetDiskRequest.Builder.() -> Unit): GetDiskResponse = getDisk(GetDiskRequest.Builder().apply(block).build())

/**
 * Returns information about a specific block storage disk snapshot.
 */
public suspend inline fun LightsailClient.getDiskSnapshot(crossinline block: GetDiskSnapshotRequest.Builder.() -> Unit): GetDiskSnapshotResponse = getDiskSnapshot(GetDiskSnapshotRequest.Builder().apply(block).build())

/**
 * Returns information about all block storage disk snapshots in your AWS account and region.
 */
public suspend inline fun LightsailClient.getDiskSnapshots(crossinline block: GetDiskSnapshotsRequest.Builder.() -> Unit): GetDiskSnapshotsResponse = getDiskSnapshots(GetDiskSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns information about all block storage disks in your AWS account and region.
 */
public suspend inline fun LightsailClient.getDisks(crossinline block: GetDisksRequest.Builder.() -> Unit): GetDisksResponse = getDisks(GetDisksRequest.Builder().apply(block).build())

/**
 * Returns the bundles that can be applied to your Amazon Lightsail content delivery network (CDN) distributions.
 *
 * A distribution bundle specifies the monthly network transfer quota and monthly cost of your distribution.
 */
public suspend inline fun LightsailClient.getDistributionBundles(crossinline block: GetDistributionBundlesRequest.Builder.() -> Unit): GetDistributionBundlesResponse = getDistributionBundles(GetDistributionBundlesRequest.Builder().apply(block).build())

/**
 * Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail content delivery network (CDN) distribution.
 */
public suspend inline fun LightsailClient.getDistributionLatestCacheReset(crossinline block: GetDistributionLatestCacheResetRequest.Builder.() -> Unit): GetDistributionLatestCacheResetResponse = getDistributionLatestCacheReset(GetDistributionLatestCacheResetRequest.Builder().apply(block).build())

/**
 * Returns the data points of a specific metric for an Amazon Lightsail content delivery network (CDN) distribution.
 *
 * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
 */
public suspend inline fun LightsailClient.getDistributionMetricData(crossinline block: GetDistributionMetricDataRequest.Builder.() -> Unit): GetDistributionMetricDataResponse = getDistributionMetricData(GetDistributionMetricDataRequest.Builder().apply(block).build())

/**
 * Returns information about one or more of your Amazon Lightsail content delivery network (CDN) distributions.
 */
public suspend inline fun LightsailClient.getDistributions(crossinline block: GetDistributionsRequest.Builder.() -> Unit): GetDistributionsResponse = getDistributions(GetDistributionsRequest.Builder().apply(block).build())

/**
 * Returns information about a specific domain recordset.
 */
public suspend inline fun LightsailClient.getDomain(crossinline block: GetDomainRequest.Builder.() -> Unit): GetDomainResponse = getDomain(GetDomainRequest.Builder().apply(block).build())

/**
 * Returns a list of all domains in the user's account.
 */
public suspend inline fun LightsailClient.getDomains(crossinline block: GetDomainsRequest.Builder.() -> Unit): GetDomainsResponse = getDomains(GetDomainsRequest.Builder().apply(block).build())

/**
 * Returns all export snapshot records created as a result of the `export snapshot` operation.
 *
 * An export snapshot record can be used to create a new Amazon EC2 instance and its related resources with the [CreateCloudFormationStack](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateCloudFormationStack.html) action.
 */
public suspend inline fun LightsailClient.getExportSnapshotRecords(crossinline block: GetExportSnapshotRecordsRequest.Builder.() -> Unit): GetExportSnapshotRecordsResponse = getExportSnapshotRecords(GetExportSnapshotRecordsRequest.Builder().apply(block).build())

/**
 * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
 */
public suspend inline fun LightsailClient.getInstance(crossinline block: GetInstanceRequest.Builder.() -> Unit): GetInstanceResponse = getInstance(GetInstanceRequest.Builder().apply(block).build())

/**
 * Returns temporary SSH keys you can use to connect to a specific virtual private server, or *instance*.
 *
 * The `get instance access details` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.getInstanceAccessDetails(crossinline block: GetInstanceAccessDetailsRequest.Builder.() -> Unit): GetInstanceAccessDetailsResponse = getInstanceAccessDetails(GetInstanceAccessDetailsRequest.Builder().apply(block).build())

/**
 * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
 *
 * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
 */
public suspend inline fun LightsailClient.getInstanceMetricData(crossinline block: GetInstanceMetricDataRequest.Builder.() -> Unit): GetInstanceMetricDataResponse = getInstanceMetricData(GetInstanceMetricDataRequest.Builder().apply(block).build())

/**
 * Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses allowed to connect to the instance through the ports, and the protocol.
 */
public suspend inline fun LightsailClient.getInstancePortStates(crossinline block: GetInstancePortStatesRequest.Builder.() -> Unit): GetInstancePortStatesResponse = getInstancePortStates(GetInstancePortStatesRequest.Builder().apply(block).build())

/**
 * Returns information about a specific instance snapshot.
 */
public suspend inline fun LightsailClient.getInstanceSnapshot(crossinline block: GetInstanceSnapshotRequest.Builder.() -> Unit): GetInstanceSnapshotResponse = getInstanceSnapshot(GetInstanceSnapshotRequest.Builder().apply(block).build())

/**
 * Returns all instance snapshots for the user's account.
 */
public suspend inline fun LightsailClient.getInstanceSnapshots(crossinline block: GetInstanceSnapshotsRequest.Builder.() -> Unit): GetInstanceSnapshotsResponse = getInstanceSnapshots(GetInstanceSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns the state of a specific instance. Works on one instance at a time.
 */
public suspend inline fun LightsailClient.getInstanceState(crossinline block: GetInstanceStateRequest.Builder.() -> Unit): GetInstanceStateResponse = getInstanceState(GetInstanceStateRequest.Builder().apply(block).build())

/**
 * Returns information about all Amazon Lightsail virtual private servers, or *instances*.
 */
public suspend inline fun LightsailClient.getInstances(crossinline block: GetInstancesRequest.Builder.() -> Unit): GetInstancesResponse = getInstances(GetInstancesRequest.Builder().apply(block).build())

/**
 * Returns information about a specific key pair.
 */
public suspend inline fun LightsailClient.getKeyPair(crossinline block: GetKeyPairRequest.Builder.() -> Unit): GetKeyPairResponse = getKeyPair(GetKeyPairRequest.Builder().apply(block).build())

/**
 * Returns information about all key pairs in the user's account.
 */
public suspend inline fun LightsailClient.getKeyPairs(crossinline block: GetKeyPairsRequest.Builder.() -> Unit): GetKeyPairsResponse = getKeyPairs(GetKeyPairsRequest.Builder().apply(block).build())

/**
 * Returns information about the specified Lightsail load balancer.
 */
public suspend inline fun LightsailClient.getLoadBalancer(crossinline block: GetLoadBalancerRequest.Builder.() -> Unit): GetLoadBalancerResponse = getLoadBalancer(GetLoadBalancerRequest.Builder().apply(block).build())

/**
 * Returns information about health metrics for your Lightsail load balancer.
 *
 * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
 */
public suspend inline fun LightsailClient.getLoadBalancerMetricData(crossinline block: GetLoadBalancerMetricDataRequest.Builder.() -> Unit): GetLoadBalancerMetricDataResponse = getLoadBalancerMetricData(GetLoadBalancerMetricDataRequest.Builder().apply(block).build())

/**
 * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
 *
 * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
 *
 * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other is inactive.
 */
public suspend inline fun LightsailClient.getLoadBalancerTlsCertificates(crossinline block: GetLoadBalancerTlsCertificatesRequest.Builder.() -> Unit): GetLoadBalancerTlsCertificatesResponse = getLoadBalancerTlsCertificates(GetLoadBalancerTlsCertificatesRequest.Builder().apply(block).build())

/**
 * Returns a list of TLS security policies that you can apply to Lightsail load balancers.
 *
 * For more information about load balancer TLS security policies, see [Configuring TLS security policies on your Amazon Lightsail load balancers](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configure-load-balancer-tls-security-policy) in the *Amazon Lightsail Developer Guide*.
 */
public suspend inline fun LightsailClient.getLoadBalancerTlsPolicies(crossinline block: GetLoadBalancerTlsPoliciesRequest.Builder.() -> Unit): GetLoadBalancerTlsPoliciesResponse = getLoadBalancerTlsPolicies(GetLoadBalancerTlsPoliciesRequest.Builder().apply(block).build())

/**
 * Returns information about all load balancers in an account.
 */
public suspend inline fun LightsailClient.getLoadBalancers(crossinline block: GetLoadBalancersRequest.Builder.() -> Unit): GetLoadBalancersResponse = getLoadBalancers(GetLoadBalancersRequest.Builder().apply(block).build())

/**
 * Returns information about a specific operation. Operations include events such as when you create an instance, allocate a static IP, attach a static IP, and so on.
 */
public suspend inline fun LightsailClient.getOperation(crossinline block: GetOperationRequest.Builder.() -> Unit): GetOperationResponse = getOperation(GetOperationRequest.Builder().apply(block).build())

/**
 * Returns information about all operations.
 *
 * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each subsequent call to `GetOperations` use the maximum (last) `statusChangedAt` value from the previous request.
 */
public suspend inline fun LightsailClient.getOperations(crossinline block: GetOperationsRequest.Builder.() -> Unit): GetOperationsResponse = getOperations(GetOperationsRequest.Builder().apply(block).build())

/**
 * Gets operations for a specific resource (an instance or a static IP).
 */
public suspend inline fun LightsailClient.getOperationsForResource(crossinline block: GetOperationsForResourceRequest.Builder.() -> Unit): GetOperationsForResourceResponse = getOperationsForResource(GetOperationsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of all valid regions for Amazon Lightsail. Use the `include availability zones` parameter to also return the Availability Zones in a region.
 */
public suspend inline fun LightsailClient.getRegions(crossinline block: GetRegionsRequest.Builder.() -> Unit): GetRegionsResponse = getRegions(GetRegionsRequest.Builder().apply(block).build())

/**
 * Returns information about a specific database in Amazon Lightsail.
 */
public suspend inline fun LightsailClient.getRelationalDatabase(crossinline block: GetRelationalDatabaseRequest.Builder.() -> Unit): GetRelationalDatabaseResponse = getRelationalDatabase(GetRelationalDatabaseRequest.Builder().apply(block).build())

/**
 * Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine version of a database.
 *
 * You can use a blueprint ID to create a new database that runs a specific database engine.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseBlueprints(crossinline block: GetRelationalDatabaseBlueprintsRequest.Builder.() -> Unit): GetRelationalDatabaseBlueprintsResponse = getRelationalDatabaseBlueprints(GetRelationalDatabaseBlueprintsRequest.Builder().apply(block).build())

/**
 * Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance specifications for a database.
 *
 * You can use a bundle ID to create a new database with explicit performance specifications.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseBundles(crossinline block: GetRelationalDatabaseBundlesRequest.Builder.() -> Unit): GetRelationalDatabaseBundlesResponse = getRelationalDatabaseBundles(GetRelationalDatabaseBundlesRequest.Builder().apply(block).build())

/**
 * Returns a list of events for a specific database in Amazon Lightsail.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseEvents(crossinline block: GetRelationalDatabaseEventsRequest.Builder.() -> Unit): GetRelationalDatabaseEventsResponse = getRelationalDatabaseEvents(GetRelationalDatabaseEventsRequest.Builder().apply(block).build())

/**
 * Returns a list of log events for a database in Amazon Lightsail.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseLogEvents(crossinline block: GetRelationalDatabaseLogEventsRequest.Builder.() -> Unit): GetRelationalDatabaseLogEventsResponse = getRelationalDatabaseLogEvents(GetRelationalDatabaseLogEventsRequest.Builder().apply(block).build())

/**
 * Returns a list of available log streams for a specific database in Amazon Lightsail.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseLogStreams(crossinline block: GetRelationalDatabaseLogStreamsRequest.Builder.() -> Unit): GetRelationalDatabaseLogStreamsResponse = getRelationalDatabaseLogStreams(GetRelationalDatabaseLogStreamsRequest.Builder().apply(block).build())

/**
 * Returns the current, previous, or pending versions of the master user password for a Lightsail database.
 *
 * The `GetRelationalDatabaseMasterUserPassword` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseMasterUserPassword(crossinline block: GetRelationalDatabaseMasterUserPasswordRequest.Builder.() -> Unit): GetRelationalDatabaseMasterUserPasswordResponse = getRelationalDatabaseMasterUserPassword(GetRelationalDatabaseMasterUserPasswordRequest.Builder().apply(block).build())

/**
 * Returns the data points of the specified metric for a database in Amazon Lightsail.
 *
 * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseMetricData(crossinline block: GetRelationalDatabaseMetricDataRequest.Builder.() -> Unit): GetRelationalDatabaseMetricDataResponse = getRelationalDatabaseMetricData(GetRelationalDatabaseMetricDataRequest.Builder().apply(block).build())

/**
 * Returns all of the runtime parameters offered by the underlying database software, or engine, for a specific database in Amazon Lightsail.
 *
 * In addition to the parameter names and values, this operation returns other information about each parameter. This information includes whether changes require a reboot, whether the parameter is modifiable, the allowed values, and the data types.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseParameters(crossinline block: GetRelationalDatabaseParametersRequest.Builder.() -> Unit): GetRelationalDatabaseParametersResponse = getRelationalDatabaseParameters(GetRelationalDatabaseParametersRequest.Builder().apply(block).build())

/**
 * Returns information about a specific database snapshot in Amazon Lightsail.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseSnapshot(crossinline block: GetRelationalDatabaseSnapshotRequest.Builder.() -> Unit): GetRelationalDatabaseSnapshotResponse = getRelationalDatabaseSnapshot(GetRelationalDatabaseSnapshotRequest.Builder().apply(block).build())

/**
 * Returns information about all of your database snapshots in Amazon Lightsail.
 */
public suspend inline fun LightsailClient.getRelationalDatabaseSnapshots(crossinline block: GetRelationalDatabaseSnapshotsRequest.Builder.() -> Unit): GetRelationalDatabaseSnapshotsResponse = getRelationalDatabaseSnapshots(GetRelationalDatabaseSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns information about all of your databases in Amazon Lightsail.
 */
public suspend inline fun LightsailClient.getRelationalDatabases(crossinline block: GetRelationalDatabasesRequest.Builder.() -> Unit): GetRelationalDatabasesResponse = getRelationalDatabases(GetRelationalDatabasesRequest.Builder().apply(block).build())

/**
 * Returns detailed information for five of the most recent `SetupInstanceHttps` requests that were ran on the target instance.
 */
public suspend inline fun LightsailClient.getSetupHistory(crossinline block: GetSetupHistoryRequest.Builder.() -> Unit): GetSetupHistoryResponse = getSetupHistory(GetSetupHistoryRequest.Builder().apply(block).build())

/**
 * Returns information about an Amazon Lightsail static IP.
 */
public suspend inline fun LightsailClient.getStaticIp(crossinline block: GetStaticIpRequest.Builder.() -> Unit): GetStaticIpResponse = getStaticIp(GetStaticIpRequest.Builder().apply(block).build())

/**
 * Returns information about all static IPs in the user's account.
 */
public suspend inline fun LightsailClient.getStaticIps(crossinline block: GetStaticIpsRequest.Builder.() -> Unit): GetStaticIpsResponse = getStaticIps(GetStaticIpsRequest.Builder().apply(block).build())

/**
 * Imports a public SSH key from a specific key pair.
 */
public suspend inline fun LightsailClient.importKeyPair(crossinline block: ImportKeyPairRequest.Builder.() -> Unit): ImportKeyPairResponse = importKeyPair(ImportKeyPairRequest.Builder().apply(block).build())

/**
 * Returns a Boolean value indicating whether your Lightsail VPC is peered.
 */
public suspend inline fun LightsailClient.isVpcPeered(crossinline block: IsVpcPeeredRequest.Builder.() -> Unit): IsVpcPeeredResponse = isVpcPeered(IsVpcPeeredRequest.Builder().apply(block).build())

/**
 * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.
 *
 * The `OpenInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.openInstancePublicPorts(crossinline block: OpenInstancePublicPortsRequest.Builder.() -> Unit): OpenInstancePublicPortsResponse = openInstancePublicPorts(OpenInstancePublicPortsRequest.Builder().apply(block).build())

/**
 * Peers the Lightsail VPC with the user's default VPC.
 */
public suspend inline fun LightsailClient.peerVpc(crossinline block: PeerVpcRequest.Builder.() -> Unit): PeerVpcResponse = peerVpc(PeerVpcRequest.Builder().apply(block).build())

/**
 * Creates or updates an alarm, and associates it with the specified metric.
 *
 * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
 *
 * When this action creates an alarm, the alarm state is immediately set to `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed.
 *
 * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm. The alarm is then evaluated with the updated configuration.
 */
public suspend inline fun LightsailClient.putAlarm(crossinline block: PutAlarmRequest.Builder.() -> Unit): PutAlarmResponse = putAlarm(PutAlarmRequest.Builder().apply(block).build())

/**
 * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol. This action also closes all currently open ports that are not included in the request. Include all of the ports and the protocols you want to open in your `PutInstancePublicPorts`request. Or use the `OpenInstancePublicPorts` action to open ports without closing currently open ports.
 *
 * The `PutInstancePublicPorts` action supports tag-based access control via resource tags applied to the resource identified by `instanceName`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.putInstancePublicPorts(crossinline block: PutInstancePublicPortsRequest.Builder.() -> Unit): PutInstancePublicPortsResponse = putInstancePublicPorts(PutInstancePublicPortsRequest.Builder().apply(block).build())

/**
 * Restarts a specific instance.
 *
 * The `reboot instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.rebootInstance(crossinline block: RebootInstanceRequest.Builder.() -> Unit): RebootInstanceResponse = rebootInstance(RebootInstanceRequest.Builder().apply(block).build())

/**
 * Restarts a specific database in Amazon Lightsail.
 *
 * The `reboot relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.rebootRelationalDatabase(crossinline block: RebootRelationalDatabaseRequest.Builder.() -> Unit): RebootRelationalDatabaseResponse = rebootRelationalDatabase(RebootRelationalDatabaseRequest.Builder().apply(block).build())

/**
 * Registers a container image to your Amazon Lightsail container service.
 *
 * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container images to your Lightsail container service. For more information, see [Pushing and managing container images on your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images) in the *Amazon Lightsail Developer Guide*.
 */
public suspend inline fun LightsailClient.registerContainerImage(crossinline block: RegisterContainerImageRequest.Builder.() -> Unit): RegisterContainerImageResponse = registerContainerImage(RegisterContainerImageRequest.Builder().apply(block).build())

/**
 * Deletes a specific static IP from your account.
 */
public suspend inline fun LightsailClient.releaseStaticIp(crossinline block: ReleaseStaticIpRequest.Builder.() -> Unit): ReleaseStaticIpResponse = releaseStaticIp(ReleaseStaticIpRequest.Builder().apply(block).build())

/**
 * Deletes currently cached content from your Amazon Lightsail content delivery network (CDN) distribution.
 *
 * After resetting the cache, the next time a content request is made, your distribution pulls, serves, and caches it from the origin.
 */
public suspend inline fun LightsailClient.resetDistributionCache(crossinline block: ResetDistributionCacheRequest.Builder.() -> Unit): ResetDistributionCacheResponse = resetDistributionCache(ResetDistributionCacheRequest.Builder().apply(block).build())

/**
 * Sends a verification request to an email contact method to ensure it's owned by the requester. SMS contact methods don't need to be verified.
 *
 * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each Amazon Web Services Region. However, SMS text messaging is not supported in some Amazon Web Services Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see [Notifications in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
 *
 * A verification request is sent to the contact method when you initially create it. Use this action to send another verification request if a previous verification request was deleted, or has expired.
 *
 * Notifications are not sent to an email contact method until after it is verified, and confirmed as valid.
 */
public suspend inline fun LightsailClient.sendContactMethodVerification(crossinline block: SendContactMethodVerificationRequest.Builder.() -> Unit): SendContactMethodVerificationResponse = sendContactMethodVerification(SendContactMethodVerificationRequest.Builder().apply(block).build())

/**
 * Sets the IP address type for an Amazon Lightsail resource.
 *
 * Use this action to enable dual-stack for a resource, which enables IPv4 and IPv6 for the specified resource. Alternately, you can use this action to disable dual-stack, and enable IPv4 only.
 */
public suspend inline fun LightsailClient.setIpAddressType(crossinline block: SetIpAddressTypeRequest.Builder.() -> Unit): SetIpAddressTypeResponse = setIpAddressType(SetIpAddressTypeRequest.Builder().apply(block).build())

/**
 * Sets the Amazon Lightsail resources that can access the specified Lightsail bucket.
 *
 * Lightsail buckets currently support setting access for Lightsail instances in the same Amazon Web Services Region.
 */
public suspend inline fun LightsailClient.setResourceAccessForBucket(crossinline block: SetResourceAccessForBucketRequest.Builder.() -> Unit): SetResourceAccessForBucketResponse = setResourceAccessForBucket(SetResourceAccessForBucketRequest.Builder().apply(block).build())

/**
 * Creates an SSL/TLS certificate that secures traffic for your website. After the certificate is created, it is installed on the specified Lightsail instance.
 *
 * If you provide more than one domain name in the request, at least one name must be less than or equal to 63 characters in length.
 */
public suspend inline fun LightsailClient.setupInstanceHttps(crossinline block: SetupInstanceHttpsRequest.Builder.() -> Unit): SetupInstanceHttpsResponse = setupInstanceHttps(SetupInstanceHttpsRequest.Builder().apply(block).build())

/**
 * Initiates a graphical user interface (GUI) session that’s used to access a virtual computer’s operating system and application. The session will be active for 1 hour. Use this action to resume the session after it expires.
 */
public suspend inline fun LightsailClient.startGuiSession(crossinline block: StartGuiSessionRequest.Builder.() -> Unit): StartGuiSessionResponse = startGuiSession(StartGuiSessionRequest.Builder().apply(block).build())

/**
 * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the `reboot instance` operation.
 *
 * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
 *
 * The `start instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.startInstance(crossinline block: StartInstanceRequest.Builder.() -> Unit): StartInstanceResponse = startInstance(StartInstanceRequest.Builder().apply(block).build())

/**
 * Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the `reboot relational database` operation.
 *
 * The `start relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.startRelationalDatabase(crossinline block: StartRelationalDatabaseRequest.Builder.() -> Unit): StartRelationalDatabaseResponse = startRelationalDatabase(StartRelationalDatabaseRequest.Builder().apply(block).build())

/**
 * Terminates a web-based NICE DCV session that’s used to access a virtual computer’s operating system or application. The session will close and any unsaved data will be lost.
 */
public suspend inline fun LightsailClient.stopGuiSession(crossinline block: StopGuiSessionRequest.Builder.() -> Unit): StopGuiSessionResponse = stopGuiSession(StopGuiSessionRequest.Builder().apply(block).build())

/**
 * Stops a specific Amazon Lightsail instance that is currently running.
 *
 * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip).
 *
 * The `stop instance` operation supports tag-based access control via resource tags applied to the resource identified by `instance name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.stopInstance(crossinline block: StopInstanceRequest.Builder.() -> Unit): StopInstanceResponse = stopInstance(StopInstanceRequest.Builder().apply(block).build())

/**
 * Stops a specific database that is currently running in Amazon Lightsail.
 *
 * The `stop relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.stopRelationalDatabase(crossinline block: StopRelationalDatabaseRequest.Builder.() -> Unit): StopRelationalDatabaseResponse = stopRelationalDatabase(StopRelationalDatabaseRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
 *
 * The `tag resource` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `resource name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured for the specified alarm, the test also sends a notification to the notification protocol (`Email` and/or `SMS`) configured for the alarm.
 *
 * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see [Alarms in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
 */
public suspend inline fun LightsailClient.testAlarm(crossinline block: TestAlarmRequest.Builder.() -> Unit): TestAlarmResponse = testAlarm(TestAlarmRequest.Builder().apply(block).build())

/**
 * Unpeers the Lightsail VPC from the user's default VPC.
 */
public suspend inline fun LightsailClient.unpeerVpc(crossinline block: UnpeerVpcRequest.Builder.() -> Unit): UnpeerVpcResponse = unpeerVpc(UnpeerVpcRequest.Builder().apply(block).build())

/**
 * Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource.
 *
 * The `untag resource` operation supports tag-based access control via request tags and resource tags applied to the resource identified by `resource name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Amazon Lightsail bucket.
 *
 * Use this action to update the configuration of an existing bucket, such as versioning, public accessibility, and the Amazon Web Services accounts that can access the bucket.
 */
public suspend inline fun LightsailClient.updateBucket(crossinline block: UpdateBucketRequest.Builder.() -> Unit): UpdateBucketResponse = updateBucket(UpdateBucketRequest.Builder().apply(block).build())

/**
 * Updates the bundle, or storage plan, of an existing Amazon Lightsail bucket.
 *
 * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket. You can update a bucket's bundle only one time within a monthly Amazon Web Services billing cycle. To determine if you can update a bucket's bundle, use the [GetBuckets](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html) action. The `ableToUpdateBundle` parameter in the response will indicate whether you can currently update a bucket's bundle.
 *
 * Update a bucket's bundle if it's consistently going over its storage space or data transfer quota, or if a bucket's usage is consistently in the lower range of its storage space or data transfer quota. Due to the unpredictable usage fluctuations that a bucket might experience, we strongly recommend that you update a bucket's bundle only as a long-term strategy, instead of as a short-term, monthly cost-cutting measure. Choose a bucket bundle that will provide the bucket with ample storage space and data transfer for a long time to come.
 */
public suspend inline fun LightsailClient.updateBucketBundle(crossinline block: UpdateBucketBundleRequest.Builder.() -> Unit): UpdateBucketBundleResponse = updateBucketBundle(UpdateBucketBundleRequest.Builder().apply(block).build())

/**
 * Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain names.
 */
public suspend inline fun LightsailClient.updateContainerService(crossinline block: UpdateContainerServiceRequest.Builder.() -> Unit): UpdateContainerServiceResponse = updateContainerService(UpdateContainerServiceRequest.Builder().apply(block).build())

/**
 * Updates an existing Amazon Lightsail content delivery network (CDN) distribution.
 *
 * Use this action to update the configuration of your existing distribution.
 */
public suspend inline fun LightsailClient.updateDistribution(crossinline block: UpdateDistributionRequest.Builder.() -> Unit): UpdateDistributionResponse = updateDistribution(UpdateDistributionRequest.Builder().apply(block).build())

/**
 * Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution.
 *
 * A distribution bundle specifies the monthly network transfer quota and monthly cost of your distribution.
 *
 * Update your distribution's bundle if your distribution is going over its monthly network transfer quota and is incurring an overage fee.
 *
 * You can update your distribution's bundle only one time within your monthly Amazon Web Services billing cycle. To determine if you can update your distribution's bundle, use the `GetDistributions` action. The `ableToUpdateBundle` parameter in the result will indicate whether you can currently update your distribution's bundle.
 */
public suspend inline fun LightsailClient.updateDistributionBundle(crossinline block: UpdateDistributionBundleRequest.Builder.() -> Unit): UpdateDistributionBundleResponse = updateDistributionBundle(UpdateDistributionBundleRequest.Builder().apply(block).build())

/**
 * Updates a domain recordset after it is created.
 *
 * The `update domain entry` operation supports tag-based access control via resource tags applied to the resource identified by `domain name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.updateDomainEntry(crossinline block: UpdateDomainEntryRequest.Builder.() -> Unit): UpdateDomainEntryResponse = updateDomainEntry(UpdateDomainEntryRequest.Builder().apply(block).build())

/**
 * Modifies the Amazon Lightsail instance metadata parameters on a running or stopped instance. When you modify the parameters on a running instance, the `GetInstance` or `GetInstances` API operation initially responds with a state of `pending`. After the parameter modifications are successfully applied, the state changes to `applied` in subsequent `GetInstance` or `GetInstances` API calls. For more information, see [Use IMDSv2 with an Amazon Lightsail instance](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-instance-metadata-service) in the *Amazon Lightsail Developer Guide*.
 */
public suspend inline fun LightsailClient.updateInstanceMetadataOptions(crossinline block: UpdateInstanceMetadataOptionsRequest.Builder.() -> Unit): UpdateInstanceMetadataOptionsResponse = updateInstanceMetadataOptions(UpdateInstanceMetadataOptionsRequest.Builder().apply(block).build())

/**
 * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
 *
 * The `update load balancer attribute` operation supports tag-based access control via resource tags applied to the resource identified by `load balancer name`. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.updateLoadBalancerAttribute(crossinline block: UpdateLoadBalancerAttributeRequest.Builder.() -> Unit): UpdateLoadBalancerAttributeResponse = updateLoadBalancerAttribute(UpdateLoadBalancerAttributeRequest.Builder().apply(block).build())

/**
 * Allows the update of one or more attributes of a database in Amazon Lightsail.
 *
 * Updates are applied immediately, or in cases where the updates could result in an outage, are applied during the database's predefined maintenance window.
 *
 * The `update relational database` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.updateRelationalDatabase(crossinline block: UpdateRelationalDatabaseRequest.Builder.() -> Unit): UpdateRelationalDatabaseResponse = updateRelationalDatabase(UpdateRelationalDatabaseRequest.Builder().apply(block).build())

/**
 * Allows the update of one or more parameters of a database in Amazon Lightsail.
 *
 * Parameter updates don't cause outages; therefore, their application is not subject to the preferred maintenance window. However, there are two ways in which parameter updates are applied: `dynamic` or `pending-reboot`. Parameters marked with a `dynamic` apply type are applied immediately. Parameters marked with a `pending-reboot` apply type are applied only after the database is rebooted using the `reboot relational database` operation.
 *
 * The `update relational database parameters` operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags).
 */
public suspend inline fun LightsailClient.updateRelationalDatabaseParameters(crossinline block: UpdateRelationalDatabaseParametersRequest.Builder.() -> Unit): UpdateRelationalDatabaseParametersResponse = updateRelationalDatabaseParameters(UpdateRelationalDatabaseParametersRequest.Builder().apply(block).build())
