// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerusersubscriptions.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.IdentityProviderSummary
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeregisterIdentityProviderOperationDeserializer: HttpDeserialize<DeregisterIdentityProviderResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeregisterIdentityProviderResponse {
        if (!response.status.isSuccess()) {
            throwDeregisterIdentityProviderError(context, response)
        }
        val builder = DeregisterIdentityProviderResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeregisterIdentityProviderOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeregisterIdentityProviderError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerUserSubscriptionsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LicenseManagerUserSubscriptionsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeregisterIdentityProviderOperationBody(builder: DeregisterIdentityProviderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDENTITYPROVIDERSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IdentityProviderSummary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITYPROVIDERSUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITYPROVIDERSUMMARY_DESCRIPTOR.index -> builder.identityProviderSummary = deserializeIdentityProviderSummaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
