// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerusersubscriptions

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.*
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.AssociateUserRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.AssociateUserResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.DisassociateUserRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.DisassociateUserResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListInstancesRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListInstancesResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * With License Manager, you can create user-based subscriptions to utilize licensed software with a per user subscription fee on Amazon EC2 instances.
 */
public interface LicenseManagerUserSubscriptionsClient : SdkClient {

    override val serviceName: String
        get() = "License Manager User Subscriptions"
    /**
     * LicenseManagerUserSubscriptionsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): LicenseManagerUserSubscriptionsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultLicenseManagerUserSubscriptionsClient(config)
        }

        public operator fun invoke(config: Config): LicenseManagerUserSubscriptionsClient = DefaultLicenseManagerUserSubscriptionsClient(config)

        /**
         * Construct a [LicenseManagerUserSubscriptionsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): LicenseManagerUserSubscriptionsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultLicenseManagerUserSubscriptionsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates the user to an EC2 instance to utilize user-based subscriptions.
     */
    public suspend fun associateUser(input: AssociateUserRequest): AssociateUserResponse

    /**
     * Deregisters the identity provider from providing user-based subscriptions.
     */
    public suspend fun deregisterIdentityProvider(input: DeregisterIdentityProviderRequest): DeregisterIdentityProviderResponse

    /**
     * Disassociates the user from an EC2 instance providing user-based subscriptions.
     */
    public suspend fun disassociateUser(input: DisassociateUserRequest): DisassociateUserResponse

    /**
     * Lists the identity providers for user-based subscriptions.
     */
    public suspend fun listIdentityProviders(input: ListIdentityProvidersRequest = ListIdentityProvidersRequest {}): ListIdentityProvidersResponse

    /**
     * Lists the EC2 instances providing user-based subscriptions.
     */
    public suspend fun listInstances(input: ListInstancesRequest = ListInstancesRequest {}): ListInstancesResponse

    /**
     * Lists the user-based subscription products available from an identity provider.
     */
    public suspend fun listProductSubscriptions(input: ListProductSubscriptionsRequest): ListProductSubscriptionsResponse

    /**
     * Lists user associations for an identity provider.
     */
    public suspend fun listUserAssociations(input: ListUserAssociationsRequest): ListUserAssociationsResponse

    /**
     * Registers an identity provider for user-based subscriptions.
     */
    public suspend fun registerIdentityProvider(input: RegisterIdentityProviderRequest): RegisterIdentityProviderResponse

    /**
     * Starts a product subscription for a user with the specified identity provider.
     */
    public suspend fun startProductSubscription(input: StartProductSubscriptionRequest): StartProductSubscriptionResponse

    /**
     * Stops a product subscription for a user with the specified identity provider.
     */
    public suspend fun stopProductSubscription(input: StopProductSubscriptionRequest): StopProductSubscriptionResponse
}

/**
 * Associates the user to an EC2 instance to utilize user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.associateUser(crossinline block: AssociateUserRequest.Builder.() -> Unit): AssociateUserResponse = associateUser(AssociateUserRequest.Builder().apply(block).build())

/**
 * Deregisters the identity provider from providing user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.deregisterIdentityProvider(crossinline block: DeregisterIdentityProviderRequest.Builder.() -> Unit): DeregisterIdentityProviderResponse = deregisterIdentityProvider(DeregisterIdentityProviderRequest.Builder().apply(block).build())

/**
 * Disassociates the user from an EC2 instance providing user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.disassociateUser(crossinline block: DisassociateUserRequest.Builder.() -> Unit): DisassociateUserResponse = disassociateUser(DisassociateUserRequest.Builder().apply(block).build())

/**
 * Lists the identity providers for user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.listIdentityProviders(crossinline block: ListIdentityProvidersRequest.Builder.() -> Unit): ListIdentityProvidersResponse = listIdentityProviders(ListIdentityProvidersRequest.Builder().apply(block).build())

/**
 * Lists the EC2 instances providing user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.listInstances(crossinline block: ListInstancesRequest.Builder.() -> Unit): ListInstancesResponse = listInstances(ListInstancesRequest.Builder().apply(block).build())

/**
 * Lists the user-based subscription products available from an identity provider.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.listProductSubscriptions(crossinline block: ListProductSubscriptionsRequest.Builder.() -> Unit): ListProductSubscriptionsResponse = listProductSubscriptions(ListProductSubscriptionsRequest.Builder().apply(block).build())

/**
 * Lists user associations for an identity provider.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.listUserAssociations(crossinline block: ListUserAssociationsRequest.Builder.() -> Unit): ListUserAssociationsResponse = listUserAssociations(ListUserAssociationsRequest.Builder().apply(block).build())

/**
 * Registers an identity provider for user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.registerIdentityProvider(crossinline block: RegisterIdentityProviderRequest.Builder.() -> Unit): RegisterIdentityProviderResponse = registerIdentityProvider(RegisterIdentityProviderRequest.Builder().apply(block).build())

/**
 * Starts a product subscription for a user with the specified identity provider.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.startProductSubscription(crossinline block: StartProductSubscriptionRequest.Builder.() -> Unit): StartProductSubscriptionResponse = startProductSubscription(StartProductSubscriptionRequest.Builder().apply(block).build())

/**
 * Stops a product subscription for a user with the specified identity provider.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.stopProductSubscription(crossinline block: StopProductSubscriptionRequest.Builder.() -> Unit): StopProductSubscriptionResponse = stopProductSubscription(StopProductSubscriptionRequest.Builder().apply(block).build())
