// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerusersubscriptions

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.*
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "License Manager User Subscriptions"
public const val ServiceApiVersion: String = "2018-05-10"
public const val SdkVersion: String = "0.17.6-beta"

internal class DefaultLicenseManagerUserSubscriptionsClient(override val config: LicenseManagerUserSubscriptionsClient.Config) : LicenseManagerUserSubscriptionsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates the user to an EC2 instance to utilize user-based subscriptions.
     */
    override suspend fun associateUser(input: AssociateUserRequest): AssociateUserResponse {
        val op = SdkHttpOperation.build<AssociateUserRequest, AssociateUserResponse> {
            serializer = AssociateUserOperationSerializer()
            deserializer = AssociateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the identity provider from providing user-based subscriptions.
     */
    override suspend fun deregisterIdentityProvider(input: DeregisterIdentityProviderRequest): DeregisterIdentityProviderResponse {
        val op = SdkHttpOperation.build<DeregisterIdentityProviderRequest, DeregisterIdentityProviderResponse> {
            serializer = DeregisterIdentityProviderOperationSerializer()
            deserializer = DeregisterIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the user from an EC2 instance providing user-based subscriptions.
     */
    override suspend fun disassociateUser(input: DisassociateUserRequest): DisassociateUserResponse {
        val op = SdkHttpOperation.build<DisassociateUserRequest, DisassociateUserResponse> {
            serializer = DisassociateUserOperationSerializer()
            deserializer = DisassociateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the identity providers for user-based subscriptions.
     */
    override suspend fun listIdentityProviders(input: ListIdentityProvidersRequest): ListIdentityProvidersResponse {
        val op = SdkHttpOperation.build<ListIdentityProvidersRequest, ListIdentityProvidersResponse> {
            serializer = ListIdentityProvidersOperationSerializer()
            deserializer = ListIdentityProvidersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIdentityProviders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the EC2 instances providing user-based subscriptions.
     */
    override suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse {
        val op = SdkHttpOperation.build<ListInstancesRequest, ListInstancesResponse> {
            serializer = ListInstancesOperationSerializer()
            deserializer = ListInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the user-based subscription products available from an identity provider.
     */
    override suspend fun listProductSubscriptions(input: ListProductSubscriptionsRequest): ListProductSubscriptionsResponse {
        val op = SdkHttpOperation.build<ListProductSubscriptionsRequest, ListProductSubscriptionsResponse> {
            serializer = ListProductSubscriptionsOperationSerializer()
            deserializer = ListProductSubscriptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProductSubscriptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists user associations for an identity provider.
     */
    override suspend fun listUserAssociations(input: ListUserAssociationsRequest): ListUserAssociationsResponse {
        val op = SdkHttpOperation.build<ListUserAssociationsRequest, ListUserAssociationsResponse> {
            serializer = ListUserAssociationsOperationSerializer()
            deserializer = ListUserAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUserAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an identity provider for user-based subscriptions.
     */
    override suspend fun registerIdentityProvider(input: RegisterIdentityProviderRequest): RegisterIdentityProviderResponse {
        val op = SdkHttpOperation.build<RegisterIdentityProviderRequest, RegisterIdentityProviderResponse> {
            serializer = RegisterIdentityProviderOperationSerializer()
            deserializer = RegisterIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a product subscription for a user with the specified identity provider.
     */
    override suspend fun startProductSubscription(input: StartProductSubscriptionRequest): StartProductSubscriptionResponse {
        val op = SdkHttpOperation.build<StartProductSubscriptionRequest, StartProductSubscriptionResponse> {
            serializer = StartProductSubscriptionOperationSerializer()
            deserializer = StartProductSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartProductSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a product subscription for a user with the specified identity provider.
     */
    override suspend fun stopProductSubscription(input: StopProductSubscriptionRequest): StopProductSubscriptionResponse {
        val op = SdkHttpOperation.build<StopProductSubscriptionRequest, StopProductSubscriptionResponse> {
            serializer = StopProductSubscriptionOperationSerializer()
            deserializer = StopProductSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopProductSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager-user-subscriptions"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "license-manager-user-subscriptions")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
