// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerusersubscriptions.paginators

import aws.sdk.kotlin.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsClient
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.IdentityProviderSummary
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.InstanceSummary
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.InstanceUserSummary
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListInstancesRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListInstancesResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ProductUserSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListIdentityProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdentityProvidersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProvidersResponse]
 */
public fun LicenseManagerUserSubscriptionsClient.listIdentityProvidersPaginated(initialRequest: ListIdentityProvidersRequest = ListIdentityProvidersRequest { }): Flow<ListIdentityProvidersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdentityProvidersPaginated.listIdentityProviders(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdentityProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProvidersResponse]
 */
public fun LicenseManagerUserSubscriptionsClient.listIdentityProvidersPaginated(block: ListIdentityProvidersRequest.Builder.() -> Unit): Flow<ListIdentityProvidersResponse> =
    listIdentityProvidersPaginated(ListIdentityProvidersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdentityProvidersPaginated]
 * to access the nested member [IdentityProviderSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IdentityProviderSummary]
 */
@JvmName("listIdentityProvidersResponseIdentityProviderSummary")
public fun Flow<ListIdentityProvidersResponse>.identityProviderSummaries(): Flow<IdentityProviderSummary> =
    transform() { response ->
        response.identityProviderSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstancesResponse]
 */
public fun LicenseManagerUserSubscriptionsClient.listInstancesPaginated(initialRequest: ListInstancesRequest = ListInstancesRequest { }): Flow<ListInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInstancesPaginated.listInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstancesResponse]
 */
public fun LicenseManagerUserSubscriptionsClient.listInstancesPaginated(block: ListInstancesRequest.Builder.() -> Unit): Flow<ListInstancesResponse> =
    listInstancesPaginated(ListInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstancesPaginated]
 * to access the nested member [InstanceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceSummary]
 */
@JvmName("listInstancesResponseInstanceSummary")
public fun Flow<ListInstancesResponse>.instanceSummaries(): Flow<InstanceSummary> =
    transform() { response ->
        response.instanceSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProductSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProductSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProductSubscriptionsResponse]
 */
public fun LicenseManagerUserSubscriptionsClient.listProductSubscriptionsPaginated(initialRequest: ListProductSubscriptionsRequest): Flow<ListProductSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProductSubscriptionsPaginated.listProductSubscriptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProductSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProductSubscriptionsResponse]
 */
public fun LicenseManagerUserSubscriptionsClient.listProductSubscriptionsPaginated(block: ListProductSubscriptionsRequest.Builder.() -> Unit): Flow<ListProductSubscriptionsResponse> =
    listProductSubscriptionsPaginated(ListProductSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProductSubscriptionsPaginated]
 * to access the nested member [ProductUserSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProductUserSummary]
 */
@JvmName("listProductSubscriptionsResponseProductUserSummary")
public fun Flow<ListProductSubscriptionsResponse>.productUserSummaries(): Flow<ProductUserSummary> =
    transform() { response ->
        response.productUserSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUserAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUserAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserAssociationsResponse]
 */
public fun LicenseManagerUserSubscriptionsClient.listUserAssociationsPaginated(initialRequest: ListUserAssociationsRequest): Flow<ListUserAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUserAssociationsPaginated.listUserAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUserAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserAssociationsResponse]
 */
public fun LicenseManagerUserSubscriptionsClient.listUserAssociationsPaginated(block: ListUserAssociationsRequest.Builder.() -> Unit): Flow<ListUserAssociationsResponse> =
    listUserAssociationsPaginated(ListUserAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUserAssociationsPaginated]
 * to access the nested member [InstanceUserSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceUserSummary]
 */
@JvmName("listUserAssociationsResponseInstanceUserSummary")
public fun Flow<ListUserAssociationsResponse>.instanceUserSummaries(): Flow<InstanceUserSummary> =
    transform() { response ->
        response.instanceUserSummaries?.forEach {
            emit(it)
        }
    }
