// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerusersubscriptions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an EC2 instance providing user-based subscriptions.
 */
public class InstanceSummary private constructor(builder: Builder) {
    /**
     * The ID of the EC2 instance, which provides user-based subscriptions.
     */
    public val instanceId: kotlin.String = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The date of the last status check.
     */
    public val lastStatusCheckDate: kotlin.String? = builder.lastStatusCheckDate
    /**
     * A list of provided user-based subscription products.
     */
    public val products: List<String> = requireNotNull(builder.products) { "A non-null value must be provided for products" }
    /**
     * The status of an EC2 instance resource.
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The status message for an EC2 instance.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.InstanceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceSummary(")
        append("instanceId=$instanceId,")
        append("lastStatusCheckDate=$lastStatusCheckDate,")
        append("products=$products,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId.hashCode()
        result = 31 * result + (lastStatusCheckDate?.hashCode() ?: 0)
        result = 31 * result + (products.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceSummary

        if (instanceId != other.instanceId) return false
        if (lastStatusCheckDate != other.lastStatusCheckDate) return false
        if (products != other.products) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.InstanceSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the EC2 instance, which provides user-based subscriptions.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The date of the last status check.
         */
        public var lastStatusCheckDate: kotlin.String? = null
        /**
         * A list of provided user-based subscription products.
         */
        public var products: List<String>? = null
        /**
         * The status of an EC2 instance resource.
         */
        public var status: kotlin.String? = null
        /**
         * The status message for an EC2 instance.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.InstanceSummary) : this() {
            this.instanceId = x.instanceId
            this.lastStatusCheckDate = x.lastStatusCheckDate
            this.products = x.products
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.InstanceSummary = InstanceSummary(this)

        internal fun correctErrors(): Builder {
            if (instanceId == null) instanceId = ""
            if (products == null) products = emptyList()
            if (status == null) status = ""
            return this
        }
    }
}
