// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerusersubscriptions

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.auth.DefaultLicenseManagerUserSubscriptionsAuthSchemeProvider
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.auth.LicenseManagerUserSubscriptionsAuthSchemeProvider
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.endpoints.DefaultLicenseManagerUserSubscriptionsEndpointProvider
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.endpoints.LicenseManagerUserSubscriptionsEndpointParameters
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.endpoints.LicenseManagerUserSubscriptionsEndpointProvider
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.AssociateUserRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.AssociateUserResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.DisassociateUserRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.DisassociateUserResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListInstancesRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListInstancesResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "License Manager User Subscriptions"
public const val SdkVersion: String = "1.1.22"
public const val ServiceApiVersion: String = "2018-05-10"

/**
 * With License Manager, you can create user-based subscriptions to utilize licensed software with a per user subscription fee on Amazon EC2 instances.
 */
public interface LicenseManagerUserSubscriptionsClient : SdkClient {
    /**
     * LicenseManagerUserSubscriptionsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, LicenseManagerUserSubscriptionsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "LicenseManagerUserSubscriptions",
                "LICENSE_MANAGER_USER_SUBSCRIPTIONS",
                "license_manager_user_subscriptions",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, LicenseManagerUserSubscriptionsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): LicenseManagerUserSubscriptionsClient = DefaultLicenseManagerUserSubscriptionsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: LicenseManagerUserSubscriptionsEndpointProvider = builder.endpointProvider ?: DefaultLicenseManagerUserSubscriptionsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: LicenseManagerUserSubscriptionsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultLicenseManagerUserSubscriptionsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "License Manager User Subscriptions"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: LicenseManagerUserSubscriptionsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: LicenseManagerUserSubscriptionsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates the user to an EC2 instance to utilize user-based subscriptions.
     *
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing periods that haven't closed (marked as **Pending** billing status) in Amazon Web Services Billing. For more information, see [Viewing your monthly charges](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html) in the *Amazon Web Services Billing User Guide*.
     */
    public suspend fun associateUser(input: AssociateUserRequest): AssociateUserResponse

    /**
     * Deregisters the identity provider from providing user-based subscriptions.
     */
    public suspend fun deregisterIdentityProvider(input: DeregisterIdentityProviderRequest): DeregisterIdentityProviderResponse

    /**
     * Disassociates the user from an EC2 instance providing user-based subscriptions.
     */
    public suspend fun disassociateUser(input: DisassociateUserRequest): DisassociateUserResponse

    /**
     * Lists the identity providers for user-based subscriptions.
     */
    public suspend fun listIdentityProviders(input: ListIdentityProvidersRequest = ListIdentityProvidersRequest { }): ListIdentityProvidersResponse

    /**
     * Lists the EC2 instances providing user-based subscriptions.
     */
    public suspend fun listInstances(input: ListInstancesRequest = ListInstancesRequest { }): ListInstancesResponse

    /**
     * Lists the user-based subscription products available from an identity provider.
     */
    public suspend fun listProductSubscriptions(input: ListProductSubscriptionsRequest): ListProductSubscriptionsResponse

    /**
     * Lists user associations for an identity provider.
     */
    public suspend fun listUserAssociations(input: ListUserAssociationsRequest): ListUserAssociationsResponse

    /**
     * Registers an identity provider for user-based subscriptions.
     */
    public suspend fun registerIdentityProvider(input: RegisterIdentityProviderRequest): RegisterIdentityProviderResponse

    /**
     * Starts a product subscription for a user with the specified identity provider.
     *
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing periods that haven't closed (marked as **Pending** billing status) in Amazon Web Services Billing. For more information, see [Viewing your monthly charges](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html) in the *Amazon Web Services Billing User Guide*.
     */
    public suspend fun startProductSubscription(input: StartProductSubscriptionRequest): StartProductSubscriptionResponse

    /**
     * Stops a product subscription for a user with the specified identity provider.
     */
    public suspend fun stopProductSubscription(input: StopProductSubscriptionRequest): StopProductSubscriptionResponse

    /**
     * Updates additional product configuration settings for the registered identity provider.
     */
    public suspend fun updateIdentityProviderSettings(input: UpdateIdentityProviderSettingsRequest): UpdateIdentityProviderSettingsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun LicenseManagerUserSubscriptionsClient.withConfig(block: LicenseManagerUserSubscriptionsClient.Config.Builder.() -> Unit): LicenseManagerUserSubscriptionsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultLicenseManagerUserSubscriptionsClient(newConfig)
}

/**
 * Associates the user to an EC2 instance to utilize user-based subscriptions.
 *
 * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing periods that haven't closed (marked as **Pending** billing status) in Amazon Web Services Billing. For more information, see [Viewing your monthly charges](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html) in the *Amazon Web Services Billing User Guide*.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.associateUser(crossinline block: AssociateUserRequest.Builder.() -> Unit): AssociateUserResponse = associateUser(AssociateUserRequest.Builder().apply(block).build())

/**
 * Deregisters the identity provider from providing user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.deregisterIdentityProvider(crossinline block: DeregisterIdentityProviderRequest.Builder.() -> Unit): DeregisterIdentityProviderResponse = deregisterIdentityProvider(DeregisterIdentityProviderRequest.Builder().apply(block).build())

/**
 * Disassociates the user from an EC2 instance providing user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.disassociateUser(crossinline block: DisassociateUserRequest.Builder.() -> Unit): DisassociateUserResponse = disassociateUser(DisassociateUserRequest.Builder().apply(block).build())

/**
 * Lists the identity providers for user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.listIdentityProviders(crossinline block: ListIdentityProvidersRequest.Builder.() -> Unit): ListIdentityProvidersResponse = listIdentityProviders(ListIdentityProvidersRequest.Builder().apply(block).build())

/**
 * Lists the EC2 instances providing user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.listInstances(crossinline block: ListInstancesRequest.Builder.() -> Unit): ListInstancesResponse = listInstances(ListInstancesRequest.Builder().apply(block).build())

/**
 * Lists the user-based subscription products available from an identity provider.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.listProductSubscriptions(crossinline block: ListProductSubscriptionsRequest.Builder.() -> Unit): ListProductSubscriptionsResponse = listProductSubscriptions(ListProductSubscriptionsRequest.Builder().apply(block).build())

/**
 * Lists user associations for an identity provider.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.listUserAssociations(crossinline block: ListUserAssociationsRequest.Builder.() -> Unit): ListUserAssociationsResponse = listUserAssociations(ListUserAssociationsRequest.Builder().apply(block).build())

/**
 * Registers an identity provider for user-based subscriptions.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.registerIdentityProvider(crossinline block: RegisterIdentityProviderRequest.Builder.() -> Unit): RegisterIdentityProviderResponse = registerIdentityProvider(RegisterIdentityProviderRequest.Builder().apply(block).build())

/**
 * Starts a product subscription for a user with the specified identity provider.
 *
 * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing periods that haven't closed (marked as **Pending** billing status) in Amazon Web Services Billing. For more information, see [Viewing your monthly charges](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html) in the *Amazon Web Services Billing User Guide*.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.startProductSubscription(crossinline block: StartProductSubscriptionRequest.Builder.() -> Unit): StartProductSubscriptionResponse = startProductSubscription(StartProductSubscriptionRequest.Builder().apply(block).build())

/**
 * Stops a product subscription for a user with the specified identity provider.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.stopProductSubscription(crossinline block: StopProductSubscriptionRequest.Builder.() -> Unit): StopProductSubscriptionResponse = stopProductSubscription(StopProductSubscriptionRequest.Builder().apply(block).build())

/**
 * Updates additional product configuration settings for the registered identity provider.
 */
public suspend inline fun LicenseManagerUserSubscriptionsClient.updateIdentityProviderSettings(crossinline block: UpdateIdentityProviderSettingsRequest.Builder.() -> Unit): UpdateIdentityProviderSettingsResponse = updateIdentityProviderSettings(UpdateIdentityProviderSettingsRequest.Builder().apply(block).build())
