// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerusersubscriptions

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.auth.LicenseManagerUserSubscriptionsAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.auth.LicenseManagerUserSubscriptionsIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.model.*
import aws.sdk.kotlin.services.licensemanagerusersubscriptions.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultLicenseManagerUserSubscriptionsClient(override val config: LicenseManagerUserSubscriptionsClient.Config) : LicenseManagerUserSubscriptionsClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = LicenseManagerUserSubscriptionsIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "license-manager-user-subscriptions")
        }
        toMap()
    }
    private val authSchemeAdapter = LicenseManagerUserSubscriptionsAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.licensemanagerusersubscriptions"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates the user to an EC2 instance to utilize user-based subscriptions.
     *
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing periods that haven't closed (marked as **Pending** billing status) in Amazon Web Services Billing. For more information, see [Viewing your monthly charges](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html) in the *Amazon Web Services Billing User Guide*.
     */
    override suspend fun associateUser(input: AssociateUserRequest): AssociateUserResponse {
        val op = SdkHttpOperation.build<AssociateUserRequest, AssociateUserResponse> {
            serializeWith = AssociateUserOperationSerializer()
            deserializeWith = AssociateUserOperationDeserializer()
            operationName = "AssociateUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the identity provider from providing user-based subscriptions.
     */
    override suspend fun deregisterIdentityProvider(input: DeregisterIdentityProviderRequest): DeregisterIdentityProviderResponse {
        val op = SdkHttpOperation.build<DeregisterIdentityProviderRequest, DeregisterIdentityProviderResponse> {
            serializeWith = DeregisterIdentityProviderOperationSerializer()
            deserializeWith = DeregisterIdentityProviderOperationDeserializer()
            operationName = "DeregisterIdentityProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the user from an EC2 instance providing user-based subscriptions.
     */
    override suspend fun disassociateUser(input: DisassociateUserRequest): DisassociateUserResponse {
        val op = SdkHttpOperation.build<DisassociateUserRequest, DisassociateUserResponse> {
            serializeWith = DisassociateUserOperationSerializer()
            deserializeWith = DisassociateUserOperationDeserializer()
            operationName = "DisassociateUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the identity providers for user-based subscriptions.
     */
    override suspend fun listIdentityProviders(input: ListIdentityProvidersRequest): ListIdentityProvidersResponse {
        val op = SdkHttpOperation.build<ListIdentityProvidersRequest, ListIdentityProvidersResponse> {
            serializeWith = ListIdentityProvidersOperationSerializer()
            deserializeWith = ListIdentityProvidersOperationDeserializer()
            operationName = "ListIdentityProviders"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the EC2 instances providing user-based subscriptions.
     */
    override suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse {
        val op = SdkHttpOperation.build<ListInstancesRequest, ListInstancesResponse> {
            serializeWith = ListInstancesOperationSerializer()
            deserializeWith = ListInstancesOperationDeserializer()
            operationName = "ListInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the user-based subscription products available from an identity provider.
     */
    override suspend fun listProductSubscriptions(input: ListProductSubscriptionsRequest): ListProductSubscriptionsResponse {
        val op = SdkHttpOperation.build<ListProductSubscriptionsRequest, ListProductSubscriptionsResponse> {
            serializeWith = ListProductSubscriptionsOperationSerializer()
            deserializeWith = ListProductSubscriptionsOperationDeserializer()
            operationName = "ListProductSubscriptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists user associations for an identity provider.
     */
    override suspend fun listUserAssociations(input: ListUserAssociationsRequest): ListUserAssociationsResponse {
        val op = SdkHttpOperation.build<ListUserAssociationsRequest, ListUserAssociationsResponse> {
            serializeWith = ListUserAssociationsOperationSerializer()
            deserializeWith = ListUserAssociationsOperationDeserializer()
            operationName = "ListUserAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Registers an identity provider for user-based subscriptions.
     */
    override suspend fun registerIdentityProvider(input: RegisterIdentityProviderRequest): RegisterIdentityProviderResponse {
        val op = SdkHttpOperation.build<RegisterIdentityProviderRequest, RegisterIdentityProviderResponse> {
            serializeWith = RegisterIdentityProviderOperationSerializer()
            deserializeWith = RegisterIdentityProviderOperationDeserializer()
            operationName = "RegisterIdentityProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a product subscription for a user with the specified identity provider.
     *
     * Your estimated bill for charges on the number of users and related costs will take 48 hours to appear for billing periods that haven't closed (marked as **Pending** billing status) in Amazon Web Services Billing. For more information, see [Viewing your monthly charges](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html) in the *Amazon Web Services Billing User Guide*.
     */
    override suspend fun startProductSubscription(input: StartProductSubscriptionRequest): StartProductSubscriptionResponse {
        val op = SdkHttpOperation.build<StartProductSubscriptionRequest, StartProductSubscriptionResponse> {
            serializeWith = StartProductSubscriptionOperationSerializer()
            deserializeWith = StartProductSubscriptionOperationDeserializer()
            operationName = "StartProductSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops a product subscription for a user with the specified identity provider.
     */
    override suspend fun stopProductSubscription(input: StopProductSubscriptionRequest): StopProductSubscriptionResponse {
        val op = SdkHttpOperation.build<StopProductSubscriptionRequest, StopProductSubscriptionResponse> {
            serializeWith = StopProductSubscriptionOperationSerializer()
            deserializeWith = StopProductSubscriptionOperationDeserializer()
            operationName = "StopProductSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates additional product configuration settings for the registered identity provider.
     */
    override suspend fun updateIdentityProviderSettings(input: UpdateIdentityProviderSettingsRequest): UpdateIdentityProviderSettingsResponse {
        val op = SdkHttpOperation.build<UpdateIdentityProviderSettingsRequest, UpdateIdentityProviderSettingsResponse> {
            serializeWith = UpdateIdentityProviderSettingsOperationSerializer()
            deserializeWith = UpdateIdentityProviderSettingsOperationDeserializer()
            operationName = "UpdateIdentityProviderSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "license-manager-user-subscriptions")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
