// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A third-party provider for operating system (OS) platform software and license subscriptions, such as Red Hat. When you register a third-party Linux subscription provider, License Manager can get subscription data from the registered provider.
 */
public class RegisteredSubscriptionProvider private constructor(builder: Builder) {
    /**
     * The timestamp from the last time that License Manager accessed third-party subscription data for your account from your registered Linux subscription provider.
     */
    public val lastSuccessfulDataRetrievalTime: kotlin.String? = builder.lastSuccessfulDataRetrievalTime
    /**
     * The Amazon Resource Name (ARN) of the Secrets Manager secret that stores your registered Linux subscription provider access token. For RHEL account subscriptions, this is the offline token.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
     */
    public val subscriptionProviderArn: kotlin.String? = builder.subscriptionProviderArn
    /**
     * A supported third-party Linux subscription provider. License Manager currently supports Red Hat subscriptions.
     */
    public val subscriptionProviderSource: aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.SubscriptionProviderSource? = builder.subscriptionProviderSource
    /**
     * Indicates the status of your registered Linux subscription provider access token from the last time License Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the offline token.
     */
    public val subscriptionProviderStatus: aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.SubscriptionProviderStatus? = builder.subscriptionProviderStatus
    /**
     * A detailed message that's associated with your BYOL subscription provider token status.
     */
    public val subscriptionProviderStatusMessage: kotlin.String? = builder.subscriptionProviderStatusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisteredSubscriptionProvider(")
        append("lastSuccessfulDataRetrievalTime=$lastSuccessfulDataRetrievalTime,")
        append("secretArn=$secretArn,")
        append("subscriptionProviderArn=$subscriptionProviderArn,")
        append("subscriptionProviderSource=$subscriptionProviderSource,")
        append("subscriptionProviderStatus=$subscriptionProviderStatus,")
        append("subscriptionProviderStatusMessage=$subscriptionProviderStatusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastSuccessfulDataRetrievalTime?.hashCode() ?: 0
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (subscriptionProviderArn?.hashCode() ?: 0)
        result = 31 * result + (subscriptionProviderSource?.hashCode() ?: 0)
        result = 31 * result + (subscriptionProviderStatus?.hashCode() ?: 0)
        result = 31 * result + (subscriptionProviderStatusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisteredSubscriptionProvider

        if (lastSuccessfulDataRetrievalTime != other.lastSuccessfulDataRetrievalTime) return false
        if (secretArn != other.secretArn) return false
        if (subscriptionProviderArn != other.subscriptionProviderArn) return false
        if (subscriptionProviderSource != other.subscriptionProviderSource) return false
        if (subscriptionProviderStatus != other.subscriptionProviderStatus) return false
        if (subscriptionProviderStatusMessage != other.subscriptionProviderStatusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp from the last time that License Manager accessed third-party subscription data for your account from your registered Linux subscription provider.
         */
        public var lastSuccessfulDataRetrievalTime: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Secrets Manager secret that stores your registered Linux subscription provider access token. For RHEL account subscriptions, this is the offline token.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Linux subscription provider resource that you registered.
         */
        public var subscriptionProviderArn: kotlin.String? = null
        /**
         * A supported third-party Linux subscription provider. License Manager currently supports Red Hat subscriptions.
         */
        public var subscriptionProviderSource: aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.SubscriptionProviderSource? = null
        /**
         * Indicates the status of your registered Linux subscription provider access token from the last time License Manager retrieved subscription data. For RHEL account subscriptions, this is the status of the offline token.
         */
        public var subscriptionProviderStatus: aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.SubscriptionProviderStatus? = null
        /**
         * A detailed message that's associated with your BYOL subscription provider token status.
         */
        public var subscriptionProviderStatusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider) : this() {
            this.lastSuccessfulDataRetrievalTime = x.lastSuccessfulDataRetrievalTime
            this.secretArn = x.secretArn
            this.subscriptionProviderArn = x.subscriptionProviderArn
            this.subscriptionProviderSource = x.subscriptionProviderSource
            this.subscriptionProviderStatus = x.subscriptionProviderStatus
            this.subscriptionProviderStatusMessage = x.subscriptionProviderStatusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider = RegisteredSubscriptionProvider(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
